<?php
/**
 * Lost password form
 *
 * @author  Themezaa
 * @package H-Code
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

wc_print_notices(); ?>

<div class="col-md-12">

	<form method="post" class="woocommerce-ResetPassword lost_reset_password">

		<p><?php echo apply_filters( 'woocommerce_lost_password_message', __( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'woocommerce' ) ); ?></p>

		<p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
			<label for="user_login"><?php _e( 'Username or email', 'woocommerce' ); ?></label>
			<input class="woocommerce-Input woocommerce-Input--text input-text" type="text" name="user_login" id="user_login" />
		</p>

		<div class="clear"></div>

		<?php do_action( 'woocommerce_lostpassword_form' ); ?>

		<p class="woocommerce-form-row form-row">
			<input type="hidden" name="wc_reset_password" value="true" />
			<input type="submit" class="woocommerce-Button highlight-button btn-small margin-right-20px xs-margin-five-bottom button btn" value="<?php esc_attr_e( 'Reset password', 'woocommerce' ); ?>" />
		</p>

		<?php wp_nonce_field( 'lost_password' ); ?>

	</form>

</div>
