<?php
/**
 * Header Tab For Theme Option.
 *
 * @package H-Code
 */
?>
<?php
$this->sections[] = array(
    'icon' => 'fa fa-header',
    'title' => esc_html__('Header', 'H-Code'),
    'desc' => esc_html__('Header section configuration settings', 'H-Code'),
    'fields' => array(
          array(
            'id'       => 'hcode_enable_header',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Header', 'H-Code'),
            'default'  => true,
            '1'       => 'On',
            '0'      => 'Off',
          ),
          array(
            'id'       => 'hcode_header_layout',
            'type'     => 'images',
            'title'    => esc_html__('Select a Header Style', 'H-Code'),
            'options'  => hcode_get_header_layout( 'preview' ),
            'imgtitle' => hcode_get_header_layout( 'title' ),
            'default'  => 'headertype1',
            'validate' => 'not_empty'
          ),
          array(
            'id'       => 'hcode_header_text_color',
            'type'     => 'select',
            'title'    => esc_html__('Header Text Color', 'H-Code'),
            'options' => array(
                'nav-black' => esc_html__('Black', 'H-Code'),
                'nav-white' => esc_html__('White', 'H-Code'),
            ),
            'default' => 'nav-black',
          ),
          array(
            'id'       => 'hcode_header_logo_position',
            'type'     => 'select',
            'title'    => esc_html__('Header Logo Position', 'H-Code'),
            'options' => array(
                'left' => esc_html__('Left', 'H-Code'),
                'center' => esc_html__('Center', 'H-Code'),
                'top' => esc_html__('Top', 'H-Code'),
            ),
            'default'  => 'left',
            'required'  => array('hcode_header_layout', 'equals', array('headertype1', 'headertype2', 'headertype3', 'headertype4', 'headertype5', 'headertype6', 'headertype7', 'headertype8') ),
          ),
          array(
              'id'       => 'hcode_menu_image',
              'type'     => 'media',
              'preview'  => true,
              'url'      => true,
              'title'    => esc_html__('Menu Background Image', 'H-Code' ),
              'required'  => array('hcode_header_layout', 'equals', array( 'headertype10', 'headertype11' ) ),
          ),
          array(
              'id'       => 'hcode_menu_logo',
              'type'     => 'media',
              'preview'  => true,
              'url'      => true,
              'title'    => esc_html__('Menu Logo', 'H-Code' ),
              'required'  => array('hcode_header_layout', 'equals', array( 'headertype10' ) ),
          ),
          array(
              'id'       => 'hcode_enable_menu_social_icons',
              'type'     => 'switch',
              'title'    => esc_html__('Enable Menu Social Icons', 'H-Code'),
              'default'  => false,
              '1'       => 'On',
              '0'      => 'Off',
              'required'  => array('hcode_header_layout', 'equals', array( 'headertype9', 'headertype10', 'headertype11' ) ),
          ),
          array(
              'id'        => 'hcode_menu_social_sidebar',
              'type'      => 'select',
              'title'     => esc_html__('Menu Social Sidebar', 'H-Code'),
              'subtitle'  => esc_html__('Select custom sidebar', 'H-Code'),
              'data'      => 'sidebar',
              'default'   => '',
              'required'  => array('hcode_enable_menu_social_icons', 'equals', '1'),
          ),
          array(
              'id'       => 'hcode_enable_menu_separator',
              'type'     => 'switch',
              'title'    => esc_html__('Enable Menu Separator', 'H-Code'),
              'default'  => false,
              '1'       => 'On',
              '0'      => 'Off',
              'required'  => array('hcode_header_layout', 'equals', array( 'headertype11' ) ),
          ),
          array(
            'id' => 'hcode_logo_setting',
            'type' => 'info_title',
            'title' => esc_html__('Logo Settings', 'H-Code'),
          ),
          array(
            'id'       => 'hcode_header_logo',
            'type'     => 'media',
            'preview'  => true,
            'url'      => true,  
            'title'    => esc_html__( 'Logo', 'H-Code' ),
            'subtitle' => esc_html__( 'Upload the logo that will be displayed in the header', 'H-Code' ),
          ),
          array(
            'id'       => 'hcode_header_light_logo',
            'type'     => 'media',
            'preview'  => true,
            'url'      => true,  
            'title'    => esc_html__( 'Logo (Light)', 'H-Code' ),
            'subtitle' => esc_html__( 'Upload a light version of logo used in dark backgrounds header template', 'H-Code' ),
          ),
          array(
            'id'       => 'hcode_retina_logo',
            'type'     => 'media',
            'preview'  => true,
            'url'      => true,  
            'title'    => esc_html__( 'Logo Retina', 'H-Code' ),
            'subtitle' => esc_html__( 'Optional retina version displayed in devices with retina display (high resolution display).', 'H-Code' ),
          ),
          array(
            'id'       => 'hcode_retina_logo_light',
            'type'     => 'media',
            'preview'  => true,
            'url'      => true,  
            'title'    => esc_html__( 'Logo Retina (Light)', 'H-Code' ),
            'subtitle' => esc_html__( '(Upload a light version of logo) optional retina version displayed in devices with retina display (high resolution display).', 'H-Code' ),
          ),
          array(
              'id' => 'hcode_retina_logo_width',
              'type' => 'text',
              'title' => esc_html__('Retina logo Width', 'H-Code'),
              'default' => '109px',
              'subtitle' => esc_html__('Specify the width in pixel eg. 15px', 'H-Code'),
          ),
          array(
              'id' => 'hcode_retina_logo_height',
              'type' => 'text',
              'title' => esc_html__('Retina logo Height', 'H-Code'),
              'default' => '34px',
              'subtitle' => esc_html__('Specify the height in pixel eg. 15px', 'H-Code'),
          ),
          array(
            'id' => 'hcode_module_setting',
            'type' => 'info_title',
            'title' => esc_html__('Modules Settings', 'H-Code'),
          ),
          array(
            'id'       => 'hcode_header_search',
            'type'     => 'switch',
            'title'    => esc_html__('Search Modules', 'H-Code'),
            'default'  => false,
            'subtitle' => esc_html__('If on, a search module will be displayed in header section', 'H-Code'),
            '1'       => 'On',
            '0'      => 'Off',
          ), 
          array(
              'id'       => 'hcode_header_cart',
              'type'     => 'switch',
              'title'    => esc_html__('Cart Module', 'H-Code'),
              'default'  => false,
              'subtitle' => esc_html__('If on, a cart module will be displayed in header section. It will only work if WooCommerce plugin is installed and active.', 'H-Code'),
              '1'       => 'On',
              '0'      => 'Off',
          ),
          array(
            'id'       => 'hcode_header_mini_cart',
            'type'     => 'select',
            'title'    => esc_html__('Header Mini cart', 'H-Code'),
            'data'     => 'sidebars',
            'default' => 'hcode-mini-cart',
            'required'  => array('hcode_header_cart', 'equals', '1'),
          ),
    )
);