<?php
/**
 * Color Settings Tab For Theme Option.
 *
 * @package H-Code
 */
?>
<?php
$this->sections[] = array(
    'icon' => 'fa fa-tint',
    'title' => esc_html__('Color Settings', 'H-Code'),
    'desc' => esc_html__('Configure content styles', 'H-Code'),
    'fields' => array(
            array(
                'id'        => 'opt-accordion-begin-general',
                'type'      => 'accordion',
                'title'     => esc_html__('Background Color', 'H-Code'),
                'subtitle'  => esc_html__('Set background color', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'body-bg-color',
                'type'     => 'color',
                'title'    => __( 'Body Background', 'H-Code' ),
                'default'  => '',
                'output' => array('background' => 'body'),
            ),
            array(
                'id'       => 'bg-black-overlay-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0, 0, 0, 0.85)"></div>'.__( 'Black Background Opacity', 'H-Code' ),
                //'default'  => 'rgba(27, 22, 28, 0.9)',
                'output' => array('background' => '.bg-blck-overlay'),
                'default' =>  array( 'color' => '#000', 'alpha' => '0.85' ),
            ),
            array(
                'id'       => 'text-bg-white',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'White Background', 'H-Code' ),
                'default'  => '#FFF',
                'output'    => array('background' => '.bg-white'),
            ),
            array(
                'id'       => 'text-bg-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e6af2a"></div>'.__( 'Yellow Background', 'H-Code' ),
                'default'  => '#e6af2a',
                'output' => array('background' => '.bg-yellow'),
            ),
            array(
                'id'       => 'text-bg-deep-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f7f5e7"></div>'.__( 'Deep Yellow Background', 'H-Code' ),
                'default'  => '#f7f5e7',
                'output' => array('background' => '.bg-deep-yellow'),
            ),
            array(
                'id'       => 'text-bg-golden-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#c3bd86"></div>'.__( 'Deep Golden Background', 'H-Code' ),
                'default'  => '#c3bd86',
                'output' => array('background' => '.bg-golden-yellow'),
            ),

            array(
                'id'       => 'text-bg-fast-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fdd947"></div>'.__( 'Fast Yellow Background', 'H-Code' ),
                'default'  => '#fdd947',
                'output' => array('background' => '.bg-fast-yellow'),
            ),
            array(
                'id'       => 'text-bg-dark-gray',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#252525"></div>'.__( 'Dark Gray Background', 'H-Code' ),
                'default'  => '#252525',
                'output' => array('background' => '.bg-dark-gray'),
            ),
            array(
                'id'       => 'text-bg-mid-gray',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d4d4d4"></div>'.__( 'Dark Mid Background', 'H-Code' ),
                'default'  => '#d4d4d4',
                'output' => array('background' => '.bg-mid-gray'),
            ),
            array(
                'id'       => 'text-bg-black',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Black Background', 'H-Code' ),
                'default'  => '#000',
                'output' => array('background' => '.bg-black'),
            ),
            array(
                'id'       => 'text-bg-green',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#70bd5b"></div>'.__( 'Green Background', 'H-Code' ),
                'default'  => '#70bd5b',
                'output' => array('background' => '.bg-green'),
            ),
            array(
                'id'       => 'text-bg-gray',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f6f6f6"></div>'.__( 'Gray Background', 'H-Code' ),
                'default'  => '#f6f6f6',
                'output' => array('background' => '.bg-gray'),
            ),
            array(
                'id'       => 'text-bg-yellow-ochre',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#997546"></div>'.__( 'Yellow Ochre Background', 'H-Code' ),
                'default'  => '#997546',
                'output' => array('background' => '.bg-yellow-ochre'),
            ),
            array(
                'id'       => 'text-bg-deep-brown',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#544441"></div>'.__( 'Deep Brown Background', 'H-Code' ),
                'default'  => '#544441',
                'output' => array('background' => '.bg-deep-brown'),
            ),
            array(
                'id'       => 'text-bg-orange',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#c24742"></div>'.__( 'Orange Background', 'H-Code' ),
                'default'  => '#c24742',
                'output' => array('background' => '.bg-orange'),
            ),
            array(
                'id'       => 'text-bg-deep-orange',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f15a22"></div>'.__( 'Deep Orange Background', 'H-Code' ),
                'default'  => '#f15a22',
                'output' => array('background' => '.bg-deep-orange'),
            ),
            array(
                'id'       => 'text-bg-fast-orange',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ff513b"></div>'.__( 'Fast Orange Background', 'H-Code' ),
                'default'  => '#ff513b',
                'output' => array('background' => '.bg-fast-orange'),
            ),
            array(
                'id'       => 'text-bg-pink',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#c2345f"></div>'.__( 'Pink Background', 'H-Code' ),
                'default'  => '#c2345f',
                'output' => array('background' => '.bg-pink'),
            ),
            array(
                'id'       => 'text-bg-deep-red',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e75e50"></div>'.__( 'Deep Red Background', 'H-Code' ),
                'default'  => '#e75e50',
                'output' => array('background' => '.bg-deep-red'),
            ),
            array(
                'id'       => 'text-bg-red',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d21616"></div>'.__( 'Red Background', 'H-Code' ),
                'default'  => '#d21616',
                'output' => array('background' => '.bg-red'),
            ),
            array(
                'id'       => 'text-bg-deep-pink',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e53878"></div>'.__( 'Deep Pink Background', 'H-Code' ),
                'default'  => '#e53878',
                'output' => array('background' => '.bg-deep-pink'),
            ),
            array(
                'id'       => 'text-bg-light-pink',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#dc378e"></div>'.__( 'Light Pink Background', 'H-Code' ),
                'default'  => '#dc378e',
                'output' => array('background' => '.bg-light-pink'),
            ),
            array(
                'id'       => 'text-bg-fast-pink',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ff1a56"></div>'.__( 'Fast Pink Background', 'H-Code' ),
                'default'  => '#ff1a56',
                'output' => array('background' => '.bg-fast-pink'),
            ),
            array(
                'id'       => 'text-bg-magenta',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d94378"></div>'.__( 'Magenta Background', 'H-Code' ),
                'default'  => '#d94378',
                'output' => array('background' => '.bg-magenta'),
            ),
            array(
                'id'       => 'text-bg-light-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f8f7f5"></div>'.__( 'Light Yellow Background', 'H-Code' ),
                'default'  => '#f8f7f5',
                'output' => array('background' => '.bg-light-yellow'),
            ),
            array(
                'id'       => 'text-bg-dark-green',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#60a532"></div>'.__( 'Dark Green Background', 'H-Code' ),
                'default'  => '#60a532',
                'output' => array('background' => '.bg-dark-green'),
            ),
            array(
                'id'       => 'text-bg-dark-blue',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#3273a5"></div>'.__( 'Dark Blue Background', 'H-Code' ),
                'default'  => '#3273a5',
                'output' => array('background' => '.bg-dark-blue'),
            ),
            array(
                'id'       => 'text-bg-violet',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#6c407e"></div>'.__( 'Violet Background', 'H-Code' ),
                'default'  => '#6c407e',
                'output' => array('background' => '.bg-violet'),
            ),
            array(
                'id'       => 'text-bg-light-gray',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f8f7f7"></div>'.__( 'Light gray Background', 'H-Code' ),
                'default'  => '#f8f7f7',
                'output' => array('background' => '.bg-light-gray'),
            ),
            array(
                'id'       => 'text-bg-light-gray2',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f4f4f4"></div>'.__( 'Light Gray2 Background', 'H-Code' ),
                'default'  => '#f4f4f4',
                'output' => array('background' => '.bg-light-gray2'),
            ),
            array(
                'id'       => 'text-bg-light-gray3',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fcfcfc"></div>'.__( 'Light Gray3 Background', 'H-Code' ),
                'default'  => '#fcfcfc',
                'output' => array('background' => '.bg-light-gray3'),
            ),
            array(
                'id'       => 'text-bg-slider-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27, 22, 28, 0.9)"></div>'.__( 'Slider Background', 'H-Code' ),
                //'default'  => 'rgba(27, 22, 28, 0.9)',
                'output' => array('background' => '.bg-slider'),
                'default' =>  array( 'color' => '#1b161c', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-wide-separator-line',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e5e5e5"></div>'.__( 'Wide Separator Line Background', 'H-Code' ),
                'default'  => '#e5e5e5',
                'output' => array('background' => '.wide-separator-line'),
            ),
            array(
                'id'       => 'text-bg-video-background-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(67,67,67,0.5)"></div>'.__( 'Video Background', 'H-Code' ),
                //'default'  => 'rgba(67,67,67,0.5)',
                'output' => array('background' => '.video-background'),
                'default'       =>  array( 'color' => '#434343', 'alpha' => '0.5' ),
            ),
            
            array(
                'id'       => 'text-bg-overlay-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ffca18"></div>'.__( 'Overlay Yellow Background', 'H-Code' ),
                'default'  => '#ffca18',
                'output' => array('background' => '.overlay-yellow'),
            ),
            array(
                'id'       => 'text-bg-overlay-blue',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#8ac4fe"></div>'.__( 'Overlay Blue Background', 'H-Code' ),
                'default'  => '#8ac4fe',
                'output' => array('background' => '.overlay-blue'),
            ),
            array(
                'id'       => 'text-bg-overlay-gray',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f4f5f6"></div>'.__( 'Overlay gray Background', 'H-Code' ),
                'default'  => '#f4f5f6',
                'output' => array('background' => '.overlay-gray'),
            ),
            array(
                'id'       => 'text-bg-overlay-green',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#71f1b9"></div>'.__( 'Overlay Green Background', 'H-Code' ),
                'default'  => '#71f1b9',
                'output' => array('background' => '.overlay-green'),
            ),
            array(
                'id'        => 'opt-accordion-end-general',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            /* Header Colors */
            
            array(
                'id'        => 'opt-accordion-begin-general',
                'type'      => 'accordion',
                'title'     => esc_html__('Header Background Color', 'H-Code'),
                'subtitle'  => esc_html__('Set header background color', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'default-nav',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fff"></div>'.__( 'Default Header Background', 'H-Code' ),
                'default'  => '#fff',
                'output' => array('background' => '.transparent-header.shrink-nav'),
            ),
            array(
                'id'       => 'text-bg-dropdown-menu',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27,22,28,0.95)"></div>'.__( 'Default Header - Dropdown Menu Background', 'H-Code' ),
                //'default'  => 'rgba(27,22,28,0.95)',
                'output' => array('background' => '.dropdown-menu, .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'text-bg-cart-content-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27, 22, 28, 0.95)"></div>'.__( 'Default Header - Cart Content Background', 'H-Code' ),
                //'default'  => 'rgba(27, 22, 28, 0.95)',
                'output' => array('background' => '.cart-content'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'white-nav',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fff"></div>'.__( 'White Header Background', 'H-Code' ),
                'default'  => '#fff',
                'output' => array('background' => '.white-header, .white-header.shrink-nav'),
            ),
            array(
                'id'       => 'white-nav-dropdown-menu',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27,22,28,0.95)"></div>'.__( 'White Header - Dropdown Menu Background', 'H-Code' ),
                //'default'  => 'rgba(27,22,28,0.95)',
                'output' => array('background' => '.white-header .dropdown-menu, .white-header .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'white-nav-cart-content-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27, 22, 28, 0.95)"></div>'.__( 'White Header - Cart Content Background', 'H-Code' ),
                //'default'  => 'rgba(27, 22, 28, 0.95)',
                'output' => array('background' => '.white-header .cart-content'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'sticky-nav',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fff"></div>'.__( 'Sticky Header Background', 'H-Code' ),
                'default'  => '#fff',
                'output' => array('background' => '.static-sticky, header .static-sticky'),
            ),
            array(
                'id'       => 'sticky-nav-dropdown-menu',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27,22,28,0.95)"></div>'.__( 'Sticky Header - Dropdown Menu Background', 'H-Code' ),
                //'default'  => 'rgba(27,22,28,0.95)',
                'output' => array('background' => 'header .static-sticky .dropdown-menu, header .static-sticky .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu, .static-sticky .dropdown-menu, .static-sticky .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'sticky-nav-cart-content-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27, 22, 28, 0.95)"></div>'.__( 'Sticky Header - Cart Content Background', 'H-Code' ),
                //'default'  => 'rgba(27, 22, 28, 0.95)',
                'output' => array('background' => 'header .static-sticky .cart-content, .static-sticky .cart-content'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'gray-sticky-nav',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f6f6f6"></div>'.__( 'Gray Sticky Header Background', 'H-Code' ),
                'default'  => '#f6f6f6',
                'output' => array('background' => 'header .static-sticky-gray'),
            ),
            array(
                'id'       => 'gray-sticky-nav-dropdown-menu',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27,22,28,0.95)"></div>'.__( 'Gray Sticky Header - Dropdown Menu Background', 'H-Code' ),
                //'default'  => 'rgba(27,22,28,0.95)',
                'output' => array('background' => 'header .static-sticky-gray .dropdown-menu, header .static-sticky-gray .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'gray-sticky-nav-cart-content-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27, 22, 28, 0.95)"></div>'.__( 'Gray Sticky Header - Cart Content Background', 'H-Code' ),
                //'default'  => 'rgba(27, 22, 28, 0.95)',
                'output' => array('background' => 'header .static-sticky-gray .cart-content'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'text-bg-nav-dark',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Dark Header Background', 'H-Code' ),
                'default'  => '#000',
                'output' => array('background' => '.nav-dark'),
            ),
            array(
                'id'       => 'dark-header-dropdown',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Dark Header - Dropdown Menu Background', 'H-Code' ),
                //'default'  => 'rgba(0,0,0,0.9)',
                'output' => array('background' => '.nav-dark .dropdown-menu, .nav-dark .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'dark-header-cart',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Dark Header - Cart Content Background', 'H-Code' ),
                //'default'  => 'rgba(0,0,0,0.9)',
                'output' => array('background' => '.nav-dark .cart-content'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            
            array(
                'id'       => 'text-bg-nav-dark-transparent-rgb',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.8)"></div>'.__( 'Transparent Dark Header Background', 'H-Code' ),
                //'default'  => 'rgba(0,0,0,0.8)',
                'output' => array('background' => '.nav-dark-transparent'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.8' ),
            ),
            array(
                'id'       => 'text-bg-nav-dark-transparent-dropdown',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Transparent Dark Header - Dropdown Menu Background', 'H-Code' ),
                //'default'  => 'rgba(0,0,0,0.9)',
                'output' => array('background' => '.nav-dark-transparent .dropdown-menu, .nav-dark-transparent .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-dark-transparent-cart',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Transparent Dark Header - Cart Content Background', 'H-Code' ),
                //'default'  => 'rgba(0,0,0,0.9)',
                'output' => array('background' => '.nav-dark-transparent .cart-content'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-light-transparent',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(255,255,255,0.8)"></div>'.__( 'Transparent Light Header Background', 'H-Code' ),
                //'default'  => 'rgba(255,255,255,0.8)',
                'output' => array('background' => '.nav-light-transparent'),
                'default'       =>  array( 'color' => '#fff', 'alpha' => '0.8' ),
            ),
            array(
                'id'       => 'text-bg-nav-light-transparent-dropdown',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Transparent Light Header - Dropdown Menu Background', 'H-Code' ),
                //'default'  => 'rgba(0,0,0,0.9)',
                'output' => array('background' => '.nav-light-transparent .dropdown-menu, .nav-light-transparent .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-light-transparent-cart',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Transparent Light Header - Cart Content Background', 'H-Code' ),
                //'default'  => 'rgba(0,0,0,0.9)',
                'output' => array('background' => '.nav-light-transparent .cart-content'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-non-sticky',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fff"></div>'.__( 'Non Sticky Header Background', 'H-Code' ),
                'default'  => '#fff',
                'output' => array('background' => '.non-sticky'),
            ),
            array(
                'id'       => 'text-bg-nav-non-sticky-dropdown',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Non Sticky Header - Dropdown Menu Background', 'H-Code' ),
                //'default'  => 'rgba(0,0,0,0.9)',
                'output' => array('background' => '.non-sticky .dropdown-menu, .non-sticky .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-non-sticky-cart',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Non Sticky Header - Cart Content Background', 'H-Code' ),
                //'default'  => 'rgba(0,0,0,0.9)',
                'output' => array('background' => '.non-sticky .cart-content'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-hamburger-1',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Hamburger 1 Header Background', 'H-Code' ),
                'default'  => '#000',
                'output' => array('background' => '.hamburger-menu1'),
            ),
            array(
                'id'       => 'text-bg-nav-hamburger-2',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#1a1a1a"></div>'.__( 'Hamburger 2 Header Background', 'H-Code' ),
                'default'  => '#1a1a1a',
                'output' => array('background' => '.full-width-pull-menu .menu-wrap'),
            ),
            array(
                'id'       => 'text-bg-nav-hamburger-3',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ffffff"></div>'.__( 'Hamburger 3 Header Background', 'H-Code' ),
                'default'  => '#ffffff',
                'output' => array('background' => '.bg-hamburger-menu3'),
            ),
            array(
                'id'        => 'opt-accordion-end-general',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
            
            /* Text Color */
            
            array(
                'id'        => 'opt-accordion-begin-general',
                'type'      => 'accordion',
                'title'     => esc_html__('Text Color', 'H-Code'),
                'subtitle'  => esc_html__('Set text color', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'text-body',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#626262"></div>'.__( 'Body Text', 'H-Code' ),
                'default'  => '#626262',
                'output' => array('body'),
            ),
            array(
                'id'       => 'text-link',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Link Text', 'H-Code' ),
                'default'  => '#000',
                'output' => array('a'),
            ),
            array(
                'id'       => 'text-link-hover',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#575757"></div>'.__( 'Link Hover Text', 'H-Code' ),
                'default'  => '#575757',
                'output' => array('a:hover'),
            ),
            array(
                'id'       => 'text-heading-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Heading Text', 'H-Code' ),
                'default'  => '#000',
                'output' => array('h1, h2, h3, h4, h5'),
            ),
            array(
                'id'       => 'text-white-text-link-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'White Breadcrumb Title & link', 'H-Code' ),
                'default'  => '#FFF',
                'output' => array('.breadcrumb-white-text a, .breadcrumb-white-text li'),
            ),
            array(
                'id'       => 'text-gray-link-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#575757"></div>'.__( 'Gray Breadcrumb Title & link', 'H-Code' ),
                'default'  => '#575757',
                'output' => array('.breadcrumb-gray-text a, .breadcrumb-gray-text'),
            ),
            // array(
            //     'id'       => 'text-menu-text',
            //     'type'     => 'color',
            //     'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'Menu Text', 'H-Code' ),
            //     'default'  => '#FFF',
            //     'output' => array('.mega-menu-ul.navbar-nav li.menu-item a', '.mega-menu-ul.navbar-nav .dropdown-menu li.menu-item a'),
            // ),
            array(
                'id'       => 'text-icon-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#9a9a9a"></div>'.__( 'Icon Text', 'H-Code' ),
                'default'  => '#9a9a9a',
                'output' => array('i'),
            ),
            array(
                'id'       => 'text-white-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'White Text', 'H-Code' ),
                'default'  => '#FFF',
                'output' => array('.white-text'),
            ),
            array(
                'id'       => 'text-magenta-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d94378"></div>'.__( 'Magenta Text', 'H-Code' ),
                'default'  => '#d94378',
                'output' => array('.magenta-text'),
            ),
            array(
                'id'       => 'text-orange-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ff513b"></div>'.__( 'Orange Text', 'H-Code' ),
                'default'  => '#ff513b',
                'output' => array('.orange-text'),
            ),
            array(
                'id'       => 'text-deep-red-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e75e50"></div>'.__( 'Deep Red Text', 'H-Code' ),
                'default'  => '#e75e50',
                'output' => array('.deep-red-text'),
            ),
            array(
                'id'       => 'text-red-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d50f0f"></div>'.__( 'Red Text', 'H-Code' ),
                'default'  => '#d50f0f',
                'output' => array('.red-text'),
            ),
            array(
                'id'       => 'text-black-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000000"></div>'.__( 'Black Text', 'H-Code' ),
                'default'  => '#000000',
                'output' => array('.black-text'),
            ),
            array(
                'id'       => 'text-black-text-link',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000000"></div>'.__( 'Black Link Text', 'H-Code' ),
                'default'  => '#000000',
                'output' => array('a.black-text-link, a.black-text-link i, footer ul.list-inline li a'),
            ),
            array(
                'id'       => 'text-black-text-link-hover',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#858585"></div>'.__( 'Black Link Hover Text', 'H-Code' ),
                'default'  => '#858585',
                'output' => array('a.black-text-link:hover, a.black-text-link:hover i, footer ul.list-inline li a:hover'),
            ),
            array(
                'id'       => 'text-white-text-link',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'White Link Text', 'H-Code' ),
                'default'  => '#FFF',
                'output' => array('a.white-text-link, a.white-text-link i'),
            ),
            array(
                'id'       => 'link-text-white-text-hover',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ababab"></div>'.__( 'White Link Hover Text', 'H-Code' ),
                'default'  => '#ababab',
                'output' => array('a.white-text-link:hover, a.white-text-link:hover i'),
            ),
            array(
                'id'       => 'text-gray-text-link',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#626262"></div>'.__( 'Gray Link Text', 'H-Code' ),
                'default'  => '#626262',
                'output' => array('a.gray-text-link, footer ul li a'),
            ),
            array(
                'id'       => 'text-gray-text-hover',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Gray Link Hover Text', 'H-Code' ),
                'default'  => '#000',
                'output' => array('a.gray-text-link:hover, footer ul li a:hover'),
            ),
            array(
                'id'       => 'text-yellow-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e6af2a"></div>'.__( 'Yellow Text', 'H-Code' ),
                'default'  => '#e6af2a',
                'output' => array('.yellow-text'),
            ),
            array(
                'id'       => 'text-yellow-text2',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fdd947"></div>'.__( 'Yellow Text2', 'H-Code' ),
                'default'  => '#fdd947',
                'output' => array('.yellow-text2'),
            ),
            array(
                'id'       => 'text-fast-yellow-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f7d23d"></div>'.__( 'Fast Yellow Text', 'H-Code' ),
                'default'  => '#f7d23d',
                'output' => array('.fast-yellow-text'),
            ),
            array(
                'id'       => 'text-pink-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d9378e"></div>'.__( 'Pink Text', 'H-Code' ),
                'default'  => '#d9378e',
                'output' => array('.pink-text'),
            ),
            array(
                'id'       => 'text-light-gray-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ababab"></div>'.__( 'Light Gray Text', 'H-Code' ),
                'default'  => '#ababab',
                'output' => array('.light-gray-text'),
            ),
            array(
                'id'       => 'text-light-gray-text2',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#828282"></div>'.__( 'Light Gray Text2', 'H-Code' ),
                'default'  => '#828282',
                'output' => array('.light-gray-text2, .blog-date, .blog-date a'),
            ),
            array(
                'id'       => 'text-deep-gray-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#464646"></div>'.__( 'Deep Gray Text', 'H-Code' ),
                'default'  => '#464646',
                'output' => array('.deep-gray-text'),
            ),
            array(
                'id'       => 'text-deep-light-gray-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#878787"></div>'.__( 'Deep Light Gray Text', 'H-Code' ),
                'default'  => '#878787',
                'output' => array('.deep-light-gray-text'),
            ),
            array(
                'id'       => 'text-gray-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#7f7f7f"></div>'.__( 'Gray Text', 'H-Code' ),
                'default'  => '#7f7f7f',
                'output' => array('.gray-text'),
            ),
            array(
                'id'       => 'text-dark-gray-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#373737"></div>'.__( 'Dark Gray Text', 'H-Code' ),
                'default'  => '#373737',
                'output' => array('.dark-gray-text'),
            ),
            array(
                'id'        => 'opt-accordion-end-general',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            /* Header Text Color */
                        
            array(
                'id'        => 'opt-accordion-begin-menu-color',
                'type'      => 'accordion',
                'title'     => esc_html__('Header Text Color', 'H-Code'),
                'subtitle'  => esc_html__('Set menu and submenu text color.', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'menu-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Text Color', 'H-Code' ),
                'output'   => array('color' => '.nav-black .navbar-nav li a, .nav-black .search-cart-header .subtitle, .nav-black .top-cart .fa-shopping-cart, .nav-black .search-button, .nav-black .search-cart-header .subtitle, .nav-white.sticky-nav .navbar-nav li a, .nav-white.nav-dark .search-cart-header .subtitle, .nav-white.nav-dark .top-cart .fa-shopping-cart, .nav-white.nav-dark .search-button, .nav-white.nav-dark .search-cart-header .subtitle, .nav-white.nav-dark-transparent .search-cart-header .subtitle, .nav-white.nav-dark-transparent .top-cart .fa-shopping-cart, .nav-white.nav-dark-transparent .search-button, .nav-white.nav-dark-transparent .search-cart-header .subtitle, .pull-menu .navbar-nav a, .nav-white .search-cart-header .subtitle, .nav-white .top-cart .fa-shopping-cart, .nav-white .search-button, .nav-black.nav-dark-transparent .search-cart-header .subtitle, .nav-black.nav-dark-transparent .top-cart .fa-shopping-cart, .nav-black.nav-dark-transparent .search-button, .nav-black.nav-dark-transparent .search-cart-header .subtitle, .nav-black.nav-dark .search-cart-header .subtitle, .nav-black.nav-dark .top-cart .fa-shopping-cart, .nav-black.nav-dark .search-button, .nav-black.nav-dark .search-cart-header .subtitle, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li a, .full-width-pull-menu-dark .navbar-nav li a, .hamburger-menu3.full-width-pull-menu-dark .menu-number, .full-width-pull-menu-dark .menu-number, .nav-black.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li a, .nav-white.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li a, .nav-white.pull-menu .navbar-nav li a, .nav-black.pull-menu .navbar-nav li a, .nav-white.full-width-pull-menu.navbar .navbar-nav li a, .nav-white.shrink-nav .search-cart-header .subtitle, .nav-white.shrink-nav .top-cart .fa-shopping-cart, .nav-white.shrink-nav .search-button, .nav-white.nav-dark.shrink-nav .search-cart-header .subtitle, .nav-white.nav-dark.shrink-nav .top-cart .fa-shopping-cart, .nav-white.nav-dark.shrink-nav .search-button, .nav-white.nav-dark.shrink-nav .search-cart-header .subtitle, .nav-white.nav-dark-transparent.shrink-nav .search-cart-header .subtitle, .nav-white.nav-dark-transparent.shrink-nav .top-cart .fa-shopping-cart, .nav-white.nav-dark-transparent.shrink-nav .search-button, .nav-white.nav-dark-transparent.shrink-nav .search-cart-header .subtitle, .nav-dark.shrink-nav .navbar-nav li a, .nav-black.nav-dark.shrink-nav .search-cart-header .subtitle, .nav-black.nav-dark.shrink-nav .top-cart .fa-shopping-cart, .nav-black.nav-dark.shrink-nav .search-button, .nav-black.nav-dark.shrink-nav .top-cart a:hover .fa-shopping-cart, .nav-black.nav-dark.shrink-nav .search-cart-header .subtitle, .nav-dark-transparent.shrink-nav .navbar-nav li a, .nav-black.nav-dark-transparent.shrink-nav .search-cart-header .subtitle, .nav-black.nav-dark-transparent.shrink-nav .top-cart .fa-shopping-cart, .nav-black.nav-dark-transparent.shrink-nav .search-button, .nav-black.nav-dark-transparent.shrink-nav .search-cart-header .subtitle, .nav-white.sticky-nav .navbar-nav li a.dropdown-toggle .menu-icon-left, .nav-black.sticky-nav .navbar-nav li a.dropdown-toggle .menu-icon-left, .full-width-pull-menu.navbar .megamenu-right-icon .fa, .hamburger-menu3.full-width-pull-menu.navbar .megamenu-right-icon .fa, .sticky-nav .navbar-nav > li > a i, .sticky-nav ul li a:hover i, .nav-black.hamburger-menu1.pull-menu .navbar-nav li a, .hamburger-menu1.pull-menu .navbar-nav li a, .nav-black.hamburger-menu2.full-width-pull-menu.navbar .navbar-nav li a, .nav-black.hamburger-menu2.full-width-pull-menu.navbar .megamenu-right-icon .fa, .nav-black.static-sticky-gray .search-cart-header .subtitle, .nav-black.static-sticky-gray .top-cart .fa-shopping-cart, .nav-black.static-sticky-gray .search-cart-header .subtitle, .nav-black.static-sticky-gray .search-button, .nav-white.non-sticky .search-cart-header .subtitle, .nav-white.non-sticky .top-cart .fa-shopping-cart, .nav-white.non-sticky .search-button, .nav-white.non-sticky .search-cart-header .subtitle, .nav-white.static-sticky-gray.shrink-nav > .navbar-nav > li > a, .nav-white.static-sticky-gray.shrink-nav .navbar-nav > .open > a, .nav-white.static-sticky-gray.shrink-nav .search-cart-header .subtitle, .nav-white.static-sticky-gray.shrink-nav .top-cart .fa-shopping-cart, .nav-white.static-sticky-gray.shrink-nav .search-button, .nav-white.non-sticky.shrink-nav > .navbar-nav > li > a, .nav-black.non-sticky.shrink-nav > .navbar-nav > li > a, .nav-white.non-sticky.shrink-nav .search-cart-header .subtitle, .nav-white.non-sticky.shrink-nav .top-cart .fa-shopping-cart, .nav-white.non-sticky.shrink-nav .search-button, .nav-black.non-sticky .search-cart-header .subtitle, .nav-black.non-sticky .top-cart .fa-shopping-cart, .nav-black.non-sticky .search-button, .nav-black.non-sticky.shrink-nav .search-cart-header .subtitle, .nav-black.non-sticky.shrink-nav .top-cart .fa-shopping-cart, .nav-black.non-sticky.shrink-nav .search-button, .nav-black.non-sticky.shrink-nav .navbar-nav > .open > a, .nav-black.static-sticky-gray.shrink-nav .navbar-nav > .open > a, .nav-black.static-sticky-gray.shrink-nav .navbar-nav > li > a'),
            ),
            array(
                'id'       => 'menu-text-hover-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Text Hover Color', 'H-Code' ),
                'output'   => array('color' => '.navbar-nav > li > a:hover, .nav-white.sticky-nav .navbar-nav li a:hover, .nav-black .top-cart a:hover .fa-shopping-cart, .header-search-form .search-button:hover, .top-cart a.shopping-cart:hover, .top-cart a.shopping-cart:hover .subtitle, .nav-white.nav-dark .top-cart a:hover .fa-shopping-cart, .nav-white.nav-dark-transparent .top-cart a:hover .fa-shopping-cart, .nav-white .top-cart a:hover .fa-shopping-cart, .nav-black.nav-dark-transparent .top-cart a:hover .fa-shopping-cart, .nav-black.nav-dark .top-cart a:hover .fa-shopping-cart, .navbar-default .navbar-nav > li.current-menu-ancestor > a, .navbar-default .navbar-nav > li.current-menu-item > a, .navbar-default .navbar-nav > li > a.active, .nav-white.pull-menu .navbar-nav li a:hover, .nav-white.pull-menu .navbar-nav li a.active, .nav-white.pull-menu .navbar-nav li.current-menu-ancestor > a, .nav-white.pull-menu .navbar-nav li.current-menu-item > a, .nav-white.full-width-pull-menu.navbar .navbar-nav li a:hover, .nav-white.full-width-pull-menu.navbar .navbar-nav li a.active, .nav-white.full-width-pull-menu.navbar .navbar-nav li.current-menu-ancestor > a, .nav-white.full-width-pull-menu.navbar .navbar-nav li.current-menu-item > a, .nav-black.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li a:hover, .nav-black.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li a.active, .nav-black.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li.current-menu-ancestor > a, .nav-black.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li.current-menu-item > a, .nav-white.shrink-nav .top-cart a:hover .fa-shopping-cart, .nav-white.nav-dark.shrink-nav .top-cart a:hover .fa-shopping-cart, .nav-white.nav-dark.shrink-nav .top-cart a:hover, nav-black .search-cart-header .shopping-cart:hover .subtitle, .nav-white.nav-dark .search-cart-header .shopping-cart:hover .subtitle, .nav-white.nav-dark-transparent .search-cart-header .shopping-cart:hover .subtitle, .nav-white .search-cart-header .shopping-cart:hover .subtitle, .nav-black.nav-dark-transparent .shopping-cart:hover .search-cart-header .subtitle, .nav-black.nav-dark .search-cart-header .shopping-cart:hover .subtitle, .nav-white.shrink-nav .search-cart-header .shopping-cart:hover .subtitle, .nav-white.nav-dark.shrink-nav .search-cart-header .shopping-cart:hover .subtitle, .nav-black .search-button:hover, .nav-white.nav-dark .search-button:hover, .nav-white.nav-dark-transparent .search-button:hover, .nav-white .search-button:hover, .nav-black.nav-dark-transparent .search-button:hover, .nav-black.nav-dark .search-button:hover, .nav-white.shrink-nav .search-button:hover, .nav-white.nav-dark.shrink-nav .search-button:hover, .nav-white.nav-dark-transparent .top-cart a:hover .fa-shopping-cart, .nav-black.nav-dark-transparent .top-cart a:hover .fa-shopping-cart, .nav-white.nav-dark-transparent.shrink-nav .top-cart a:hover .fa-shopping-cart, .nav-black.nav-dark-transparent,shrink-nav .top-cart a:hover .fa-shopping-cart, .navbar-nav > li.open > a, .navbar-default .navbar-nav > li.open > a, .nav-white.sticky-nav .navbar-nav > li.open > a, .nav-black.nav-dark-transparent .navbar-nav > li.open > a,  .nav-black.transparent-header .navbar-nav > li.open > a, .nav-black.static-sticky .navbar-nav > li.open > a, .nav-black.white-header .navbar-nav > li.open > a, .nav-black.nav-light-transparent .navbar-nav > li.open > a, .nav-black.nav-dark-transparent .navbar-nav > .open > a, .nav-black.nav-dark-transparent .navbar-nav > li.open > a, .nav-black.nav-dark .navbar-nav > li.open > a, .nav-white.transparent-header.shrink-nav .navbar-nav > li.open > a, .nav-white.sticky-nav .navbar-nav > .open > a, .full-width-pull-menu.navbar .navbar-nav > li.open > a, .pull-menu .nav > li.open > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > li.open > a, .nav-black.nav-dark.shrink-nav .top-cart a:hover .fa-shopping-cart, .nav-black.nav-dark-transparent.shrink-nav .top-cart a:hover .fa-shopping-cart, .nav-black.nav-dark-transparent.shrink-nav .top-cart a:hover .subtitle, .nav-white.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li a:hover, .nav-white.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li a.active, .nav-white.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li.current-menu-ancestor > a, .nav-white.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li.current-menu-item > a, .nav-white.sticky-nav .navbar-nav li a.dropdown-toggle:hover .menu-icon-left, .nav-black.sticky-nav .navbar-nav li a.dropdown-toggle:hover .menu-icon-left, .nav-white.sticky-nav .navbar-nav li.current-menu-ancestor a.dropdown-toggle .menu-icon-left, .nav-black.sticky-nav .navbar-nav li.current-menu-ancestor a.dropdown-toggle .menu-icon-left, .nav-white.sticky-nav .navbar-nav li.current-menu-item a.dropdown-toggle .menu-icon-left, .nav-black.sticky-nav .navbar-nav li.current-menu-item a.dropdown-toggle .menu-icon-left, .nav-white.sticky-nav .navbar-nav li.open > a.dropdown-toggle .menu-icon-left, .nav-black.sticky-nav .navbar-nav li.open > a.dropdown-toggle .menu-icon-left, .nav-black.pull-menu .navbar-nav li > a.active, .nav-black.pull-menu .navbar-nav li.current-menu-ancestor > a, .nav-black.pull-menu .navbar-nav li.current-menu-item > a, .nav-white.pull-menu .navbar-nav li > a.active, .nav-white.pull-menu .navbar-nav li.current-menu-ancestor > a, .nav-white.pull-menu .navbar-nav li.current-menu-item > a, .nav-black.pull-menu .navbar-nav li a:hover, .sticky-nav ul li a:hover, .nav-white.full-width-pull-menu.navbar .navbar-nav li > a.active, .nav-white.full-width-pull-menu.navbar .navbar-nav li.current-menu-ancestor > a, .nav-white.full-width-pull-menu.navbar .navbar-nav li.current-menu-item > a, .nav-black.full-width-pull-menu.navbar .navbar-nav li > a.active, .nav-black.full-width-pull-menu.navbar .navbar-nav li.current-menu-ancestor > a, .nav-black.full-width-pull-menu.navbar .navbar-nav li.current-menu-item > a, .nav-black.hamburger-menu1.pull-menu .navbar-nav li a:hover, .nav-black.hamburger-menu1.pull-menu .navbar-nav li.current-menu-ancestor > a, .nav-black.hamburger-menu1.pull-menu .navbar-nav li.current-menu-item > a, .nav-black.hamburger-menu1.pull-menu .navbar-nav li > a.active, .nav-white.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li.current-menu-ancestor a.megamenu-right-icon .fa, .nav-white.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li.current-menu-item a.megamenu-right-icon .fa, .hamburger-menu1.pull-menu .navbar-nav li a:hover, .hamburger-menu1.pull-menu .navbar-nav li.current-menu-ancestor > a, .hamburger-menu1.pull-menu .navbar-nav li.current-menu-item > a, .hamburger-menu1.pull-menu .navbar-nav li > a.active, .nav-black.hamburger-menu2.full-width-pull-menu.navbar .navbar-nav li a:hover, .nav-black.hamburger-menu2.full-width-pull-menu.navbar .navbar-nav li.current-menu-ancestor > a, .nav-black.hamburger-menu2.pull-menu.navbar .navbar-nav li.current-menu-item > a, .nav-black.hamburger-menu2.pull-menu.navbar .navbar-nav li > a.active, .nav-black.static-sticky-gray .top-cart a:hover .fa-shopping-cart, .nav-white.non-sticky .top-cart a:hover .fa-shopping-cart, .nav-white.static-sticky-gray.shrink-nav .navbar-nav li a.active, .nav-white.static-sticky-gray.shrink-nav .navbar-nav > li > a:hover, .nav-white.static-sticky-gray.shrink-nav .top-cart a:hover .fa-shopping-cart, .nav-white.non-sticky.shrink-nav > .navbar-nav > li > a:hover, .nav-white.non-sticky.shrink-nav > .navbar-nav > .open > a, .nav-white.non-sticky.shrink-nav > .navbar-nav li a.active, .nav-black.non-sticky.shrink-nav > .navbar-nav > li > a:hover, .nav-black.non-sticky.shrink-nav > .navbar-nav > .open > a, .nav-black.non-sticky.shrink-nav > .navbar-nav li a.active, .nav-white.non-sticky.shrink-nav .top-cart a:hover .fa-shopping-cart, .nav-black.non-sticky .top-cart a:hover .fa-shopping-cart, .nav-black.non-sticky.shrink-nav .top-cart a:hover .fa-shopping-cart, .nav-black.static-sticky-gray.shrink-nav .navbar-nav li a:hover, .nav-black.static-sticky-gray.shrink-nav .navbar-nav li a.active, .nav-black.static-sticky-gray.shrink-nav .navbar-nav li.current-menu-ancestor a, .nav-black.static-sticky-gray.shrink-nav .navbar-nav li.current-menu-item a', 'border-bottom-color' =>'.navbar-default .navbar-nav > .open > a:hover, .navbar-default .navbar-nav > li > a:hover, .nav-white.sticky-nav .navbar-nav li a:hover, .nav-black.nav-dark-transparent .navbar-nav li a:hover, .navbar-default .navbar-nav > li > a.active, .nav-white.sticky-nav .navbar-nav li a.active, .nav-black.nav-dark-transparent .navbar-nav li a.active, .nav-black.transparent-header .navbar-nav li.current-menu-ancestor a, .nav-black.transparent-header .navbar-nav li.current-menu-item a, .navbar-default .navbar-nav > .open > a, .nav-black.static-sticky .navbar-nav li.current-menu-ancestor a, .nav-black.static-sticky .navbar-nav li.current-menu-item a, .nav-black.white-header .navbar-nav li.current-menu-ancestor a, .nav-black.white-header .navbar-nav li.current-menu-item a, .nav-black.nav-light-transparent .navbar-nav li.current-menu-ancestor a, .nav-black.nav-light-transparent .navbar-nav li.current-menu-item a, .nav-white.sticky-nav .navbar-nav > .open > a, .nav-white.sticky-nav .navbar-nav li.current-menu-ancestor a, .nav-white.sticky-nav .navbar-nav li.current-menu-item a, .nav-black.nav-dark-transparent .navbar-nav > .open > a, .nav-black.nav-dark-transparent .navbar-nav li.current-menu-ancestor a, .nav-black.nav-dark-transparent .navbar-nav li.current-menu-item a, .nav-black.nav-dark .navbar-nav li.current-menu-ancestor a, .nav-white.transparent-header.shrink-nav .navbar-nav li.current-menu-ancestor a, .nav-white.transparent-header.shrink-nav .navbar-nav li.current-menu-item a, .nav-dark.shrink-nav .navbar-nav li a:hover, .nav-dark.shrink-nav .navbar-nav > .open > a, .nav-dark.shrink-nav .navbar-nav li.current-menu-ancestor a, .nav-dark.shrink-nav .navbar-nav li.current-menu-item a, .nav-white.nav-light-transparent.shrink-nav .navbar-nav li.current-menu-ancestor a, .nav-white.nav-light-transparent.shrink-nav .navbar-nav li.current-menu-item a, .nav-white.static-sticky.shrink-nav .navbar-nav li.current-menu-ancestor a, .nav-white.static-sticky.shrink-nav .navbar-nav li.current-menu-item a, .nav-black.hamburger-menu1.pull-menu .navbar-nav li.current-menu-ancestor > a, .nav-black.hamburger-menu1.pull-menu .navbar-nav li.current-menu-item > a, .nav-black.hamburger-menu1.pull-menu .navbar-nav li > a.active, .hamburger-menu1.pull-menu .navbar-nav li a:hover, .hamburger-menu1.pull-menu .navbar-nav li.current-menu-ancestor > a, .hamburger-menu1.pull-menu .navbar-nav li.current-menu-item > a, .hamburger-menu1.pull-menu .navbar-nav li > a.active, .nav-black.static-sticky-gray .navbar-nav li.current-menu-ancestor a, .nav-black.static-sticky-gray .navbar-nav li.current-menu-item a, .nav-white.static-sticky-gray.shrink-nav .navbar-nav li a:hover, .nav-white.static-sticky-gray.shrink-nav .navbar-nav li a.active, .nav-white.static-sticky-gray.shrink-nav .navbar-nav li.current-menu-ancestor a, .nav-white.static-sticky-gray.shrink-nav .navbar-nav li.current-menu-item a, .nav-white.non-sticky.shrink-nav .navbar-nav li.current-menu-ancestor a, .nav-white.non-sticky.shrink-nav .navbar-nav li a:hover, .nav-black.non-sticky .navbar-nav li a:hover, .nav-black.non-sticky .navbar-nav > .open > a, .nav-black.non-sticky .navbar-nav li a.active, .nav-black.non-sticky .navbar-nav li.current-menu-ancestor a, .nav-black.non-sticky .navbar-nav li.current-menu-item a, .nav-black.non-sticky.shrink-nav .navbar-nav li a:hover, .nav-black.non-sticky.shrink-nav .navbar-nav li a.active, .nav-black.non-sticky.shrink-nav .navbar-nav li.current-menu-ancestor a, .nav-black.non-sticky.shrink-nav .navbar-nav li.current-menu-item a, .nav-black.static-sticky-gray.shrink-nav .navbar-nav li a:hover, .nav-black.static-sticky-gray.shrink-nav .navbar-nav li a.active, .nav-black.static-sticky-gray.shrink-nav .navbar-nav li.current-menu-ancestor a, .nav-black.static-sticky-gray.shrink-nav .navbar-nav li.current-menu-item a'),
            ),
            array(
                'id'       => 'submenu-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Submenu Text Color', 'H-Code' ),
                'output'   => array('color' => '.dropdown-header, .nav-white.sticky-nav .navbar-nav li a.dropdown-header, .dropdown-header .menu-icon-left, .navbar .dropdown-menu .mega-sub-menu li a, .navbar .dropdown-menu .mega-sub-menu > li > a > .menu-icon-left, .navbar .simple-dropdown ul.dropdown-menu li a, .navbar .simple-dropdown ul.dropdown-menu li a .fa-angle-right, .hamburger-menu2.full-width-pull-menu.navbar .navbar-nav li .sub-menu a, .hamburger-menu2.full-width-pull-menu.navbar .navbar-nav li .sub-menu .megamenu-right-icon .fa, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu li ul li > a, .hamburger-menu3.full-width-pull-menu.navbar .sub-menu .megamenu-right-icon .fa, .navbar-nav .dropdown-menu li .mega-sub-menu > li > a, .navbar .simple-dropdown > ul.dropdown-menu > li a, .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu > li a, .simple-dropdown > ul.dropdown-menu > li.current-menu-ancestor ul.mega-sub-menu li > a, .navbar-default .navbar-nav .open .dropdown-menu > li > a'),
            ),
            array(
                'id'       => 'submenu-text-hover-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Submenu Text Hover Color', 'H-Code' ),
                'output'   => array('color' => '.navbar .dropdown-menu .mega-sub-menu li a:hover, .navbar .dropdown-menu .mega-sub-menu li a:hover .menu-icon-left, .navbar .dropdown-menu .mega-sub-menu li.current_page_item a, .navbar .dropdown-menu .mega-sub-menu li.current-menu-item a, .navbar .dropdown-menu .mega-sub-menu li a.active, .navbar .dropdown-menu .mega-sub-menu li.current-menu-ancestor a, .navbar .dropdown-menu .mega-sub-menu li.current_page_item a .menu-icon-left, .navbar .dropdown-menu .mega-sub-menu li.current-menu-item a .menu-icon-left, .navbar .dropdown-menu .mega-sub-menu li.current-menu-ancestor a .menu-icon-left, .navbar .simple-dropdown ul.dropdown-menu li a:hover, .navbar .simple-dropdown ul.dropdown-menu li a:hover .fa-angle-right, .navbar .simple-dropdown ul.dropdown-menu li:hover > a, .navbar .simple-dropdown ul.dropdown-menu li:hover > a .fa-angle-right, .navbar .simple-dropdown > ul.dropdown-menu > li.current-menu-ancestor > a, .navbar .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu > li.current-menu-item > a:hover, .navbar .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu > li > a.active, .navbar .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu > li.current-menu-item > a, .navbar .simple-dropdown > ul.dropdown-menu > li.current-menu-ancestor > a > .fa-angle-right, .navbar .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu > li.current-menu-item > a:hover > .fa-angle-right, .navbar .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu > li.current-menu-item > a > .fa-angle-right, .simple-dropdown > ul.dropdown-menu > li.current-menu-ancestor ul.mega-sub-menu li > a:hover, .navbar .simple-dropdown > ul.dropdown-menu > li a:hover, .navbar.shrink-nav .navbar-nav > .simple-dropdown > ul.dropdown-menu > li a:hover, .hamburger-menu2.full-width-pull-menu.navbar .navbar-nav li .sub-menu a:hover, .hamburger-menu2.full-width-pull-menu.navbar .navbar-nav li .sub-menu li.current-menu-item > a, .hamburger-menu2.full-width-pull-menu.navbar .navbar-nav li .sub-menu li > a.avtive, .hamburger-menu2.full-width-pull-menu.navbar .navbar-nav li .sub-menu li.current-menu-ancestor > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu a:hover, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu li.current-menu-item > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu li > a.active, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu li.current-menu-ancestor > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu li.current-menu-ancestor > a:hover, .hamburger-menu3.full-width-pull-menu-dark .navbar-nav li a:hover, .hamburger-menu3.full-width-pull-menu-dark .pull-menu .navbar-nav li a.active, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu li ul a:hover, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu li ul a.active, .navbar-nav .dropdown-menu li .mega-sub-menu > li > a:hover, .dropdown-menu li a:hover i, .dropdown-menu li.current-menu-ancestor a i, .dropdown-menu li.current-menu-item a i, .dropdown-menu li a.active i, .navbar .simple-dropdown > ul.dropdown-menu > li:hover > a, .navbar .simple-dropdown > ul.dropdown-menu > li:hover > a > i, .nav-white.sticky-nav .navbar-nav li a.dropdown-header:hover, .navbar-nav li.current-menu-ancestor ul li.current-menu-item > a, .dropdown-menu li.current-menu-ancestor > a > i, .dropdown-menu li.current-menu-item > a > i, .dropdown-menu li > a.active > i, .navbar-nav .dropdown-menu li .mega-sub-menu > li > a:hover > i, .navbar-nav li.current-menu-ancestor ul li.current-menu-item > a > .fa, .navbar .dropdown-menu .mega-sub-menu > li.current-menu-item > a > .menu-icon-left, .navbar-default .navbar-nav .open .dropdown-menu > li > a:hover'),
            ),
            array(
                'id'       => 'submenu-separator-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Submenu Separator/Line Color', 'H-Code' ),
                'output'   => array('border-bottom-color' => '.dropdown-header, .nav-white.sticky-nav .navbar-nav li a.dropdown-header:hover, .nav-white.sticky-nav .navbar-nav li.current-menu-ancestor a.dropdown-header, .nav-white.sticky-nav .navbar-nav li.current-menu-item a.dropdown-header, white.transparent-header.shrink-nav .navbar-nav li.current-menu-ancestor a.dropdown-header, .nav-white.transparent-header.shrink-nav .navbar-nav li.current-menu-item a.dropdown-header'),
            ),
            array(
                'id'        => 'opt-accordion-begin-menu-color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
    
            /* Mobile Menu Color & Background Color */
                        
            array(
                'id'        => 'opt-accordion-begin-menu-color',
                'type'      => 'accordion',
                'title'     => esc_html__('Mobile Menu Color', 'H-Code'),
                'subtitle'  => esc_html__('Set mobile menu color & background color', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'mobile-menu-bg-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000000"></div>'.__( 'Menu Background', 'H-Code' ),
                'default'  => '#000000',
                'output'   => array('background' => '.navbar .mobile-accordion-menu'),
            ),
            array(
                'id'       => 'mobile-menu-icon-bg-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Icon Background', 'H-Code' ),
                'output' => array('background' => '.navbar-default .navbar-toggle, .menu-button'),
            ),
            array(
                'id'       => 'mobile-menu-icon-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Icon Color', 'H-Code' ),
                'output' => array('background' => '.navbar-default .navbar-toggle .icon-bar, .menu-button .icon-bar'),
            ),
            array(
                'id'       => 'mobile-menu-icon-border-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Icon Border Color', 'H-Code' ),
                'output' => array('border-color' => '.navbar-default .navbar-toggle, .navbar-default .menu-button-orange, .menu-button'),
            ),
            array(
                'id'        => 'opt-accordion-begin-menu-color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            /* Mini Header Color */
                        
            array(
                'id'        => 'opt-accordion-begin-menu-color',
                'type'      => 'accordion',
                'title'     => esc_html__('Mini Header Color', 'H-Code'),
                'subtitle'  => esc_html__('Set mini header color', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'mini-header-bg-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000000"></div>'.__( 'Mini Header Background', 'H-Code' ),
                'default'  => '#000000',
                'output'   => array('background' => '.top-header-area'),
            ),
            array(
                'id'        => 'opt-accordion-begin-menu-color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

    ),
);
?>