<?php
/**
 * Shortcode For Time Counter
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Time Counter */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'hcode_time_counter_shortcode' ) ) {
    function hcode_time_counter_shortcode( $atts, $content = null ) {
        extract( shortcode_atts( array(
            'id' => '',
            'class' => '',
            'hcode_time_counter_date' => '',
            'hcode_time_counter_color' => '',
            'hcode_time_counter_days_taxt' => __( 'Day', 'hcode-addons' ),
            'hcode_time_counter_hours_taxt' => __( 'Hours', 'hcode-addons' ),
            'hcode_time_counter_minutes_taxt' => __( 'Minutes', 'hcode-addons' ),
            'hcode_time_counter_seconds_taxt' => __( 'Seconds', 'hcode-addons' ),
        ), $atts ) );
        
        $output = '';
        $id = ( $id ) ? ' id="'.$id.'"' : '';
        $class = ( $class ) ? ' class="'.$class.'"' : '';
        $hcode_time_counter_date = ( $hcode_time_counter_date ) ? $hcode_time_counter_date : '';
        $hcode_time_counter_color = ( $hcode_time_counter_color ) ? ' style="color:'.$hcode_time_counter_color.'"' : '';
        $hcode_time_counter_days_taxt = ( $hcode_time_counter_days_taxt ) ? $hcode_time_counter_days_taxt : '';
        $hcode_time_counter_hours_taxt = ( $hcode_time_counter_hours_taxt ) ? $hcode_time_counter_hours_taxt : '';
        $hcode_time_counter_minutes_taxt = ( $hcode_time_counter_minutes_taxt ) ? $hcode_time_counter_minutes_taxt : '';
        $hcode_time_counter_seconds_taxt = ( $hcode_time_counter_seconds_taxt ) ? $hcode_time_counter_seconds_taxt : '';
        
        if( $id || $class ) :
            $output .='<div'.$id.$class.'">';
        endif;

        $output .= '<div id="hcode-time-counter" class="hcode-time-counter" data-days-text="'.$hcode_time_counter_days_taxt.'" data-hours-text="'.$hcode_time_counter_hours_taxt.'" data-minutes-text="'.$hcode_time_counter_minutes_taxt.'" data-seconds-text="'.$hcode_time_counter_seconds_taxt.'" '.$hcode_time_counter_color.'></div>';
        if($hcode_time_counter_date):
            $output .= '<span class="hide hcode-time-counter-date counter-hidden">'.$hcode_time_counter_date.'</span>';
        endif;
        if( $id || $class ) :
            $output .='</div>';
        endif;

        return $output;
    }
}
add_shortcode( 'hcode_time_counter', 'hcode_time_counter_shortcode' );