<?php
/**
 * Map For Coming soon
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Coming soon */
/*-----------------------------------------------------------------------------------*/
vc_map( array(
  'name' => __('Coming Soon Block', 'hcode-addons'),
  'description' => __( 'Create a coming soon content block', 'hcode-addons' ),
  'icon' => 'fa fa-list-alt h-code-shortcode-icon',
  'base' => 'hcode_coming_soon',
  'category' => 'H-Code',
  'params' => array(
    array(
        'type' => 'dropdown',
        'heading' => __('Content Type', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_type',
        'value' => array(__('Select Content Type', 'hcode-addons') => '',
                  __('Background Image', 'hcode-addons') => 'hcode-coming-soon-type1',
                  __('Background Video', 'hcode-addons') => 'hcode-coming-soon-type2',
                  __('Background Animation', 'hcode-addons') => 'hcode-coming-soon-type3',
      ),
    ),
    array(
        'type' => 'attach_image',
        'heading' => __('Logo image', 'hcode-addons' ),
        'param_name' => 'hcode_coming_soon_logo',
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
    ),  
    array(
        'type' => 'textfield',
        'heading' => __('MP4 Video URL', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_mp4',
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type2') ),
    ),
    array(
        'type' => 'textfield',
        'heading' => __('OGG Video URL', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_ogg',
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type2') ),
    ),
      array(
        'type' => 'textfield',
        'heading' => __('Webm Video URL', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_webm',
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type2') ),
    ),
    array(
          'type' => 'hcode_custom_switch_option',
          'holder' => 'div',
          'class' => '',
          'heading' => __('Enable Loop', 'hcode-addons'),
          'param_name' => 'enable_loop',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'std' => '1',  
          'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type2') ),
    ),
    array(
          'type' => 'hcode_custom_switch_option',
          'holder' => 'div',
          'class' => '',
          'heading' => __('Enable Autoplay', 'hcode-addons'),
          'param_name' => 'enable_autoplay',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'std' => '1',  
          'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type2') ),
    ),
    array(
            'type' => 'hcode_custom_switch_option',
            'holder' => 'div',
            'class' => '',
            'heading' => __('Enable Mute', 'hcode-addons'),
            'param_name' => 'enable_mute',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),  
            'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type2') ),
      ),
    array(
        'type' => 'textfield',
        'heading' => __('Title', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_title',
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
    ),
    
    array(
        'type' => 'textfield',
        'heading' => __('Enter Date', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_date',
        'description' => __( 'Enter date like 12/31/2016 in date format mm/dd/yyyy', 'hcode-addons' ),
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
    ),
    
    array(
        'type' => 'dropdown',
        'heading' => __('Date Style', 'hcode-addons'),
        'param_name' => 'hcode_date_style',
        'value' => array(__('Select Style', 'hcode-addons') => '',
                  __('Style 1', 'hcode-addons') => 'hcode-date-style1',
                  __('Style 2', 'hcode-addons') => 'hcode-date-style2',
        ),
        'std' => 'hcode-date-style1',
    ),

    array(
        'type' => 'textarea_html',
        'heading' => __('Content', 'hcode-addons'),
        'param_name' => 'content',
    ),

    array(
        'type' => 'textfield',
        'heading' => __('Notify Me Title', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_notify_me_title',
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
    ),
    array(
        'type' => 'textfield',
        'heading' => __('Notify Me Subtitle', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_notify_me_subtitle',
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
    ),
    
    array(
        'type' => 'hcode_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => __('Show Newsletter', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_notify_me_show_form',
        'value' => array(__('NO', 'hcode-addons') => '0', 
                         __('YES', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
    ),
    array(
        'type' => 'hcode_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => __('Do you want to show custom newsletter?', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_custom_newsletter',
        'value' => array(__('NO', 'hcode-addons') => '0', 
                         __('YES', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_coming_soon_notify_me_show_form', 'value' => array('1') ),
    ),
    array(
        'type' => 'textarea',
        'heading' => __('Add Custom Newsletter Shortcode', 'hcode-addons'),
        'param_name' => 'hcode_custom_newsletter',
        'dependency' => array( 'element' => 'hcode_coming_soon_custom_newsletter', 'value' => array('1') ),
    ),
    array(
        'type' => 'textfield',
        'heading' => __('Notify Me Button Text', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_notify_me_button_text',
        'value' => 'Get Notified',
        'dependency' => array( 'element' => 'hcode_coming_soon_custom_newsletter', 'value' => array('0') ),
    ),

    array(
        'type' => 'textfield',
        'heading' => __('Newsletter Placeholder Text', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_notify_placeholder',
        'value' => 'ENTER YOUR EMAIL ADDRESS',
        'dependency' => array( 'element' => 'hcode_coming_soon_custom_newsletter', 'value' => array('0') ),
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Days Text', 'hcode-addons' ),
      'param_name' => 'hcode_time_counter_days_taxt',
      'value' => 'Day',
      'group' => 'Counter Text Configuration',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Hours Text', 'hcode-addons' ),
      'param_name' => 'hcode_time_counter_hours_taxt',
      'value' => 'Hours',
      'group' => 'Counter Text Configuration',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Minutes Text', 'hcode-addons' ),
      'param_name' => 'hcode_time_counter_minutes_taxt',
      'value' => 'Minutes',
      'group' => 'Counter Text Configuration',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Seconds Text', 'hcode-addons' ),
      'param_name' => 'hcode_time_counter_seconds_taxt',
      'value' => 'Seconds',
      'group' => 'Counter Text Configuration',
    ),
    array(
        'type' => 'dropdown',
        'heading' => __('Social Style', 'hcode-addons'),
        'param_name' => 'hcode_social_style',
        'value' => array(__('Select Stye', 'hcode-addons') => '',
                  __('Style 1', 'hcode-addons') => 'hcode-social-style1',
                  __('Style 2', 'hcode-addons') => 'hcode-social-style2',
        ),
        'std' => 'hcode-social-style1',
        'group'       => 'Social',
    ),
    array(
        'type' => 'hcode_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => __('Show Facebook Icon', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_notify_me_fb',
        'value' => array(__('NO', 'hcode-addons') => '0', 
                         __('YES', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
        'group'       => 'Social',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Facebook URL', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_fb_url',
      'dependency' => array( 'element' => 'hcode_coming_soon_notify_me_fb', 'value' => array('1') ),
      'group'       => 'Social',
    ),
    array(
        'type' => 'hcode_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => __('Show Twitter Icon', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_notify_me_tw',
        'value' => array(__('NO', 'hcode-addons') => '0', 
                         __('YES', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
        'group'       => 'Social',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Twitter URL', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_tw_url',
      'dependency' => array( 'element' => 'hcode_coming_soon_notify_me_tw', 'value' => array('1') ),
      'group'       => 'Social',
    ),
    array(
        'type' => 'hcode_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => __('Show Google-plus Icon', 'hcode-addons'),
        'param_name' => 'hcode_coming_soon_notify_me_gp',
        'value' => array(__('NO', 'hcode-addons') => '0', 
                         __('YES', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
        'group'       => 'Social',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Google-plus URL', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_gp_url',
      'dependency' => array( 'element' => 'hcode_coming_soon_notify_me_gp', 'value' => array('1') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'holder' => 'div',
      'class' => '',
      'heading' => __('Show Dribbble Icon', 'hcode-addons'),
      'param_name' => 'hcode_coming_soon_notify_me_dr',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Dribbble URL', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_dr_url',
      'dependency' => array( 'element' => 'hcode_coming_soon_notify_me_dr', 'value' => array('1') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'holder' => 'div',
      'class' => '',
      'heading' => __('Show Youtube Icon', 'hcode-addons'),
      'param_name' => 'hcode_coming_soon_notify_me_yt',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Youtube URL', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_yt_url',
      'dependency' => array( 'element' => 'hcode_coming_soon_notify_me_yt', 'value' => array('1') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'holder' => 'div',
      'class' => '',
      'heading' => __('Show Linkedin Icon', 'hcode-addons'),
      'param_name' => 'hcode_coming_soon_notify_me_li',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Linkedin URL', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_li_url',
      'dependency' => array( 'element' => 'hcode_coming_soon_notify_me_li', 'value' => array('1') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'holder' => 'div',
      'class' => '',
      'heading' => __('Show Instagram Icon', 'hcode-addons'),
      'param_name' => 'hcode_coming_soon_notify_me_in',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Instagram URL', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_in_url',
      'dependency' => array( 'element' => 'hcode_coming_soon_notify_me_in', 'value' => array('1') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'holder' => 'div',
      'class' => '',
      'heading' => __('Show Pinterest Icon', 'hcode-addons'),
      'param_name' => 'hcode_coming_soon_notify_me_pi',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Pinterest URL', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_pi_url',
      'dependency' => array( 'element' => 'hcode_coming_soon_notify_me_pi', 'value' => array('1') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'holder' => 'div',
      'class' => '',
      'heading' => __('Show GitHub Icon', 'hcode-addons'),
      'param_name' => 'hcode_coming_soon_notify_me_gh',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'GitHub URL', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_gh_url',
      'dependency' => array( 'element' => 'hcode_coming_soon_notify_me_gh', 'value' => array('1') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'holder' => 'div',
      'class' => '',
      'heading' => __('Show Website Icon', 'hcode-addons'),
      'param_name' => 'hcode_coming_soon_notify_me_ws',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Website URL', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_ws_url',
      'dependency' => array( 'element' => 'hcode_coming_soon_notify_me_ws', 'value' => array('1') ),
      'group'       => 'Social',
    ),
    array(
      'type' => 'textarea_raw_html',
      'heading' => __( 'Custom Icon & Link Code', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_custom_link',
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group'       => 'Social',
    ),
    array(
        'type' => 'hcode_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => __('Required Padding Setting?', 'hcode-addons'),
        'param_name' => 'padding_setting',
        'value' => array(__('No', 'hcode-addons') => '0', 
                         __('Yes', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
        'group' => 'Style',
    ),
    array(
      'type' => 'dropdown',
      'param_name' => 'desktop_padding',
      'heading' => __('Padding (For Desktop Device)', 'hcode-addons' ),
      'value' => $hcode_desktop_padding,
      'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
      'group' => 'Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Padding (For All Devices)', 'hcode-addons' ),
      'param_name' => 'custom_desktop_padding',
      'dependency' => array( 'element' => 'desktop_padding', 'value' => array('custom-desktop-padding') ),
      'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),

        'group' => 'Style',
    ),
    array(
      'type' => 'dropdown',
      'param_name' => 'ipad_padding',
      'heading' => __('Padding (For iPad Device)', 'hcode-addons' ),
      'value' => $hcode_ipad_padding,
      'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
      'group' => 'Style',
    ),
    array(
      'type' => 'dropdown',
      'param_name' => 'mobile_padding',
      'heading' => __('Padding (For Mobile Device)', 'hcode-addons' ),
      'value' => $hcode_mobile_padding,
      'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
        'group' => 'Style',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'holder' => 'div',
      'class' => '',
      'heading' => __('Required Margin Setting?', 'hcode-addons'),
      'param_name' => 'margin_setting',
      'value' => array(__('No', 'hcode-addons') => '0', 
                       __('Yes', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
        'group' => 'Style',
    ),
    array(
      'type' => 'dropdown',
      'param_name' => 'desktop_margin',
      'heading' => __('Margin (For Desktop Device)', 'hcode-addons' ),
      'value' => $hcode_desktop_margin,
      'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Margin (For All Devices)', 'hcode-addons' ),
      'param_name' => 'custom_desktop_margin',
      'dependency' => array( 'element' => 'desktop_margin', 'value' => array('custom-desktop-margin') ),
      'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
    ),
    array(
      'type' => 'dropdown',
      'param_name' => 'ipad_margin',
      'heading' => __('Margin (For iPad Device)', 'hcode-addons' ),
      'value' => $hcode_ipad_margin,
      'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
    ),
    array(
      'type' => 'dropdown',
      'param_name' => 'mobile_margin',
      'heading' => __('Margin (For Mobile Device)', 'hcode-addons' ),
      'value' => $hcode_mobile_margin,
      'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Title Color', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_title_color',
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group' => 'Style',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Notify Me Title Color', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_title_color',
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group' => 'Style',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Notify Me BackGround Color', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_bgcolor',
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group' => 'Style',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Notify Me Counter Color', 'hcode-addons' ),
      'param_name' => 'hcode_coming_soon_notify_me_counter_color',
      'dependency' => array( 'element' => 'hcode_coming_soon_type', 'value' => array('hcode-coming-soon-type1','hcode-coming-soon-type2','hcode-coming-soon-type3') ),
      'group' => 'Style',
    ),
    $hcode_vc_extra_id,
    $hcode_vc_extra_class,
  )
) );
