<?php
/**
 * Map For Blog
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Blog */
/*-----------------------------------------------------------------------------------*/

vc_map( array(
    'name' => __('Blog List', 'hcode-addons'),
    'description' => __( 'Create a blog list', 'hcode-addons' ),    
    'icon' => 'h-code-shortcode-icon fa fa-list',
    'base' => 'hcode_blog',
    'category' => 'H-Code',
    'params' => array(
      array(
          'type' => 'dropdown',
          'heading' => __('Style', 'hcode-addons'),
          'param_name' => 'hcode_blog_premade_style',
          'value' => array(__('Please Select Style', 'hcode-addons') => '',
                           __('Modern', 'hcode-addons') => 'modern',
                           __('Classic', 'hcode-addons') => 'classic',
                           __('Grid', 'hcode-addons') => 'grid',
                           __('Masonry', 'hcode-addons') => 'masonry',
                           __('Box', 'hcode-addons') => 'box',
                          ),
          'std' => 'grid',
      ),
      array(
          'type' => 'dropdown',
          'heading' => __('Column Type', 'hcode-addons'),
          'param_name' => 'hcode_blog_columns',
          'value' => array(__('Please Select Column Type', 'hcode-addons') => '',
                           __('2 Columns', 'hcode-addons') => '2',
                           __('3 Columns', 'hcode-addons') => '3',
                           __('4 Columns', 'hcode-addons') => '4',
                          ),
          'std' => '3',
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('grid','masonry','box') ),
      ),
      array(
          'type' => 'hcode_multiple_select_option',
          'heading' => __('Categories', 'hcode-addons'),
          'param_name' => 'hcode_categories_list',
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry','box') ),
      ),
      array(
          'type' => 'textfield',
          'heading' => __('No. of Posts per Page', 'hcode-addons'),
          'description' => __( 'Enter numeric value like 8', 'hcode-addons' ),
          'param_name' => 'hcode_post_per_page',
          'value'     => '15',
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry','box') ),
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Pagination', 'hcode-addons'),
          'param_name' => 'hcode_show_pagination',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'std' => '1',
          'description' => __( 'Select Yes to show pagination', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry','box') ),
      ),
      array(
          'type' => 'dropdown',
          'heading' => __( 'Pagination Style', 'hcode-addons' ),
          'param_name' => 'hcode_pagination_style',
          'value' => array(__( 'Number Pagination', 'hcode-addons' ) => 'number-pagination',
                           __( 'Infinite Scroll', 'hcode-addons' ) => 'infinite-scroll-pagination',
                          ),
          'std' => 'number-pagination',
          'dependency'  => array( 'element' => 'hcode_show_pagination', 'value' => array( '1' ) ),
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Post Title', 'hcode-addons'),
          'param_name' => 'hcode_show_post_title',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select YES to show post title', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry','box') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Thumbnail', 'hcode-addons'),
          'param_name' => 'hcode_show_thumbnail',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show thumbnail', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry') ),
          'group' => 'Settings',
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => __('Show Separator', 'hcode-addons'),
        'param_name' => 'hcode_show_separator',
        'value' => array(__('NO', 'hcode-addons') => '0', 
                         __('YES', 'hcode-addons') => '1'
                        ),
        'std' => '1',
        'description' => __( 'Select Yes to separator', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry') ),
        'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Author Name', 'hcode-addons'),
          'param_name' => 'hcode_show_author_name',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show author name', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry','box') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Date', 'hcode-addons'),
          'param_name' => 'hcode_show_date',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show date', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry','box') ),
          'group' => 'Settings',
      ),
      array(
          'type'        => 'textfield',
          'heading'     => __('Date Format', 'hcode-addons' ),
          'param_name'  => 'hcode_date_format',
          'description' => __( 'Date format should be like mm/dd/yyyy, <a target="_blank" href="https://codex.wordpress.org/Formatting_Date_and_Time">click here</a> to see other date formates', 'hcode-addons' ),
          'value'     => 'd m Y',
          'dependency'  => array( 'element' => 'hcode_show_date', 'value' => array('1') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Categories', 'hcode-addons'),
          'param_name' => 'hcode_show_categories',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show categories', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Excerpt', 'hcode-addons'),
          'param_name' => 'hcode_show_excerpt',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show excerpt, no to show full content', 'hcode-addons' ),
          'std'         => '1',
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry','box') ),
          'group' => 'Settings',
      ),
      array(
          'type'        => 'textfield',
          'heading'     => __('Excerpt Length', 'hcode-addons' ),
          'description' => __( 'Enter numeric value like 20', 'hcode-addons' ),
          'param_name'  => 'hcode_excerpt_length',
          'value'     => '55',
          'dependency'  => array( 'element' => 'hcode_show_excerpt', 'value' => array('1') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Full Content', 'hcode-addons'),
          'param_name' => 'hcode_show_content',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show blog full content', 'hcode-addons' ),
          'std'         => '1',
          'dependency'  => array( 'element' => 'hcode_show_excerpt', 'value' => array('0') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Content White Background', 'hcode-addons'),
          'param_name' => 'hcode_show_white_bg',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show white background', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Like', 'hcode-addons'),
          'param_name' => 'hcode_show_like',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show like', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry','box') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Share', 'hcode-addons'),
          'param_name' => 'hcode_show_share',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show share', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('box') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Comment', 'hcode-addons'),
          'param_name' => 'hcode_show_comment',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show comment', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry','box') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Continue Button', 'hcode-addons'),
          'param_name' => 'hcode_show_continue_button',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show continue button', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry') ),
          'group' => 'Settings',
      ),
      array(
          'type'        => 'textfield',
          'heading'     => __('Button Text', 'hcode-addons' ),
          'param_name'  => 'hcode_button_config',
          'admin_label' => true,
          'dependency'  => array( 'element' => 'hcode_show_continue_button', 'value' => array('1') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'dropdown',
          'heading' => __( 'Display Items Order by', 'hcode-addons' ),
          'param_name' => 'orderby',
          'value' => array(__('Select Order by', 'hcode-addons') => '',
                           __( 'Date', 'hcode-addons' ) => 'date',
                           __( 'ID', 'hcode-addons' ) => 'ID',
                           __( 'Author', 'hcode-addons' ) => 'author',
                           __( 'Title', 'hcode-addons' ) => 'title',
                           __( 'Modified', 'hcode-addons' ) => 'modified',
                           __( 'Random', 'hcode-addons' ) => 'rand',
                           __( 'Comment count', 'hcode-addons' ) => 'comment_count',
                           __( 'Menu order', 'hcode-addons' ) => 'menu_order',
                          ),
          'std' => 'date',
          'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry') ),
          'group' => 'Order',
      ),
      array(
        'type' => 'dropdown',
        'heading' => __( 'Display Items Sort by', 'hcode-addons' ),
        'param_name' => 'order',
        'value' => array(__('Select Sort by', 'hcode-addons') => '',
                         __( 'Descending', 'hcode-addons' ) => 'DESC',
                         __( 'Ascending', 'hcode-addons' ) => 'ASC',
                        ),
        'std' => 'DESC',
        'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry') ),
        'group' => 'Order',
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'hcode_animation_style',
        'heading' => __('Animation Style', 'hcode-addons' ),
        'value' => hcode_animation_style(),
        'dependency'  => array( 'element' => 'hcode_blog_premade_style', 'value' => array('modern','classic','grid','masonry') ),
        'group' => 'Animation',
      ),
      $hcode_vc_extra_id,
      $hcode_vc_extra_class,
    ),
) );