<?php
/**
 * Order Customer Details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details-customer.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 5.6.0
 */

defined( 'ABSPATH' ) || exit;

$show_shipping = ! wc_ship_to_billing_address_only() && $order->needs_shipping_address();
?>
<div class="col-md-12 col-sm-12 col-xs-12">

	<div class="col2-set addresses row">
		<div class="col-1 col-md-6 col-sm-6 col-xs-12">
			<div class="title">
				<h3 class="black-text font-weight-600 text-uppercase text-large margin-bottom-10px"><?php esc_html_e( 'Billing address', 'H-Code' ); ?></h3>
			</div>
			<address>
				<?php echo wp_kses_post( $order->get_formatted_billing_address( __( 'N/A', 'H-Code' ) ) ); ?>
				<?php if ( $order->get_billing_phone() ) : ?>
					<p class="woocommerce-customer-details--phone"><?php echo esc_html( $order->get_billing_phone() ); ?></p>
				<?php endif; ?>
				<?php if ( $order->get_billing_email() ) : ?> 
					<p class="woocommerce-customer-details--email"><?php echo esc_html( $order->get_billing_email() ); ?></p>
				<?php endif; ?>
			</address>
		</div><!-- /.col-1 -->
		<?php if ( $show_shipping ) : ?>
		<div class="col-2 col-md-6 col-sm-6 col-xs-12">
			<div class="title">
				<h3 class="black-text font-weight-600 text-uppercase text-large margin-bottom-10px"><?php esc_html_e( 'Shipping address', 'H-Code' ); ?></h3>
			</div>
			<address>
				<?php echo wp_kses_post( $order->get_formatted_shipping_address( __( 'N/A', 'H-Code' ) ) ); ?>
				<?php if ( $order->get_shipping_phone() ) : ?>
					<p class="woocommerce-customer-details--phone"><?php echo esc_html( $order->get_shipping_phone() ); ?></p>
				<?php endif; ?>
			</address>
		</div><!-- /.col-2 -->
		<?php endif; ?>
	</div><!-- /.col2-set -->
	<?php do_action( 'woocommerce_order_details_after_customer_details', $order ); ?>
</div>
