<?php
/**
 * Login form
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( is_user_logged_in() ) {
	return;
}

?>
<form method="post" class="woocommerce-form woocommerce-form-login login display-block" <?php if ( $hidden ) echo 'style="display:none;"'; ?>>

	<?php do_action( 'woocommerce_login_form_start' ); ?>

	<?php echo ( $message ) ? wpautop( wptexturize( $message ) ) : ''; // @codingStandardsIgnoreLine ?>
	<ul>
	<li class="form-row form-row-first">
		<label for="username"><?php esc_html_e( 'Username or email', 'H-Code' ); ?> <em class="required">*</em></label>
		<input type="text" class="input-text" name="username" id="username" />
	</li>
	<li class="form-row form-row-last">
		<label for="password"><?php esc_html_e( 'Password', 'H-Code' ); ?> <em class="required">*</em></label>
		<input class="input-text" type="password" name="password" id="password" />
	</li>


	<?php do_action( 'woocommerce_login_form' ); ?>

	<li class="form-row clear">
		<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
		<input type="submit" class="button btn btn-black no-margin-bottom btn-small" name="login" value="<?php esc_attr_e( 'Login', 'H-Code' ); ?>" />
		<input type="hidden" name="redirect" value="<?php echo esc_url( $redirect ) ?>" />
		<label for="rememberme" class="woocommerce-form__label woocommerce-form__label-for-checkbox inline">
			<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <?php esc_html_e( 'Remember me', 'H-Code' ); ?>
		</label>
		<p class="lost_password">
			<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'H-Code' ); ?></a>
		</p>
	</li>
	</ul>
	<div class="clear"></div>

	<?php do_action( 'woocommerce_login_form_end' ); ?>

</form>
