<?php
/**
 * Font Settings Tab For Theme Option.
 *
 * @package H-Code
 */
?>
<?php
$this->sections[] = array(
    'icon' => 'fa-solid fa-font',
    'title' => esc_html__('Font Settings', 'H-Code'),
    'desc' => esc_html__('Font Setting', 'H-Code'),
    'fields' => array(
        array(
            'id'        => 'opt_accordion_begin_general_font_family',
            'type'      => 'accordion',
            'title'     => esc_html__('Font Family', 'H-Code'),
            'subtitle'  => esc_html__('Set font family', 'H-Code'),
            'position'  => 'start',
        ),
        array(
            'id'       => 'disable_google_fonts',
            'type'     => 'switch',
            'title'    => esc_html__( 'Disable Google Fonts', 'H-Code' ),
            'default'  => false,
            '1'        => 'On',
            '0'        => 'Off',
        ),
        array(
            'id'       => '2',
            'type'     => 'typography',
            'title'    => esc_html__( 'Main Font', 'H-Code' ),
            'font-size'=> false,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'default'  => array(
                'font-family' => 'Open Sans',
            ),
            'output' => array(
                'body, input, textarea, select, .navbar-nav li.fas a, .navbar-nav li.fa-solid a, .navbar-nav li.far a, .navbar-nav li.fa-regular a, .navbar-nav li.fab a, .navbar-nav li.fa-brands a, .navbar-nav li.fas span,.navbar-nav li.fa-solid span, .navbar-nav li.far span, .navbar-nav li.fa-regular span, .navbar-nav li.fab span, .navbar-nav li.fa-brands span, .navbar-nav li.fas .dropdown-header, .navbar-nav li.fa-solid .dropdown-header, .navbar-nav li.far .dropdown-header, .navbar-nav li.fa-regular .dropdown-header, .navbar-nav li.fab .dropdown-header, .navbar-nav li.fa-brands .dropdown-header, footer ul li.menu-item.fas a, footer ul li.menu-item.far a, footer ul li.menu-item.fa-regular a, footer ul li.menu-item.fab a, footer ul li.menu-item.fa-brands a, .sidebar ul li.menu-item.fas a, .sidebar ul li.menu-item.fa-solid a, .sidebar ul li.menu-item.far a, .sidebar ul li.menu-item.fa-regular a, .sidebar ul li.menu-item.fab a, .sidebar ul li.menu-item.fa-brands a')
        ),
        array(
            'id'       => 'main_font_weight',
            'type'     => 'checkbox',
            'title'    => esc_html__( 'Main Font Weight', 'H-Code' ),
            'options'  => array(
                '100' => '100',
                '200' => '200',
                '300' => '300',
                '400' => '400',
                '500' => '500',
                '600' => '600',
                '700' => '700',
                '800' => '800',
                '900' => '900',
            ),
            'default' => array(
                '100' => '1',
                '300' => '1',
                '400' => '1',
                '500' => '1',
                '600' => '1',
                '700' => '1',
                '800' => '1',
                '900' => '1',
            ),
        ),
        array(
            'id'       => 'alt_font',
            'type'     => 'typography',
            'title'    => esc_html__( 'Alt Font', 'H-Code' ),
            'font-size'=> false,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'default'  => array(
                'font-family' => 'Oswald, sans-serif'
            ),
            'output' => array('.alt-font, .cd-headline span')
        ),
        array(
            'id'       => 'alt_font_weight',
            'type'     => 'checkbox',
            'title'    => esc_html__( 'Alt Font Weight', 'H-Code' ),
            'options'  => array(
                '100' => '100',
                '200' => '200',
                '300' => '300',
                '400' => '400',
                '500' => '500',
                '600' => '600',
                '700' => '700',
                '800' => '800',
                '900' => '900',
            ),
            'default' => array(
                '100' => '1',
                '300' => '1',
                '400' => '1',
                '500' => '1',
                '600' => '1',
                '700' => '1',
                '800' => '1',
                '900' => '1',
            ),
        ),
        
        array(
            'id'       => 'main_font_languages',
            'type'     => 'checkbox',
            'title'    => esc_html__( 'Font Languages', 'H-Code' ),
            'options'  => array(
                'cyrillic' => esc_html__( 'Cyrillic', 'H-Code' ),
                'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'H-Code' ),
                'greek' => esc_html__( 'Greek', 'H-Code' ),
                'greek-ext' => esc_html__( 'Greek Extended', 'H-Code' ),
                'latin-ext' => esc_html__( 'Latin Extended', 'H-Code' ),
                'vietnamese' => esc_html__( 'Vietnamese', 'H-Code' ),
            ),
            'default' => array(
                'cyrillic' => '1',
                'cyrillic-ext' => '1',
                'greek' => '1',
                'greek-ext' => '1',
                'latin-ext' => '1',
                'vietnamese' => '1',
            ),
        ),
        array(
            'id'        => 'opt_accordion_end_general_font_family',
            'type'      => 'accordion',
            'position'  => 'end'
        ),
        
        /* Font Size and Line Height */ 
        
        array(
            'id'        => 'opt_accordion_begin_general_font_size',
            'type'      => 'accordion',
            'title'     => esc_html__('Font Size', 'H-Code'),
            'subtitle'  => esc_html__('Set font size', 'H-Code'),
            'position'  => 'start',
        ),
        array(
            'id'       => 'body_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Body Font Size', 'H-Code' ),
            'line-height'=> true,
            'font-size'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '13px',
                'line-height' => '23px',
            ),
            'output' => array('body')
        ),
        array(
            'id'       => 'header_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '11px',
            ),
            'output' => array('.navbar .navbar-nav > li > a, .search-cart-header .subtitle'),
        ),
        array(
            'id'       => 'header_icon_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header Icon Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '13px',
            ),
            'output' => array('.top-cart .fa-shopping-cart, .search-cart-header i')
        ),
        array(
            'id'       => 'header_dropdown_menu_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header Dropdown Menu Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '11px',
            ),
            'output' => array('.dropdown-header, .dropdown-menu, .simple-dropdown > ul.dropdown-menu > li a')
        ),
        array(
            'id'       => 'header_hamburger_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Hamburger Menu Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'output' => array('.pull-menu .navbar-nav .mCSB_container > .menu-item > a, .full-width-pull-menu.navbar .navbar-nav > .menu-item > a,.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > .menu-item > a,.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > .menu-item > a.megamenu-right-icon > .fas'),
        ),
        array(
            'id'       => 'header_hamburger_submenu_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Hamburger Submenu Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'output' => array('.pull-menu .navbar-nav .mCSB_container > .menu-item > .sub-menu > .menu-item > a,.pull-menu .navbar-nav .mCSB_container > .menu-item > .sub-menu > .menu-item > .sub-menu > .menu-item > a,.full-width-pull-menu.navbar .navbar-nav > .menu-item > .sub-menu > .menu-item > a,.full-width-pull-menu.navbar .navbar-nav > .menu-item > .sub-menu > .menu-item > .sub-menu > .menu-item > a,.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > .menu-item > .sub-menu > .menu-item > a,.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > .menu-item > .sub-menu > .menu-item > .sub-menu > .menu-item > a,.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > .menu-item > .sub-menu > .menu-item >  a.megamenu-right-icon > .fas')
        ),
        array(
            'id'       => 'header_hamburger_number_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Number Font Size For Hamburger 3', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'output' => array('.hamburger-menu3.full-width-pull-menu-dark .menu-number')
        ),
        array(
            'id'        => 'hcode_first_header_menu_text_tranform',
            'type'     => 'typography',
            'text-transform' => true,
            'font-size'=> false,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'title'     => esc_html__( 'Menu Top Level Text Transform', 'H-Code' ),
            'output' => array('.navbar .navbar-nav > li > a,.navbar > .nav-header-container .search-cart-header a, .pull-menu .navbar-nav .mCSB_container > .menu-item > a, .full-width-pull-menu.navbar .navbar-nav > .menu-item > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > .menu-item > a')
        ),
        array(
            'id'        => 'hcode_second_header_menu_text_tranform',
            'type'     => 'typography',
            'text-transform' => true,
            'font-size'=> false,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'title'     => esc_html__( 'Menu Second Level Text Transform', 'H-Code' ),
            'output' => array('.navbar > .nav-header-container .dropdown-header,.cart-content ul.cart-list a, .pull-menu .navbar-nav .mCSB_container > .menu-item > .sub-menu > .menu-item > a,.full-width-pull-menu.navbar .navbar-nav > .menu-item > .sub-menu > .menu-item > a,.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > .menu-item > .sub-menu > .menu-item > a')
        ),
        array(
            'id'        => 'hcode_third_header_menu_text_tranform',
            'type'     => 'typography',
            'text-transform' => true,
            'font-size'=> false,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'title'     => esc_html__( 'Menu Third Level Text Transform', 'H-Code' ),
            'output' => array('.dropdown-menu li a,.navbar > .nav-header-container .navbar-nav > li.simple-dropdown > .dropdown-menu li a,.navbar > .nav-header-container .dropdown-menu li a, .pull-menu .navbar-nav .mCSB_container > .menu-item > .sub-menu > .menu-item > .sub-menu > .menu-item > a,.full-width-pull-menu.navbar .navbar-nav > .menu-item > .sub-menu > .menu-item > .sub-menu > .menu-item > a,.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > .menu-item > .sub-menu > .menu-item > .sub-menu > .menu-item > a')
        ),
        array(
            'id'       => 'h1_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Heading h1 Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '36px',
            ),
            'output' => array('h1')
        ),
        array(
            'id'       => 'h2_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Heading h2 Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '24px',
            ),
            'output' => array('h2')
        ),
        array(
            'id'       => 'h3_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Heading h3 Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '14px',
            ),
            'output' => array('h3')
        ),
        array(
            'id'       => 'h4_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Heading h4 Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '16px',
            ),
            'output' => array('h4')
        ),
        array(
            'id'       => 'h5_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Heading h5 Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '11px',
            ),
            'output' => array('h5')
        ),
        array(
            'id'       => 'h6_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Heading h6 Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '13px',
            ),
            'output' => array('h6')
        ),
        array(
            'id'       => 'section_title_h1_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Section Title h1 Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '36px',
            ),
            'output' => array('h1.section-title')
        ),
        array(
            'id'       => 'section_title_h2_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Section Title h2 Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '24px',
            ),
            'output' => array('h2.section-title')
        ),
        array(
            'id'       => 'section_title_h3_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Section Title h3 Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '20px',
            ),
            'output' => array('h3.section-title')
        ),
        array(
            'id'       => 'section_title_h5_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Section Title h5 Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '14px',
            ),
            'output' => array('h5.section-title')
        ),
        array(
            'id'       => 'section_title_h6_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Section Title h6 Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '13px',
            ),
            'output' => array('h6.section-title')
        ),
        array(
            'id'       => 'text_small_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Small Text Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '11px',
                'line-height' => '15px',
            ),
            'output' => array('.text-small')
        ),
        array(
            'id'       => 'text_medium_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Medium Text Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '14px',
                'line-height' => '26px',
            ),
            'output' => array('.text-med')
        ),
        array(
            'id'       => 'text_large_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Large Text Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '15px',
                'line-height' => '24px',
            ),
            'output' => array('.text-large')
        ),
        array(
            'id'       => 'text_extra_large_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Extra Large Text Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '16px',
                'line-height' => '28px',
            ),
            'output' => array('.text-extra-large')
        ),
        array(
            'id'       => 'text_small_title_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Small Title Text Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '20px',
                'line-height' => '30px',
            ),
            'output' => array('.title-small')
        ),
        array(
            'id'       => 'text_medium_title_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Medium Title Text Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '24px',
                'line-height' => '34px',
            ),
            'output' => array('.title-med')
        ),
        array(
            'id'       => 'text_large_title_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Large Title Text Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '28px',
                'line-height' => '41px',
            ),
            'output' => array('.title-large')
        ),
        array(
            'id'       => 'text_extra_large_title_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Extra Large Title Text Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '35px',
                'line-height' => '43px',
            ),
            'output' => array('.title-extra-large')
        ),
        array(
            'id'       => 'text_page_title_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Page Title Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '20px',
            ),
            'output' => array('.page-title h1')
        ),
        array(
            'id'       => 'text_page_subtitle_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Page Subtitle Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '14px',
            ),
            'output' => array('.page-title span')
        ),
        array(
            'id'       => 'text_page_breadcrumb_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Page Breadcrumb Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '11px',
            ),
            'output' => array('.breadcrumb ul li')
        ),
        array(
            'id'       => 'text_page_breadcrumb_pipe_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Page Breadcrumb Pipe Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '8px',
            ),
            'output' => array('.breadcrumb ul > li+li:before')
        ),
        array(
            'id'       => 'text_page_title_shop_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Page Title Shop Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '35px',
            ),
            'output' => array('.page-title-shop h1')
        ),
        array(
            'id'       => 'text_page_title_small_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Page Title Small Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '18px',
            ),
            'output' => array('.page-title-small h1')
        ),
        array(
            'id'       => 'text_standard_post_title_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Standard Post Title Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '18px',
                'line-height' => '24px',
            ),
            'output' => array('.blog-details-headline')
        ),
        array(
            'id'       => 'text_standard_post_meta_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Standard Post Meta Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '11px',
                'line-height' => '23px',
            ),
            'output' => array('.standard-post-meta')
        ),
        array(
            'id'       => 'text_full_width_header_post_title_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Full Width Header Post Title Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '40px',
                'line-height' => '55px',
            ),
            'output' => array('.full-width-headline h2')
        ),
        array(
            'id'       => 'text_full_width_header_post_meta_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Full Width Header Post Meta Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '13px',
                'line-height' => '23px',
            ),
            'output' => array('.full-width-headline .full-width-header-post-meta')
        ),
        array(
            'id'       => 'text_full_width_with_image_slider_post_title_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Full Width With Image Slider Post Title Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '50px',
                'line-height' => '64px',
            ),
            'output' => array('.blog-single-full-width-with-image-slider-headline')
        ),
        array(
            'id'       => 'text_full_width_with_image_slider_post_meta_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Full Width With Image Slider Post Meta Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '25px',
                'line-height' => '23px',
            ),
            'output' => array('.blog-headline .blog-single-full-width-with-image-slider-meta')
        ),
        array(
            'id'        => 'opt_accordion_end_general_font_size',
            'type'      => 'accordion',
            'position'  => 'end'
        ),
        array(
            'id'        => 'opt_accordion_begin_general_footer_wrapper_font',
            'type'      => 'accordion',
            'title'     => esc_html__( 'Footer Wrapper Font Setting', 'H-Code' ),
            'subtitle'  => esc_html__( 'Set font settings on Footer Wrapper', 'H-Code' ),
            'position'  => 'start',
        ),
        array(
            'id'       => 'footer_wrapper_text_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Text Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'letter-spacing' => true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'output' => array( 'footer .hcode-footer-wrapper, footer .hcode-footer-wrapper h6' )
        ),
        array(
            'id'       => 'footer_wrapper_icon_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Icon Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'letter-spacing' => false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'output' => array( 'footer .hcode-footer-wrapper i' )
        ),
        array(
            'id'        => 'opt_accordion_end_general_footer_wrapper_font',
            'type'      => 'accordion',
            'position'  => 'end'
        ),
        array(
            'id'        => 'opt_accordion_begin_general_footer_font',
            'type'      => 'accordion',
            'title'     => esc_html__( 'Footer Font Setting', 'H-Code' ),
            'subtitle'  => esc_html__( 'Set font settings on Footer', 'H-Code' ),
            'position'  => 'start',
        ),
        array(
            'id'       => 'text_footer_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Footer Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'letter-spacing' => true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'output' => array('footer, footer ul li a, .copyright')
        ),
        array(
            'id'       => 'text_footer_widget_title_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Footer Widget Title Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'letter-spacing' => true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'output' => array('footer .sidebar-title')
        ),
        array(
            'id'       => 'text_footer_social_icon_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Footer Social Icon Font Size', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> false,
            'letter-spacing' => false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview' => false,
            'output' => array( 'footer .footer-social i' )
        ),
        array(
            'id'        => 'opt_accordion_end_general_footer_font',
            'type'      => 'accordion',
            'position'  => 'end'
        ),
        array(
            'id'        => 'opt_accordion_begin_general_portfolio_cat_font',
            'type'      => 'accordion',
            'title'     => esc_html__('Portfolio Category / Archive Font Setting', 'H-Code'),
            'subtitle'  => esc_html__('Set font settings on portfolio Category, Archive page', 'H-Code'),
            'position'  => 'start',
        ),
        array(
            'id'       => 'text_portfolio_cat_title_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Title Font Settings', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => true,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'preview'     => false,
            'output' => array('.portfolio-archive-page .portfolio-archive-title, .portfolio-archive-page .portfolio-archive-title a')
        ),
        array(
            'id'       => 'text_portfolio_cat_subtitle_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Subtitle Font Settings', 'H-Code' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => true,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'preview'     => false,
            'output' => array('.portfolio-archive-page .portfolio-archive-subtitle')
        ),
        array(
            'id'        => 'opt_accordion_end_general_portfolio_cat_font',
            'type'      => 'accordion',
            'position'  => 'end'
        ),
    ),
);