<?php
/**
 * Color Settings Tab For Theme Option.
 *
 * @package H-Code
 */
?>
<?php
$this->sections[] = array(
    'icon' => 'fa-solid fa-tint',
    'title' => esc_html__('Color Settings', 'H-Code'),
    'desc' => esc_html__('Configure content styles', 'H-Code'),
    'fields' => array(
            array(
                'id'        => 'opt_accordion_begin_general_body_typography',
                'type'      => 'accordion',
                'title'     => esc_html__('Background Color', 'H-Code'),
                'subtitle'  => esc_html__('Set background color', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'body-bg-color',
                'type'     => 'color',
                'title'    => __( 'Body Background', 'H-Code' ),
                'default'  => '',
                'output' => array('background' => 'body'),
            ),
            array(
                'id'       => 'bg-black-overlay-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0, 0, 0, 0.85)"></div>'.__( 'Black Background Opacity', 'H-Code' ),
                'output' => array('background' => '.bg-blck-overlay'),
                'default' =>  array( 'color' => '#000', 'alpha' => '0.85' ),
            ),
            array(
                'id'       => 'text-bg-white',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'White Background', 'H-Code' ),
                'default'  => '#FFF',
                'output'    => array('background' => '.bg-white'),
            ),
            array(
                'id'       => 'text-bg-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e6af2a"></div>'.__( 'Yellow Background', 'H-Code' ),
                'default'  => '#e6af2a',
                'output' => array('background' => '.bg-yellow'),
            ),
            array(
                'id'       => 'text-bg-deep-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f7f5e7"></div>'.__( 'Deep Yellow Background', 'H-Code' ),
                'default'  => '#f7f5e7',
                'output' => array('background' => '.bg-deep-yellow'),
            ),
            array(
                'id'       => 'text-bg-golden-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#c3bd86"></div>'.__( 'Deep Golden Background', 'H-Code' ),
                'default'  => '#c3bd86',
                'output' => array('background' => '.bg-golden-yellow'),
            ),

            array(
                'id'       => 'text-bg-fast-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fdd947"></div>'.__( 'Fast Yellow Background', 'H-Code' ),
                'default'  => '#fdd947',
                'output' => array('background' => '.bg-fast-yellow'),
            ),
            array(
                'id'       => 'text-bg-dark-gray',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#252525"></div>'.__( 'Dark Gray Background', 'H-Code' ),
                'default'  => '#252525',
                'output' => array('background' => '.bg-dark-gray'),
            ),
            array(
                'id'       => 'text-bg-mid-gray',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d4d4d4"></div>'.__( 'Dark Mid Background', 'H-Code' ),
                'default'  => '#d4d4d4',
                'output' => array('background' => '.bg-mid-gray'),
            ),
            array(
                'id'       => 'text-bg-black',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Black Background', 'H-Code' ),
                'default'  => '#000',
                'output' => array('background' => '.bg-black'),
            ),
            array(
                'id'       => 'text-bg-green',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#70bd5b"></div>'.__( 'Green Background', 'H-Code' ),
                'default'  => '#70bd5b',
                'output' => array('background' => '.bg-green'),
            ),
            array(
                'id'       => 'text-bg-gray',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f6f6f6"></div>'.__( 'Gray Background', 'H-Code' ),
                'default'  => '#f6f6f6',
                'output' => array('background' => '.bg-gray'),
            ),
            array(
                'id'       => 'text-bg-yellow-ochre',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#997546"></div>'.__( 'Yellow Ochre Background', 'H-Code' ),
                'default'  => '#997546',
                'output' => array('background' => '.bg-yellow-ochre'),
            ),
            array(
                'id'       => 'text-bg-deep-brown',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#544441"></div>'.__( 'Deep Brown Background', 'H-Code' ),
                'default'  => '#544441',
                'output' => array('background' => '.bg-deep-brown'),
            ),
            array(
                'id'       => 'text-bg-orange',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#c24742"></div>'.__( 'Orange Background', 'H-Code' ),
                'default'  => '#c24742',
                'output' => array('background' => '.bg-orange'),
            ),
            array(
                'id'       => 'text-bg-deep-orange',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f15a22"></div>'.__( 'Deep Orange Background', 'H-Code' ),
                'default'  => '#f15a22',
                'output' => array('background' => '.bg-deep-orange'),
            ),
            array(
                'id'       => 'text-bg-fast-orange',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ff513b"></div>'.__( 'Fast Orange Background', 'H-Code' ),
                'default'  => '#ff513b',
                'output' => array('background' => '.bg-fast-orange'),
            ),
            array(
                'id'       => 'text-bg-pink',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#c2345f"></div>'.__( 'Pink Background', 'H-Code' ),
                'default'  => '#c2345f',
                'output' => array('background' => '.bg-pink'),
            ),
            array(
                'id'       => 'text-bg-deep-red',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e75e50"></div>'.__( 'Deep Red Background', 'H-Code' ),
                'default'  => '#e75e50',
                'output' => array('background' => '.bg-deep-red'),
            ),
            array(
                'id'       => 'text-bg-red',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d21616"></div>'.__( 'Red Background', 'H-Code' ),
                'default'  => '#d21616',
                'output' => array('background' => '.bg-red'),
            ),
            array(
                'id'       => 'text-bg-deep-pink',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e53878"></div>'.__( 'Deep Pink Background', 'H-Code' ),
                'default'  => '#e53878',
                'output' => array('background' => '.bg-deep-pink'),
            ),
            array(
                'id'       => 'text-bg-light-pink',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#dc378e"></div>'.__( 'Light Pink Background', 'H-Code' ),
                'default'  => '#dc378e',
                'output' => array('background' => '.bg-light-pink'),
            ),
            array(
                'id'       => 'text-bg-fast-pink',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ff1a56"></div>'.__( 'Fast Pink Background', 'H-Code' ),
                'default'  => '#ff1a56',
                'output' => array('background' => '.bg-fast-pink'),
            ),
            array(
                'id'       => 'text-bg-magenta',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d94378"></div>'.__( 'Magenta Background', 'H-Code' ),
                'default'  => '#d94378',
                'output' => array('background' => '.bg-magenta'),
            ),
            array(
                'id'       => 'text-bg-light-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f8f7f5"></div>'.__( 'Light Yellow Background', 'H-Code' ),
                'default'  => '#f8f7f5',
                'output' => array('background' => '.bg-light-yellow'),
            ),
            array(
                'id'       => 'text-bg-dark-green',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#60a532"></div>'.__( 'Dark Green Background', 'H-Code' ),
                'default'  => '#60a532',
                'output' => array('background' => '.bg-dark-green'),
            ),
            array(
                'id'       => 'text-bg-dark-blue',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#3273a5"></div>'.__( 'Dark Blue Background', 'H-Code' ),
                'default'  => '#3273a5',
                'output' => array('background' => '.bg-dark-blue'),
            ),
            array(
                'id'       => 'text-bg-violet',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#6c407e"></div>'.__( 'Violet Background', 'H-Code' ),
                'default'  => '#6c407e',
                'output' => array('background' => '.bg-violet'),
            ),
            array(
                'id'       => 'text-bg-light-gray',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f8f7f7"></div>'.__( 'Light gray Background', 'H-Code' ),
                'default'  => '#f8f7f7',
                'output' => array('background' => '.bg-light-gray'),
            ),
            array(
                'id'       => 'text-bg-light-gray2',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f4f4f4"></div>'.__( 'Light Gray2 Background', 'H-Code' ),
                'default'  => '#f4f4f4',
                'output' => array('background' => '.bg-light-gray2'),
            ),
            array(
                'id'       => 'text-bg-light-gray3',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fcfcfc"></div>'.__( 'Light Gray3 Background', 'H-Code' ),
                'default'  => '#fcfcfc',
                'output' => array('background' => '.bg-light-gray3'),
            ),
            array(
                'id'       => 'text-bg-slider-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27, 22, 28, 0.9)"></div>'.__( 'Slider Background', 'H-Code' ),
                //'default'  => 'rgba(27, 22, 28, 0.9)',
                'output' => array('background' => '.bg-slider'),
                'default' =>  array( 'color' => '#1b161c', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-wide-separator-line',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e5e5e5"></div>'.__( 'Wide Separator Line Background', 'H-Code' ),
                'default'  => '#e5e5e5',
                'output' => array('background' => '.wide-separator-line'),
            ),
            array(
                'id'       => 'text-bg-video-background-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(67,67,67,0.5)"></div>'.__( 'Video Background', 'H-Code' ),
                'output' => array('background' => '.video-background'),
                'default'       =>  array( 'color' => '#434343', 'alpha' => '0.5' ),
            ),
            
            array(
                'id'       => 'text-bg-overlay-yellow',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ffca18"></div>'.__( 'Overlay Yellow Background', 'H-Code' ),
                'default'  => '#ffca18',
                'output' => array('background' => '.overlay-yellow'),
            ),
            array(
                'id'       => 'text-bg-overlay-blue',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#8ac4fe"></div>'.__( 'Overlay Blue Background', 'H-Code' ),
                'default'  => '#8ac4fe',
                'output' => array('background' => '.overlay-blue'),
            ),
            array(
                'id'       => 'text-bg-overlay-gray',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f4f5f6"></div>'.__( 'Overlay gray Background', 'H-Code' ),
                'default'  => '#f4f5f6',
                'output' => array('background' => '.overlay-gray'),
            ),
            array(
                'id'       => 'text-bg-overlay-green',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#71f1b9"></div>'.__( 'Overlay Green Background', 'H-Code' ),
                'default'  => '#71f1b9',
                'output' => array('background' => '.overlay-green'),
            ),
            array(
                'id'        => 'opt_accordion_end_general_body_typography',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            /* Header Colors */
            
            array(
                'id'        => 'opt_accordion_begin_general_header_bg_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Header Background Color', 'H-Code'),
                'subtitle'  => esc_html__('Set header background color', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'default-nav-bg',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Default Header Background', 'H-Code' ),
                'output' => array('background' => '.transparent-header'),
            ),
            array(
                'id'       => 'default-nav',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fff"></div>'.__( 'Default Header Background - On Scroll', 'H-Code' ),
                'default'  => '#fff',
                'output' => array('background' => '.transparent-header.shrink-nav'),
            ),
            array(
                'id'       => 'text-bg-dropdown-menu',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27,22,28,0.95)"></div>'.__( 'Default Header - Dropdown Menu Background', 'H-Code' ),
                'output' => array('background' => '.dropdown-menu, .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu, .navbar > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children, .navbar > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu, .navbar > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children li .children, .navbar > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu li .sub-menu'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'text-bg-cart-content-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27, 22, 28, 0.95)"></div>'.__( 'Default Header - Cart Content Background', 'H-Code' ),
                'output' => array('background' => '.cart-content'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'white-nav-bg',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fff"></div>'.__( 'White Header Background', 'H-Code' ),
                'default'  => '#fff',
                'output' => array('background' => '.white-header'),
            ),
            array(
                'id'       => 'white-nav',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fff"></div>'.__( 'White Header Background - On Scroll', 'H-Code' ),
                'default'  => '#fff',
                'output' => array('background' => '.white-header.shrink-nav'),
            ),
            array(
                'id'       => 'white-nav-dropdown-menu',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27,22,28,0.95)"></div>'.__( 'White Header - Dropdown Menu Background', 'H-Code' ),
                'output' => array('background' => '.white-header .dropdown-menu, .white-header .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu, .navbar.white-header > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children, .navbar.white-header > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu, .navbar.white-header > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children li .children, .navbar.white-header > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu li .sub-menu'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'white-nav-cart-content-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27, 22, 28, 0.95)"></div>'.__( 'White Header - Cart Content Background', 'H-Code' ),
                'output' => array('background' => '.white-header .search-cart-header .cart-content'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'sticky-nav',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fff"></div>'.__( 'Sticky Header Background', 'H-Code' ),
                'default'  => '#fff',
                'output' => array('background' => '.static-sticky, header .static-sticky'),
            ),
            array(
                'id'       => 'sticky-nav-scroll',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fff"></div>'.__( 'Sticky Header Background - On Scroll', 'H-Code' ),
                'default'  => '#fff',
                'output' => array('background' => '.static-sticky.shrink-nav, header .static-sticky.shrink-nav'),
            ),
            array(
                'id'       => 'sticky-nav-dropdown-menu',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27,22,28,0.95)"></div>'.__( 'Sticky Header - Dropdown Menu Background', 'H-Code' ),
                'output' => array('background' => 'header .static-sticky .dropdown-menu, header .static-sticky .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu, .static-sticky .dropdown-menu, .static-sticky .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu, .navbar.static-sticky > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children, .navbar.static-sticky > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu, .navbar.static-sticky > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children li .children, .navbar.static-sticky > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu li .sub-menu'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'sticky-nav-cart-content-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27, 22, 28, 0.95)"></div>'.__( 'Sticky Header - Cart Content Background', 'H-Code' ),
                'output' => array('background' => 'header .static-sticky .cart-content, .static-sticky .cart-content'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'gray-sticky-nav',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f6f6f6"></div>'.__( 'Gray Sticky Header Background', 'H-Code' ),
                'default'  => '#f6f6f6',
                'output' => array('background' => '.static-sticky-gray, header .static-sticky-gray'),
            ),
            array(
                'id'       => 'gray-sticky-nav-scroll',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f6f6f6"></div>'.__( 'Gray Sticky Header Background - On Scroll', 'H-Code' ),
                'default'  => '#fff',
                'output' => array('background' => '.static-sticky-gray.shrink-nav, header .static-sticky-gray.shrink-nav'),
            ),
            array(
                'id'       => 'gray-sticky-nav-dropdown-menu',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27,22,28,0.95)"></div>'.__( 'Gray Sticky Header - Dropdown Menu Background', 'H-Code' ),
                'output' => array('background' => 'header .static-sticky-gray .dropdown-menu, header .static-sticky-gray .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu, .navbar.static-sticky-gray > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children, .navbar.static-sticky-gray > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu, .navbar.static-sticky-gray > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children li .children, .navbar.static-sticky-gray > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu li .sub-menu'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'gray-sticky-nav-cart-content-rgba',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(27, 22, 28, 0.95)"></div>'.__( 'Gray Sticky Header - Cart Content Background', 'H-Code' ),
                'output' => array('background' => 'header .static-sticky-gray .cart-content'),
                'default'       =>  array( 'color' => '#1b161c', 'alpha' => '0.95' ),
            ),
            array(
                'id'       => 'text-bg-nav-dark',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Dark Header Background', 'H-Code' ),
                'default'  => '#000',
                'output' => array('background' => '.nav-dark'),
            ),
            array(
                'id'       => 'text-bg-nav-dark-scroll',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Dark Header Background - On Scroll', 'H-Code' ),
                'default'  => '#000',
                'output' => array('background' => '.nav-dark.shrink-nav'),
            ),
            array(
                'id'       => 'dark-header-dropdown',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Dark Header - Dropdown Menu Background', 'H-Code' ),
                'output' => array('background' => '.nav-dark .dropdown-menu, .nav-dark .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu, .navbar.nav-dark > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children, .navbar.nav-dark > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu, .navbar.nav-dark > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children li .children, .navbar.nav-dark > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu li .sub-menu'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'dark-header-cart',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Dark Header - Cart Content Background', 'H-Code' ),
                'output' => array('background' => '.nav-dark .cart-content'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-dark-transparent-rgb',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.8)"></div>'.__( 'Transparent Dark Header Background', 'H-Code' ),
                'output' => array('background' => '.nav-dark-transparent'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.8' ),
            ),
            array(
                'id'       => 'text-bg-nav-dark-transparent-rgb-scroll',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.8)"></div>'.__( 'Transparent Dark Header Background - On Scroll', 'H-Code' ),
                'output' => array('background' => '.nav-dark-transparent.shrink-nav'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.8' ),
            ),
            array(
                'id'       => 'text-bg-nav-dark-transparent-dropdown',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Transparent Dark Header - Dropdown Menu Background', 'H-Code' ),
                'output' => array('background' => '.nav-dark-transparent .dropdown-menu, .nav-dark-transparent .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu, .navbar.nav-dark-transparent > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children, .navbar.nav-dark-transparent > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu, .navbar.nav-dark-transparent > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children li .children, .navbar.nav-dark-transparent > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu li .sub-menu'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-dark-transparent-cart',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Transparent Dark Header - Cart Content Background', 'H-Code' ),
                'output' => array('background' => '.nav-dark-transparent .cart-content'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-light-transparent',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(255,255,255,0.8)"></div>'.__( 'Transparent Light Header Background', 'H-Code' ),
                'output' => array('background' => '.nav-light-transparent'),
                'default'       =>  array( 'color' => '#fff', 'alpha' => '0.8' ),
            ),
            array(
                'id'       => 'text-bg-nav-light-transparent-scroll',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(255,255,255,0.8)"></div>'.__( 'Transparent Light Header Background - On Scroll', 'H-Code' ),
                'output' => array('background' => '.nav-light-transparent.shrink-nav'),
                'default'       =>  array( 'color' => '#fff', 'alpha' => '0.8' ),
            ),
            array(
                'id'       => 'text-bg-nav-light-transparent-dropdown',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Transparent Light Header - Dropdown Menu Background', 'H-Code' ),
                'output' => array('background' => '.nav-light-transparent .dropdown-menu, .nav-light-transparent .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu, .navbar.nav-light-transparent > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children, .navbar.nav-light-transparent > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu, .navbar.nav-light-transparent > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children li .children, .navbar.nav-light-transparent > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu li .sub-menu'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-light-transparent-cart',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Transparent Light Header - Cart Content Background', 'H-Code' ),
                'output' => array('background' => '.nav-light-transparent .cart-content'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-non-sticky',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fff"></div>'.__( 'Non Sticky Header Background', 'H-Code' ),
                'default'  => '#fff',
                'output' => array('background' => '.non-sticky'),
            ),
            array(
                'id'       => 'text-bg-nav-non-sticky-dropdown',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Non Sticky Header - Dropdown Menu Background', 'H-Code' ),
                'output' => array('background' => '.non-sticky .dropdown-menu, .non-sticky .simple-dropdown > ul.dropdown-menu > li > ul.mega-sub-menu, .navbar.non-sticky > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children, .navbar.non-sticky > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu, .navbar.non-sticky > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children li .children, .navbar.non-sticky > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu li .sub-menu'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-non-sticky-cart',
                'type'     => 'color_rgba',
                'title'    => '<div class="color-box" style="background-color:rgba(0,0,0,0.9)"></div>'.__( 'Non Sticky Header - Cart Content Background', 'H-Code' ),
                'output' => array('background' => '.non-sticky .cart-content'),
                'default'       =>  array( 'color' => '#000', 'alpha' => '0.9' ),
            ),
            array(
                'id'       => 'text-bg-nav-hamburger-1',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Hamburger 1 Header Background', 'H-Code' ),
                'default'  => '#000',
                'output' => array('background' => '.hamburger-menu1'),
            ),
            array(
                'id'       => 'text-bg-nav-hamburger-2',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#1a1a1a"></div>'.__( 'Hamburger 2 Header Background', 'H-Code' ),
                'default'  => '#1a1a1a',
                'output' => array('background' => '.full-width-pull-menu .menu-wrap'),
            ),
            array(
                'id'       => 'text-bg-nav-hamburger-3',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ffffff"></div>'.__( 'Hamburger 3 Header Background', 'H-Code' ),
                'default'  => '#ffffff',
                'output' => array('background' => '.bg-hamburger-menu3'),
            ),
            array(
                'id'        => 'opt_accordion_end_general_header_bg_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
            
            /* Text Color */
            
            array(
                'id'        => 'opt_accordion_begin_general_header_text_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Text Color', 'H-Code'),
                'subtitle'  => esc_html__('Set text color', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'text-body',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#626262"></div>'.__( 'Body Text', 'H-Code' ),
                'default'  => '#626262',
                'output' => array('body'),
            ),
            array(
                'id'       => 'text-link',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Link Text', 'H-Code' ),
                'default'  => '#000',
                'output' => array('a'),
            ),
            array(
                'id'       => 'text-link-hover',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#575757"></div>'.__( 'Link Hover Text', 'H-Code' ),
                'default'  => '#575757',
                'output' => array('a:hover'),
            ),
            array(
                'id'       => 'text-heading-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Heading Text', 'H-Code' ),
                'default'  => '#000',
                'output' => array('h1, h2, h3, h4, h5'),
            ),
            array(
                'id'       => 'text-white-text-link-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'White Breadcrumb Title & link', 'H-Code' ),
                'default'  => '#FFF',
                'output' => array('.breadcrumb-white-text a, .breadcrumb-white-text li'),
            ),
            array(
                'id'       => 'text-gray-link-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#575757"></div>'.__( 'Gray Breadcrumb Title & link', 'H-Code' ),
                'default'  => '#575757',
                'output' => array('.breadcrumb-gray-text a, .breadcrumb-gray-text'),
            ),
            array(
                'id'       => 'text-icon-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#9a9a9a"></div>'.__( 'Icon Text', 'H-Code' ),
                'default'  => '#9a9a9a',
                'output' => array('i'),
            ),
            array(
                'id'       => 'text-white-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'White Text', 'H-Code' ),
                'default'  => '#FFF',
                'output' => array('.white-text'),
            ),
            array(
                'id'       => 'text-magenta-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d94378"></div>'.__( 'Magenta Text', 'H-Code' ),
                'default'  => '#d94378',
                'output' => array('.magenta-text'),
            ),
            array(
                'id'       => 'text-orange-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ff513b"></div>'.__( 'Orange Text', 'H-Code' ),
                'default'  => '#ff513b',
                'output' => array('.orange-text'),
            ),
            array(
                'id'       => 'text-orange-light-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ef824c"></div>'.__( 'Orange Light Text', 'H-Code' ),
                'default'  => '#ef824c',
                'output' => array('.orange-light-text'),
            ),
            array(
                'id'       => 'text-deep-red-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e75e50"></div>'.__( 'Deep Red Text', 'H-Code' ),
                'default'  => '#e75e50',
                'output' => array('.deep-red-text'),
            ),
            array(
                'id'       => 'text-red-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d50f0f"></div>'.__( 'Red Text', 'H-Code' ),
                'default'  => '#d50f0f',
                'output' => array('.red-text'),
            ),
            array(
                'id'       => 'text-black-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000000"></div>'.__( 'Black Text', 'H-Code' ),
                'default'  => '#000000',
                'output' => array('.black-text'),
            ),
            array(
                'id'       => 'text-black-text-link',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000000"></div>'.__( 'Black Link Text', 'H-Code' ),
                'default'  => '#000000',
                'output' => array('a.black-text-link, a.black-text-link i, footer ul.list-inline li a'),
            ),
            array(
                'id'       => 'text-black-text-link-hover',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#858585"></div>'.__( 'Black Link Hover Text', 'H-Code' ),
                'default'  => '#858585',
                'output' => array('a.black-text-link:hover, a.black-text-link:hover i, footer ul.list-inline li a:hover'),
            ),
            array(
                'id'       => 'text-white-text-link',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'White Link Text', 'H-Code' ),
                'default'  => '#FFF',
                'output' => array('a.white-text-link, a.white-text-link i'),
            ),
            array(
                'id'       => 'link-text-white-text-hover',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ababab"></div>'.__( 'White Link Hover Text', 'H-Code' ),
                'default'  => '#ababab',
                'output' => array('a.white-text-link:hover, a.white-text-link:hover i'),
            ),
            array(
                'id'       => 'text-gray-text-link',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#626262"></div>'.__( 'Gray Link Text', 'H-Code' ),
                'default'  => '#626262',
                'output' => array('a.gray-text-link, footer ul li a'),
            ),
            array(
                'id'       => 'text-gray-text-hover',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000"></div>'.__( 'Gray Link Hover Text', 'H-Code' ),
                'default'  => '#000',
                'output' => array('a.gray-text-link:hover, footer ul li a:hover'),
            ),
            array(
                'id'       => 'text-yellow-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#e6af2a"></div>'.__( 'Yellow Text', 'H-Code' ),
                'default'  => '#e6af2a',
                'output' => array('.yellow-text'),
            ),
            array(
                'id'       => 'text-yellow-text2',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#fdd947"></div>'.__( 'Yellow Text2', 'H-Code' ),
                'default'  => '#fdd947',
                'output' => array('.yellow-text2'),
            ),
            array(
                'id'       => 'text-fast-yellow-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#f7d23d"></div>'.__( 'Fast Yellow Text', 'H-Code' ),
                'default'  => '#f7d23d',
                'output' => array('.fast-yellow-text'),
            ),
            array(
                'id'       => 'text-pink-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#d9378e"></div>'.__( 'Pink Text', 'H-Code' ),
                'default'  => '#d9378e',
                'output' => array('.pink-text'),
            ),
            array(
                'id'       => 'text-light-gray-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#ababab"></div>'.__( 'Light Gray Text', 'H-Code' ),
                'default'  => '#ababab',
                'output' => array('.light-gray-text'),
            ),
            array(
                'id'       => 'text-light-gray-text2',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#828282"></div>'.__( 'Light Gray Text2', 'H-Code' ),
                'default'  => '#828282',
                'output' => array('.light-gray-text2, .blog-date, .blog-date a'),
            ),
            array(
                'id'       => 'text-deep-gray-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#464646"></div>'.__( 'Deep Gray Text', 'H-Code' ),
                'default'  => '#464646',
                'output' => array('.deep-gray-text'),
            ),
            array(
                'id'       => 'text-deep-light-gray-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#878787"></div>'.__( 'Deep Light Gray Text', 'H-Code' ),
                'default'  => '#878787',
                'output' => array('.deep-light-gray-text'),
            ),
            array(
                'id'       => 'text-gray-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#7f7f7f"></div>'.__( 'Gray Text', 'H-Code' ),
                'default'  => '#7f7f7f',
                'output' => array('.gray-text'),
            ),
            array(
                'id'       => 'text-dark-gray-text',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#373737"></div>'.__( 'Dark Gray Text', 'H-Code' ),
                'default'  => '#373737',
                'output' => array('.dark-gray-text'),
            ),
            array(
                'id'        => 'opt_accordion_end_general_header_text_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            /* Header Text Color */
                        
            array(
                'id'        => 'opt_accordion_begin_menu_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Header Text Color', 'H-Code'),
                'subtitle'  => esc_html__('Set menu and submenu text color.', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'menu-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Text Color', 'H-Code' ),
                'output'   => array('color' => '.navbar .navbar-nav > li > a, .navbar > .nav-header-container .search-cart-header .top-cart > a, .navbar > .nav-header-container .search-cart-header #top-search > a, .navbar.nav-black .navbar-nav > li > a, .navbar.nav-black > .nav-header-container .search-cart-header .top-cart > a, .navbar.nav-black > .nav-header-container .search-cart-header #top-search > a,  .pull-menu .navbar-nav li > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > li > a, .hcode-menu-custom-color .navbar.pull-menu .navbar-nav li > a'),
            ),
            array(
                'id'       => 'menu-text-hover-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Text Hover Color', 'H-Code' ),
                'output'   => array('color' => '.navbar .navbar-nav > li:hover > a, .navbar .navbar-nav > li > a.active, .navbar .navbar-nav > li.open > a, .navbar > .nav-header-container .navbar-nav > li.current-menu-ancestor > a, .navbar > .nav-header-container .navbar-nav > li.current-menu-item > a, .navbar > .nav-header-container .search-cart-header .top-cart:hover > a, .navbar > .nav-header-container .search-cart-header #top-search:hover > a, .navbar.nav-black .navbar-nav > li:hover > a, .navbar.nav-black > .nav-header-container .search-cart-header .top-cart:hover > a, .navbar.nav-black > .nav-header-container .search-cart-header #top-search:hover > a, .pull-menu .navbar-nav li:hover > a, .pull-menu .navbar-nav li > a.active, .pull-menu .navbar-nav li.current-menu-ancestor > a, .pull-menu .navbar-nav li.current-menu-ancestor > a, .pull-menu .navbar-nav li.current-menu-item > a, .pull-menu .navbar-nav li.current-menu-ancestor ul li.current-menu-item > a, .full-width-pull-menu.navbar .navbar-nav li:hover > a, .full-width-pull-menu.navbar .navbar-nav li > a.active, .navbar.full-width-pull-menu.navbar .navbar-nav li > a.active, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li.current-menu-ancestor > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > li:hover > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav > li > a.active, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li.current-menu-item > a, .hcode-menu-custom-color .navbar.pull-menu .navbar-nav li:hover > a, .hcode-menu-custom-color .navbar.pull-menu .navbar-nav li > a.active, .navbar .navbar-nav > li:hover, .navbar .navbar-nav > li.open, .navbar .navbar-nav > li.current-menu-ancestor, .navbar .navbar-nav > li.current-menu-item, .pull-menu .navbar-nav li:hover, .pull-menu .navbar-nav li:hover, .pull-menu .navbar-nav li.open, .pull-menu .navbar-nav li.current-menu-item, .pull-menu .navbar-nav li.current-menu-ancestor' ),
            ),
            array(
                'id'       => 'menu-text-hover-underline-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Text Hover Underline Color', 'H-Code' ),
                'output'   => array('border-bottom-color' => '.navbar > .nav-header-container .navbar-nav > li.current-menu-ancestor > a, .navbar > .nav-header-container .navbar-nav > li.current-menu-item > a, .navbar-default .navbar-nav > li > a:hover, .navbar-default .navbar-nav > li:hover > a, .navbar-default .navbar-nav > li > a.active, .navbar-default .navbar-nav > li.open > a, .navbar-default .navbar-nav > li.open > a:hover, .navbar-default .navbar-nav > li.open:hover > a, .pull-menu .navbar-nav li:hover > a, .pull-menu .navbar-nav li > a.active, .pull-menu .navbar-nav li.current-menu-ancestor > a, .pull-menu .navbar-nav li.current-menu-item > a, .pull-menu .navbar-nav li.current-menu-ancestor > a, .pull-menu .navbar-nav li.current-menu-ancestor ul li.current-menu-item > a' ),
            ),
            array(
                'id'       => 'menu-text-hover-underline-shrink-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Text Hover Underline Shrink Color', 'H-Code' ),
                'output'   => array('border-bottom-color' => '.navbar.shrink-nav > .nav-header-container .navbar-nav > li.current-menu-ancestor > a, .navbar.shrink-nav > .nav-header-container .navbar-nav > li.current-menu-item > a, .navbar-default.shrink-nav .navbar-nav > li > a:hover, .navbar-default.shrink-nav .navbar-nav > li:hover > a, .navbar-default.shrink-nav .navbar-nav > li > a.active, .navbar-default.shrink-nav .navbar-nav > li.open > a, .navbar-default.shrink-nav .navbar-nav > li.open > a:hover, .navbar-default.shrink-nav .navbar-nav > li.open:hover > a' ),
            ),
            array(
                'id'       => 'scroll-menu-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Scroll Menu Text Color', 'H-Code' ),
                'output'   => array('color' =>'.navbar.shrink-nav .navbar-nav > li > a, .navbar.shrink-nav > .nav-header-container .search-cart-header .top-cart > a, .navbar.shrink-nav > .nav-header-container .search-cart-header #top-search > a, .navbar.shrink-nav-white.shrink-nav .navbar-nav > li > a, .navbar.shrink-nav-white.shrink-nav > .nav-header-container .search-cart-header .top-cart > a, .navbar.shrink-nav-white.shrink-nav > .nav-header-container .search-cart-header #top-search > a, .hamburger-menu3.full-width-pull-menu.navbar.shrink-nav .navbar-nav > li > a'),
            ),

            array(
                'id'       => 'scroll-menu-text-hover-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Scroll Menu Text Hover Color', 'H-Code' ),
                'output'   => array('color' => '.navbar.shrink-nav .navbar-nav > li:hover > a, .navbar.shrink-nav .navbar-nav > li > a.active, .navbar.shrink-nav .navbar-nav > li.open > a, .navbar.shrink-nav > .nav-header-container .navbar-nav > li.current-menu-ancestor > a, .navbar.shrink-nav > .nav-header-container .navbar-nav > li.current-menu-item > a, .navbar.shrink-nav > .nav-header-container .search-cart-header .top-cart:hover > a, .pull-menu.shrink-nav .navbar-nav li > a.active, .navbar.shrink-nav > .nav-header-container .search-cart-header #top-search:hover > a, .full-width-pull-menu.navbar.shrink-nav .navbar-nav li:hover > a, .full-width-pull-menu.navbar.shrink-nav .navbar-nav li > a.active, .hamburger-menu3.full-width-pull-menu.navbar.shrink-nav .navbar-nav > li.current-menu-ancestor > a, .hamburger-menu3.full-width-pull-menu.navbar.shrink-nav .navbar-nav > li:hover > a, .hamburger-menu3.full-width-pull-menu.navbar.shrink-nav .navbar-nav > li > a.active, .hamburger-menu3.full-width-pull-menu.navbar.shrink-nav .navbar-nav li.current-menu-item > a, .navbar.shrink-nav .navbar-nav > li:hover, .navbar.shrink-nav .navbar-nav > li.open, .navbar.shrink-nav .navbar-nav > li.current-menu-ancestor, .navbar.shrink-nav .navbar-nav > li.current-menu-item'),
            ),
            array(
                'id'       => 'submenu-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Submenu Text Color', 'H-Code' ),
                'output'   => array('color' => '.dropdown-menu li a, .dropdown-header, .full-width-pull-menu.navbar .navbar-nav li .sub-menu > li > a, .full-width-pull-menu.navbar .navbar-nav li .sub-menu li ul li > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li > .sub-menu > li > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu li ul li > a, .full-width-pull-menu.navbar .navbar-nav li .sub-menu li > a, .navbar > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children li > a, .navbar > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu li > a'),
            ),
            array(
                'id'       => 'submenu-text-hover-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Submenu Text Hover Color', 'H-Code' ),
                'output'   => array('color' => '.dropdown-menu li a:hover, .dropdown-menu li a:focus, .navbar .simple-dropdown > ul.dropdown-menu > li:hover > a, .navbar .simple-dropdown > ul.dropdown-menu > li.current-menu-ancestor > a, .navbar .simple-dropdown > ul.dropdown-menu > li.current-menu-item > a, .dropdown-menu li a.active, .navbar-nav li.current-menu-ancestor ul li.current-menu-item > a, .navbar .dropdown-menu .mega-sub-menu > li.current-menu-item > a > .menu-icon-left, .full-width-pull-menu.navbar .navbar-nav li .sub-menu > li:hover > a, .full-width-pull-menu.navbar .navbar-nav li .sub-menu li ul li:hover > a, .full-width-pull-menu.navbar .navbar-nav li .sub-menu > li.current-menu-ancestor > a, .full-width-pull-menu.navbar .navbar-nav li .sub-menu > li.current-menu-item > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li > .sub-menu > li:hover > a, .hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu li ul li.current-menu-item > a,.hamburger-menu3.full-width-pull-menu.navbar .navbar-nav li .sub-menu li ul li:hover > a, .full-width-pull-menu.navbar .navbar-nav li .sub-menu li:hover > a,.full-width-pull-menu.navbar .navbar-nav li .sub-menu  li:hover > a, .navbar > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children li:hover > a, .navbar > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu li:hover > a'),
            ),
            array(
                'id'       => 'submenu-separator-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Submenu Separator/Line Color', 'H-Code' ),
                'output'   => array('border-bottom-color' => '.dropdown-header, .navbar > .nav-header-container .navbar-nav > li.simple-dropdown > .dropdown-menu li a, .navbar > .nav-header-container .navbar-nav.default-menu-wrapper > li.page_item_has_children .children li > a, .navbar > .nav-header-container .navbar-nav.default-menu-wrapper > li.menu-item-has-children .sub-menu li > a'),
            ),
            array(
                'id'       => 'hamburger3-number-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Number Color For Hamburger 3', 'H-Code' ),
                'output'   => array('color' => '.hamburger-menu3.full-width-pull-menu-dark .menu-number'),
            ),
            array(
                'id'       => 'hamburger3-cart-search-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Cart / Search Color For Hamburger 2 / Hamburger 3', 'H-Code' ),
                'output'   => array('color' => '.navbar.hamburger-menu-with-search-and-cart > .nav-header-container .hcode-hamburger-menu .top-cart .shopping-cart, .navbar.hamburger-menu-with-search-and-cart > .nav-header-container .hcode-hamburger-menu .search-cart-header #top-search > a, .navbar.hamburger-menu-with-search-and-cart.shrink-nav > .nav-header-container .hcode-hamburger-menu .top-cart .shopping-cart, .navbar.hamburger-menu-with-search-and-cart.shrink-nav > .nav-header-container .hcode-hamburger-menu .search-cart-header #top-search > a, .navbar.hamburger-menu-with-search-and-cart.nav-dark > .nav-header-container .hcode-hamburger-menu .top-cart .shopping-cart, .navbar.hamburger-menu-with-search-and-cart.nav-dark > .nav-header-container .hcode-hamburger-menu .search-cart-header #top-search > a, .navbar.hamburger-menu-with-search-and-cart.nav-dark.shrink-nav > .nav-header-container .hcode-hamburger-menu .top-cart .shopping-cart, .navbar.hamburger-menu-with-search-and-cart.nav-dark.shrink-nav > .nav-header-container .hcode-hamburger-menu .search-cart-header #top-search > a'),
            ),
            array(
                'id'       => 'humburger-menu-close-button-color',
                'type'     => 'color',
                'title'    => __( 'Hamburger Menu Close Button Color', 'H-Code' ),
                'output'   => array('background' => '.hamburger-menu1 .close-button::before, .hamburger-menu1 .close-button::after,.full-width-pull-menu .close-button::before, .full-width-pull-menu .close-button::after,.hamburger-menu3.full-width-pull-menu-dark .close-button::before, .hamburger-menu3.full-width-pull-menu-dark .close-button::after'),
            ),
            array(
                'id'        => 'opt_accordion_end_menu_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
    
            /* Mobile Menu Color & Background Color */
                        
            array(
                'id'        => 'opt_accordion_begin_mobile_menu_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Mobile Menu Color', 'H-Code'),
                'subtitle'  => esc_html__('Set mobile menu color & background color', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'mobile-menu-bg-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000000"></div>'.__( 'Menu Background', 'H-Code' ),
                'default'  => '#000000',
                'output'   => array('background' => '.navbar .mobile-accordion-menu, .navbar > .nav-header-container .accordion-menu.mobile-accordion-menu .navbar-collapse'),
            ),
            array(
                'id'       => 'mobile-menu-icon-bg-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Icon Background', 'H-Code' ),
                'output' => array('background' => '.navbar-default .navbar-toggle, .menu-button'),
            ),
            array(
                'id'       => 'mobile-menu-icon-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Icon Color', 'H-Code' ),
                'output' => array('background' => '.navbar-default .navbar-toggle .icon-bar, .menu-button .icon-bar'),
            ),
            array(
                'id'       => 'mobile-menu-icon-border-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Icon Border Color', 'H-Code' ),
                'output' => array('border-color' => '.navbar-default .navbar-toggle, .navbar-default .menu-button-orange, .menu-button'),
            ),
            array(
                'id'       => 'mobile-menu-cart-count-bg-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Cart Count BG Color', 'H-Code' ),
                'output' => array('background-color' => '.search-cart-header .subtitle-mobile'),
            ),
            array(
                'id'       => 'mobile-menu-cart-count-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:transparent"></div>'.__( 'Menu Cart Count Text Color', 'H-Code' ),
                'output' => array('color' => '.search-cart-header .subtitle-mobile'),
            ),
            array(
                'id'        => 'opt_accordion_end_mobile_menu_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            /* Mini Header Color */
                        
            array(
                'id'        => 'opt_accordion_begin_mini_header_bg_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Mini Header Color', 'H-Code'),
                'subtitle'  => esc_html__('Set mini header color', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'mini-header-bg-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#000000"></div>'.__( 'Mini Header Background', 'H-Code' ),
                'default'  => '#000000',
                'output'   => array('background' => '.top-header-area'),
            ),
            array(
                'id'        => 'opt_accordion_end_mini_header_bg_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            /* Mini Cart Color */

            array(
                'id'        => 'opt_accordion_begin_mini_cart_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Mini Cart Color', 'H-Code'),
                'subtitle'  => esc_html__('Set color for Mini Cart', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'mini-cart-title-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'Title Color', 'H-Code' ),
                'output'   => array('.woocommerce-mini-cart__empty-message, .cart-content ul.cart-list a.mini-cart-title'),
            ),
            array(
                'id'       => 'mini-cart-close-icon-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'Close Icon Color', 'H-Code' ),
                'output'   => array('.cart-content ul.cart-list a.remove'),
            ), 
            array(
                'id'       => 'mini-cart-price-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'Price Text Color', 'H-Code' ),
                'output'   => array('.cart-content ul.cart-list li .quantity'),
            ),
            array(
                'id'       => 'mini-cart-edit-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'Edit Text Color', 'H-Code' ),
                'output'   => array('.cart-content ul.cart-list a.mini-cart-edit'),
            ),
            array(
                'id'       => 'mini-cart-subtotal-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'Subtotal Text Color', 'H-Code' ),
                'output'   => array('.cart-content .total'),
            ),
            array(
                'id'       => 'mini-cart-viwcart-btn-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'View Cart Text Color', 'H-Code' ),
                'output'   => array('.cart-content .buttons a.cart'),
            ),
            array(
                'id'       => 'mini-cart-viwcart-btn-bg-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'View Cart Background Color', 'H-Code' ),
                'output'   => array('background' => '.cart-content .buttons a.cart')
            ),
            array(
                'id'       => 'mini-cart-viwcart-text-hover-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'View Cart Hover Text Color', 'H-Code' ),
                'output'   => array('color' => '.cart-content .buttons a.cart:hover'),
            ),
            array(
                'id'       => 'mini-cart-viwcart-bg-hover-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'View Cart Hover Background Color', 'H-Code' ),
                'output'   => array('background' => '.cart-content .buttons a.cart:hover')
            ),
            array(
                'id'       => 'mini-cart-viwcart-border-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'View Cart Border Color', 'H-Code' ),
                'output'   => array('border-color' => '.cart-content .buttons a.cart')
            ),
            array(
                'id'       => 'mini-cart-checkout-btn-text-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'Checkout Text Color', 'H-Code' ),
                'output'   => array('.cart-content .buttons a.checkout'),
            ),
            array(
                'id'       => 'mini-cart-checkout-btn-bg-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'Checkout Background Color', 'H-Code' ),
                'output'   => array('background' => '.cart-content .buttons a.checkout')
            ),
            array(
                'id'       => 'mini-cart-checkout-text-hover-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'Checkout Hover Text Color', 'H-Code' ),
                'output'   => array('color' => '.cart-content .buttons a.checkout:hover'),
            ),
            array(
                'id'       => 'mini-cart-checkout-bg-hover-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'Checkout Hover Background Color', 'H-Code' ),
                'output'   => array('background' => '.cart-content .buttons a.checkout:hover')
            ),
            array(
                'id'       => 'mini-cart-checkout-border-color',
                'type'     => 'color',
                'title'    => '<div class="color-box" style="background-color:#FFF"></div>'.__( 'Checkout Border Color', 'H-Code' ),
                'output'   => array('border-color' => '.cart-content .buttons a.checkout')
            ),
            array(
                'id'        => 'opt_accordion_end_mini_cart_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            /* Portfolio Category Color */
                        
            array(
                'id'        => 'opt_accordion_begin_portfolio_category_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Portfolio Category / Archive Color', 'H-Code'),
                'subtitle'  => esc_html__('Set color for portfolio category, archive pages', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'portfolio-category-title-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Title Color', 'H-Code' ),
                'output' => array('color' => '.portfolio-archive-page .portfolio-archive-title a'),
            ),
            array(
                'id'       => 'portfolio-category-subtitle-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Subtitle Color', 'H-Code' ),
                'output' => array('color' => '.portfolio-archive-page .portfolio-archive-subtitle'),
            ),
            array(
                'id'       => 'portfolio-category-hover-bg-color',
                'type'     => 'color_rgba',
                'title'    => esc_html__( 'Hover Background Color', 'H-Code' ),
                'output' => array('background' => '.portfolio-archive-page figure:hover .gallery-img'),
            ),
            array(
                'id'        => 'opt_accordion_end_portfolio_category_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            array(
                'id'        => 'opt_accordion_begin_page_title_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Page Title Color', 'H-Code'),
                'subtitle'  => esc_html__('Set color for page title', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'     => 'hcode_bg_page_title_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Background', 'H-Code' ),
            ),
            array(
                'id'     => 'hcode_bg_page_title_opacity',
                'type'   => 'select',
                'title'  => esc_html__('Opacity', 'H-Code'),
                'options' => array(
                    '' => esc_html__('Select Opacity', 'H-Code'),
                    '0.1' => '0.1',
                    '0.2' => '0.2',
                    '0.3' => '0.3',
                    '0.4' => '0.4',
                    '0.5' => '0.5',
                    '0.6' => '0.6',
                    '0.7' => '0.7',
                    '0.8' => '0.8',
                    '0.9' => '0.9',
                    '1.0' => '1.0',
                ),
            ),
            array(
                'id'     => 'hcode_page_title_title_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Title Color', 'H-Code' ),
            ),
            array(
                'id'     => 'hcode_page_title_subtitle_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Subtitle Color', 'H-Code' ),
            ),
            array(
                'id'     => 'hcode_page_title_sep_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Separator Color', 'H-Code' ),
            ),
            array(
                'id'     => 'hcode_page_title_breadcrumb_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Breadcrumb Color', 'H-Code' ),
            ),
            array(
                'id'     => 'hcode_page_title_breadcrumb_hover_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Breadcrumb Hover Color', 'H-Code' ),
            ),
            array(
                'id'        => 'opt_accordion_end_page_title_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
            array(
                'id'        => 'opt_accordion_begin_sidebar_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Sidebar Color', 'H-Code'),
                'subtitle'  => esc_html__('Set color for sidebar', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'     => 'hcode_sidebar_title_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Title Color', 'H-Code' ),
                'output' => array( 'color' => '.sidebar .widget-title' ),
            ),
            array(
                'id'     => 'hcode_sidebar_separator_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Separator Color', 'H-Code' ),
                'output' => array( 'background-color' => '.sidebar .thin-separator-line' ),
            ),
            array(
                'id'     => 'hcode_sidebar_link_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Link Color', 'H-Code' ),
                'output' => array( 'color' => '.sidebar a' ),
            ),
            array(
                'id'     => 'hcode_sidebar_link_hover_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Link Hover Color', 'H-Code' ),
                'output' => array( 'color' => '.sidebar a:hover, .sidebar .widget-category-list a:hover' ),
            ),
            array(
                'id'     => 'hcode_sidebar_content_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Content Color', 'H-Code' ),
                'output' => array( 'color' => '.sidebar p, .sidebar .textwidget, .sidebar .widget-posts-details' ),
            ),
            array(
                'id'     => 'hcode_sidebar_category_tag_count_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Category, Archive Count / Active Color', 'H-Code' ),
                'output' => array( 'color' => '.sidebar .widget-category-list span, .sidebar ul li.current-cat a, .sidebar ul li.current-menu-item a' ),
            ),
            array(
                'id'        => 'opt_accordion_end_sidebar_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            /* Footer Wrapper Color */
                        
            array(
                'id'        => 'opt_accordion_begin_footer_wrapper_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Footer Wrapper Color', 'H-Code'),
                'subtitle'  => esc_html__('Set color for footer wrapper', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'portfolio-footer-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Background Color', 'H-Code' ),
                'output' => array('background-color' => '.hcode-footer-wrapper'),
            ),
            array(
                'id'       => 'hcode-footer-wrapper-icon-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Icon Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-wrapper i'),
            ),
            array(
                'id'       => 'hcode-footer-wrapper-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-wrapper h6'),
            ),
            array(
                'id'       => 'hcode-footer-wrapper-link-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Link Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-wrapper a'),
            ),
            array(
                'id'       => 'hcode-footer-wrapper-link-hover-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Link Hover Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-wrapper a:hover'),
            ),
            array(
                'id'        => 'opt_accordion_end_footer_wrapper_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            /* Footer Color */

            array(
                'id'        => 'opt_accordion_begin_footer_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Footer Color', 'H-Code'),
                'subtitle'  => esc_html__('Set color for footer', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'hcode-footer-bg-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Background Color', 'H-Code' ),
                'output' => array('background-color' => '.hcode-main-footer'),
            ),
            array(
                'id' => 'hcode_module_setting',
                'type' => 'info_title',
                'title' => esc_html__('Footer Middle', 'H-Code'),
            ),
            array(
                'id'       => 'portfolio-footer-middle-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Background Color', 'H-Code' ),
                'output' => array('background-color' => '.hcode-footer-middle'),
            ),
            array(
                'id'       => 'hcode-footer-middle-title-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Title Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-middle .footer-links > div > h5'),
            ),
            array(
                'id'       => 'hcode-footer-middle-text-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Text Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-middle'),
            ),
            array(
                'id'       => 'hcode-footer-middle-link-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Link Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-middle a'),
            ),
            array(
                'id'       => 'hcode-footer-middle-link-hover-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Link Hover Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-middle a:hover'),
            ),
            array(
                'id'       => 'hcode-footer-middle-menu-link-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Menu Link Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-middle .hcode-footer-menu a'),
            ),
            array(
                'id'       => 'hcode-footer-middle-menu-link-hover-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Menu Link Hover Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-middle .hcode-footer-menu a:hover'),
            ),
            array(
                'id'       => 'hcode-footer-middle-social-icon-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Social Icon Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-middle .footer-social a i'),
            ),
            array(
                'id'       => 'hcode-footer-middle-social-icon-hover-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Social Icon Hover Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-middle .footer-social a:hover i'),
            ),
            array(
                'id'       => 'hcode-footer-middle-border-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Border Color', 'H-Code' ),
                'output' => array('background-color' => '.hcode-footer-middle .wide-separator-line'),
            ),
            array(
                'id' => 'hcode_module_setting',
                'type' => 'info_custom',
                'title' => esc_html__('Footer Bottom', 'H-Code'),
            ),
            array(
                'id'       => 'portfolio-footer-bottom-color',
                'type'     => 'color',
                'title'    => esc_html__( 'Background Color', 'H-Code' ),
                'output' => array('background-color' => '.hcode-footer-bottom'),
            ),
            array(
                'id'     => 'portfolio-footer-bottom-text-color',
                'type'   => 'color',
                'title'  => esc_html__( 'Text Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-bottom .copyright'),
            ),
            array(
                'id'     => 'portfolio-footer-bottom-link-color',
                'type'   => 'color',
                'title'  => esc_html__( 'Link Color', 'H-Code' ),
                'output' => array('color' => '.hcode-footer-bottom a'),
            ),
            array(
                'id'     => 'portfolio-footer-bottom-link-hover-color',
                'type'   => 'color',
                'title'  => esc_html__( 'Link Hover Color', 'H-Code' ),
                'output' => array( 'color' => '.hcode-footer-bottom a:hover' ),
            ),
            array(
                'id'        => 'opt_accordion_end_footer_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            /* ScrollToTop Button Color */

            array(
                'id'        => 'opt_accordion_begin_scrolltotop_color',
                'type'      => 'accordion',
                'title'     => esc_html__('ScrollToTop Button Color', 'H-Code'),
                'subtitle'  => esc_html__('Set color for ScrollToTop button', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'     => 'footer-scrolltotop-background-color',
                'type'   => 'color',
                'title'  => esc_html__( 'Background Color', 'H-Code' ),
                'output' => array( 'background-color' => '.scrollToTop' ),
            ),
            array(
                'id'     => 'footer-scrolltotop-icon-color',
                'type'   => 'color',
                'title'  => esc_html__( 'Icon Color', 'H-Code' ),
                'output' => array( 'color' => '.scrollToTop i' ),
            ),
            array(
                'id'     => 'footer-scrolltotop-hover-background-color',
                'type'   => 'color',
                'title'  => esc_html__( 'Hover Background Color', 'H-Code' ),
                'output' => array( 'background-color' => '.scrollToTop:hover' ),
            ),
            array(
                'id'     => 'footer-scrolltotop-icon-hover-color',
                'type'   => 'color',
                'title'  => esc_html__( 'Icon Hover Color', 'H-Code' ),
                'output' => array( 'color' => '.scrollToTop:hover i' ),
            ),
            array(
                'id'        => 'opt_accordion_end_scrolltotop_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),

            // Password Protected File Settings
            array(
                'id'        => 'opt_accordion_begin_password_color',
                'type'      => 'accordion',
                'title'     => esc_html__('Password Protected Block Color', 'H-Code'),
                'subtitle'  => esc_html__('Set color for Password Protected file', 'H-Code'),
                'position'  => 'start',
            ),
            array(
                'id'       => 'text-password-protected',
                'type'     => 'color',
                'title'    => __( 'Password Protected Text', 'H-Code' ),
                'output' => array('.post-password-form'),
            ),
            array(
                'id'       => 'text-password-protected-button',
                'type'     => 'color',
                'title'    => __( 'Password Protected Button Text', 'H-Code' ),
                'output' => array('.post-password-form input[type=submit]'),
            ),
            array(
                'id'       => 'text-password-protected-button-hover',
                'type'     => 'color',
                'title'    => __( 'Password Protected Button Hover Text', 'H-Code' ),
                'output' => array('.post-password-form input[type=submit]:hover'),
            ),
            array(
                'id'       => 'text-password-protected-button-bg',
                'type'     => 'color',
                'title'    => __( 'Password Protected Button Background', 'H-Code' ),
                'output' => array( 'background' => '.post-password-form input[type=submit]'),
            ),
            array(
                'id'       => 'text-password-protected-button-hover-bg',
                'type'     => 'color',
                'title'    => __( 'Password Protected Button Hover Background', 'H-Code' ),
                'output' => array( 'background'=> '.post-password-form input[type=submit]:hover'),
            ),
            array(
                'id'       => 'text-password-protected-button-border',
                'type'     => 'color',
                'title'    => __( 'Password Protected Button Border', 'H-Code' ),
                'output' => array('border-color' => '.post-password-form input[type=submit]'),
            ),
            array(
                'id'        => 'opt_accordion_end_password_color',
                'type'      => 'accordion',
                'position'  => 'end'
            ),
    ),
);