<?php
/**
 * Adding all required options and files of redux.
 *
 * @package H-Code
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'ReduxFramework' ) && file_exists( dirname( __FILE__ ) . '/ReduxCore/framework.php' ) ) {
	require_once( dirname( __FILE__ ) . '/ReduxCore/framework.php' );
}

/**
 * Be sure to rename this function to something more unique.
 */
function removeDemoModeLink() {
	if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
		remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks' ), null, 2 );
	}
	if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
		remove_action( 'admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );
	}
}
add_action( 'init', 'removeDemoModeLink' );

if ( ! class_exists( 'Hcode_Theme_Framework_config' ) ) {

	class Hcode_Theme_Framework_config {

		public $args     = array();
		public $sections = array();
		public $theme;
		public $reduxframework;

		public function __construct() {

			if ( ! class_exists( 'ReduxFramework' ) ) {
				return;
			}

			// This is needed. Bah WordPress bugs.
			if (  true == Redux_Helpers::is_theme( __FILE__ ) ) {
				$this->initSettings();
			} else {
				add_action( 'plugins_loaded', array( $this, 'initSettings' ), 10 );
			}
		}

		public function initSettings() {

			// Just for demo purposes. Not needed per say.
			$this->theme = wp_get_theme();

			// Set the default arguments.
			$this->set_arguments();

			// Set a few help tabs so you can see how it's done
			//$this->setHelpTabs();

			// Create the sections and fields.
			$this->set_sections();

			if ( ! isset( $this->args['opt_name'] ) ) {
				return;
			}

			$this->reduxframework = new ReduxFramework( $this->sections, $this->args );
		}

		/**
		 * This is a test function that will let you see when the compiler hook occurs.
		 * It only runs if a field   set with compiler=>true is changed.
		 */
		function compiler_action( $options, $css, $changed_values ) {
			echo '<h1>The compiler hook has run!</h1>';
			echo "<pre>";
			print_r( $changed_values ); // Values that have changed since the last save.
			echo "</pre>";
		}

		/**
		 * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
		 * Simply include this function in the child themes functions.php file.
		 * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
		 * so you must use get_template_directory_uri() if you want to use any of the built in icons.
		 */
		function dynamic_section( $sections ) {
			$sections[] = array(
				'title'  => __( 'Section via hook', 'H-Code' ),
				'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'H-Code' ),
				'icon'   => 'el-icon-paper-clip',
				'fields' => array(), // Leave this as a blank section, no options just some intro text set above.
			);

			return $sections;
		}

		/**
		 * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
		 */
		function change_arguments( $args ) {
			return $args;
		}

		/**
		 * Filter hook for filtering the default value of any given field. Very useful in development mode.
		 */
		function change_defaults( $defaults ) {
			$defaults['str_replace'] = 'Testing filter hook!';
			return $defaults;
		}

		// Remove the demo link and the notice of integrated demo from the redux-framework plugin.
		function remove_demo() {

			// Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
			if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
				remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::instance(), 'plugin_metalinks' ), null, 2 );

				// Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
				remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
			}
		}

		public function set_sections() {

			/**
			 * Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples.
			 */
			// Background Patterns Reader
			$sample_patterns_path = Redux_Core::$dir . '../sample/patterns/';
			$sample_patterns_url  = Redux_Core::$url . '../sample/patterns/';
			$sample_patterns      = array();

			if ( is_dir( $sample_patterns_path ) ) :

				if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) :
					$sample_patterns = array();

					while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

						if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
							$name = explode( '.', $sample_patterns_file );
							$name = str_replace( '.' . end($name), '', $sample_patterns_file );
							$sample_patterns[]  = array( 'alt' => $name, 'img' => $sample_patterns_url . $sample_patterns_file );
						}
					}
				endif;
			endif;

			ob_start();

			$ct          = wp_get_theme();
			$this->theme = $ct;
			$item_name   = $this->theme->get( 'Name' );
			$tags        = $this->theme->Tags;
			$screenshot  = $this->theme->get_screenshot();
			$class       = $screenshot ? 'has-screenshot' : '';

			$customize_title = sprintf( __( 'Customize &#8220;%s&#8221;', 'H-Code' ), $this->theme->display( 'Name' ) );

			?>
			<div id="current-theme" class="<?php echo esc_attr($class); ?>">
			<?php if ( $screenshot ) : ?>
				<?php if ( current_user_can( 'edit_theme_options' ) ) : ?>
						<a href="<?php echo wp_customize_url(); ?>" class="load-customize hide-if-no-customize" title="<?php echo esc_attr( $customize_title ); ?>">
							<img src="<?php echo esc_url( $screenshot ); ?>" alt="<?php esc_attr_e( 'Current theme preview', 'H-Code' ); ?>" />
						</a>
				<?php endif; ?>
					<img class="hide-if-customize" src="<?php echo esc_url( $screenshot ); ?>" alt="<?php esc_attr_e( 'Current theme preview','H-Code' ); ?>" />
				<?php endif; ?>

				<h4><?php echo $this->theme->display( 'Name' ); ?></h4>

				<div>
					<ul class="theme-info">
						<li><?php printf(__( 'By %s', 'H-Code' ), $this->theme->display( 'Author' ) ); ?></li>
						<li><?php printf(__( 'Version %s', 'H-Code' ), $this->theme->display( 'Version' ) ); ?></li>
						<li><?php echo '<strong>' . __( 'Tags', 'H-Code' ) . ':</strong>'; ?><?php printf( $this->theme->display( 'Tags' ) ); ?></li>
					</ul>
					<p class="theme-description"><?php echo $this->theme->display( 'Description' ); ?></p>
			<?php
			if ( $this->theme->parent() ) {
				printf( '<p class="howto">' . __( 'This <a href="%1$s">child theme</a> requires its parent theme, %2$s.', 'H-Code' ) . '</p>', 'http://codex.wordpress.org/Child_Themes', $this->theme->parent()->display('Name') );
			}
			?>

				</div>
			</div>

			<?php
			$item_info = ob_get_contents();

			ob_end_clean();

			$sampleHTML = '';
			if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
				Redux_Functions::init_wp_filesystem();

				global $wp_filesystem;

				$sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
			}

			/*
			*  H-Code Options Tabs
			*/
			require HCODE_THEME_ADMIN . '/options/general.php';
			require HCODE_THEME_ADMIN . '/options/mini-header.php';
			require HCODE_THEME_ADMIN . '/options/header.php';
			require HCODE_THEME_ADMIN . '/options/menu.php';
			require HCODE_THEME_ADMIN . '/options/page-title.php';
			require HCODE_THEME_ADMIN . '/options/page-template.php';
			require HCODE_THEME_ADMIN . '/options/font-setting.php';
			require HCODE_THEME_ADMIN . '/options/color-setting.php';
			require HCODE_THEME_ADMIN . '/options/general_layout.php';
			if ( class_exists( 'WooCommerce' ) ) {
				require HCODE_THEME_ADMIN . '/options/social.php';
			} else {
				require HCODE_THEME_ADMIN . '/options/social_post.php';
			}
			if ( class_exists( 'WooCommerce' ) ) {
				require HCODE_THEME_ADMIN . '/options/woocommerce.php';
			}
			require HCODE_THEME_ADMIN . '/options/footer-wrapper.php';
			require HCODE_THEME_ADMIN . '/options/footer.php';
			require HCODE_THEME_ADMIN . '/options/performance.php';
			require HCODE_THEME_ADMIN . '/options/import-export.php';

			if ( file_exists( trailingslashit( dirname( __FILE__ ) ) . 'README.html' ) ) {
				$tabs['docs'] = array(
					'icon'    => 'el-icon-book',
					'title'   => __( 'Documentation', 'H-Code' ),
					'content' => nl2br( file_get_contents( trailingslashit( dirname( __FILE__ ) ) . 'README.html' ) ),
				);
			}
		}

		public function setHelpTabs() {

			// Custom page help tabs, displayed using the help API. Tabs are shown in order of definition.
			$this->args['help_tabs'][] = array(
				'id'      => 'redux-help-tab-1',
				'title'   => __( 'Theme Information 1', 'H-Code' ),
				'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'H-Code' ),
			);

			$this->args['help_tabs'][] = array(
				'id'      => 'redux-help-tab-2',
				'title'   => __( 'Theme Information 2', 'H-Code' ),
				'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'H-Code' ),
			);

			// Set the help sidebar.
			$this->args['help_sidebar'] = __('<p>This is the sidebar content, HTML is allowed.</p>', 'H-Code');
		}

		/**
		 * All the possible arguments for Redux.
		 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments.
		 */
		public function set_arguments() {

			$theme = wp_get_theme(); // For use with some settings. Not necessary.

			$this->args = array(
				'opt_name'           => 'hcode_theme_setting',
				'display_name'       => $theme->get( 'Name' ),
				'display_version'    => $theme->get( 'Version' ),
				'menu_type'          => 'submenu',
				'allow_sub_menu'     => false,
				'menu_title'         => __( 'Theme Settings', 'H-Code' ),
				'page_title'         => __( 'Theme Settings', 'H-Code' ),
				'google_api_key'     => 'AIzaSyBnxzHttO52IQDpDkbZNbT48HL3o8YNb-k',
				'global_variable'    => 'hcode_theme_settings',
				'dev_mode'           => false,
				'customizer'         => false,
				'page_priority'      => null,
				'page_parent'        => 'themes.php',
				'page_permissions'   => 'manage_options',
				'menu_icon'          => '',
				'last_tab'           => '',
				'page_icon'          => 'icon-themes',
				'page_slug'          => 'hcode_theme_settings',
				'save_defaults'      => true,
				'default_show'       => false,
				'default_mark'       => '',
				'transient_time'     => 60 * MINUTE_IN_SECONDS,
				'output'             => true,
				'output_tag'         => true,
				'database'           => '',
				'show_import_export' => false,
				'hide_reset'         => false,
				'system_info'        => false,
				'help_tabs'          => array(),
				'help_sidebar'       => '',
				'hints'              => array(
					'icon'          => 'icon-question-sign',
					'icon_position' => 'right',
					'icon_color'    => 'lightgray',
					'icon_size'     => 'normal',

					'tip_style' => array(
						'color'   => 'light',
						'shadow'  => true,
						'rounded' => false,
						'style'   => '',
					),
					'tip_position'      => array(
						'my' => 'top left',
						'at' => 'bottom right',
					),
					'tip_effect' => array(
						'show' => array(
							'effect'   => 'slide',
							'duration' => '500',
							'event'    => 'mouseover',
						),
						'hide' => array(
							'effect'   => 'slide',
							'duration' => '500',
							'event'    => 'click mouseleave',
						),
					),
				),
			);
			// Panel Intro text -> before the form.
			if ( ! isset( $this->args['global_variable'] ) || $this->args['global_variable'] !== false ) {
				if ( ! empty( $this->args['global_variable'] ) ) {
					$v = $this->args['global_variable'];
				} else {
					$v = str_replace( "-", "_", $this->args['opt_name'] );
				}
			}
		}

	}

	global $reduxconfig;
	$reduxconfig = new Hcode_Theme_Framework_config();
}
