<?php
/**
 * Shortcode For Team Member Slider
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Team Member Slider */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'hcode_team_slider_shortcode' ) ) {
	function hcode_team_slider_shortcode( $atts, $content = null ) {

		extract( shortcode_atts( array(
				'hcode_slider_premade_style' => 'default',
				'hcode_slider_preview_image' => '',
	        	'show_pagination' => '',
                'show_pagination_style' => '',
                'show_navigation' => '',
                'show_navigation_style' => '',
                'show_pagination_color_style' => '',
                'hcode_image_carousel_itemsdesktop' => '3',
                'hcode_image_carousel_itemstablet' => '3',
                'hcode_image_carousel_itemsmobile' => '1',
                'hcode_image_carousel_autoplay' => '',
                'hcode_slider_id' => '',
                'hcode_slider_class' => '',
                'show_cursor_color_style' => '',
                'stoponhover' => '',
                'slidespeed' => '3000',
	    ), $atts ) );

		$output = $slider_config = '';
		$hcode_slider_premade_style = ( $hcode_slider_premade_style ) ? $hcode_slider_premade_style : 'team-agency';
	    $navigation = ( $show_navigation_style ) ? hcode_owl_navigation_slider_classes( $show_navigation_style) : hcode_owl_navigation_slider_classes('default') ;
	    $pagination = hcode_owl_pagination_slider_classes($show_pagination_style);
	    $pagination_style = hcode_owl_pagination_color_classes($show_pagination_color_style);
	    $hcode_slider_id = ( $hcode_slider_id ) ? $hcode_slider_id : $hcode_slider_premade_style;
	    $hcode_slider_class  = ( $hcode_slider_class ) ? ' '.$hcode_slider_class : '';
	    $show_cursor_color_style = ( $show_cursor_color_style ) ? ' '.$show_cursor_color_style : ' cursor-black';

        global $hcode_team_slider_parent_type;
    	$hcode_team_slider_parent_type = $hcode_slider_premade_style;

        switch ($hcode_slider_premade_style) {

            case 'team-member-slider-1': // Owl Carousel Slider Style
                	
                	$output .= '<div id="'.$hcode_slider_id.'" class="owl-carousel owl-theme dark-pagination bottom-arrow-pagination'.$show_cursor_color_style.' main-slider '.$hcode_slider_class.'">';
                    	$output .= do_shortcode($content);
                    $output .= '</div>';

					$slider_config .= 'navigation: true, ';
					$slider_config .= 'slideSpeed: 300, ';
					$slider_config .= 'paginationSpeed: 400, ';
					$slider_config .= 'singleItem: true, ';
					$slider_config .= 'navigationText: ["<i class=\'fa fa-angle-left\'></i>", "<i class=\'fa fa-angle-right\'></i>"] ';

            break;
            case 'default': // Default Slider Style
                	
					$output .= '<div class="team-agency-owl position-relative">';
				        $output .= '<div class="container">';
				            $output .= '<div class="row">';
								$output .= '<div id="'.$hcode_slider_id.'" class="owl-carousel owl-theme team-agency '.$show_cursor_color_style.$pagination.$navigation.$pagination_style.$navigation.$hcode_slider_class.'">';
										$output .= do_shortcode($content);
								$output .= '</div>';
							$output .= '</div>';
						$output .= '</div>';
						if( $show_navigation == 1 ):
				            if($show_navigation_style == 1):
				                $output .= '<div class="feature_nav">';
				                    $output .= '<a class="prev left carousel-control"><img alt="" src="'.HCODE_THEME_IMAGES_URI.'/arrow-pre.png" width="96" height="96"></a>';
				                    $output .= '<a class="next right carousel-control"><img alt="" src="'.HCODE_THEME_IMAGES_URI.'/arrow-next.png" width="96" height="96"></a>';
				                $output .= '</div>';
				            else:
				                $output .= '<div class="feature_nav">';
				                    $output .= '<a class="prev left carousel-control"><img alt="" src="'.HCODE_THEME_IMAGES_URI.'/arrow-pre-white-bg.png" width="96" height="96"></a>';
				                    $output .= '<a class="next right carousel-control"><img alt="" src="'.HCODE_THEME_IMAGES_URI.'/arrow-next-white-bg.png" width="96" height="96"></a>';
				                $output .= '</div>';
				            endif;
				        endif;
				    $output .= '</div>';

					/* Add custom script Start*/
					$slidespeed = ( $slidespeed ) ? $slidespeed : '3000'; 
				    ( $show_pagination == 1 ) ? $slider_config .= 'pagination: true,' : $slider_config .= 'pagination: false,';
				    ( $hcode_image_carousel_autoplay == 1 ) ? $slider_config .= 'autoPlay: '.$slidespeed.',' : $slider_config .= 'autoPlay: false,';
			        ( $stoponhover == 1) ? $slider_config .= 'stopOnHover: true, ' : $slider_config .= 'stopOnHover: false, ';
				    ( $hcode_image_carousel_itemsdesktop ) ? $slider_config .= 'items: '.$hcode_image_carousel_itemsdesktop.',' : $slider_config .= 'items: 3,';
				    ( $hcode_image_carousel_itemsdesktop ) ? $slider_config .= 'itemsDesktop: [1200,'.$hcode_image_carousel_itemsdesktop.'],' : $slider_config .= 'itemsDesktop: [1200, 3],';
				    ( $hcode_image_carousel_itemstablet ) ? $slider_config .= 'itemsTablet: [991,'.$hcode_image_carousel_itemstablet.'],' : $slider_config .= 'itemsTablet: [991, 2],';
				    ( $hcode_image_carousel_itemsmobile ) ? $slider_config .= 'itemsMobile: [700,'.$hcode_image_carousel_itemsmobile.'],' : $slider_config .= 'itemsMobile: [700, 1],';

            break;
		}
			ob_start();?>
			<script type="text/javascript">
	            jQuery(document).ready(function () {
	                jQuery("<?php echo '#'.$hcode_slider_id;?>").owlCarousel({
	                    <?php echo $slider_config;?>
	                 });
	            });
	        </script>
			<?php 
			$script = ob_get_contents();
			ob_end_clean();
			$output .= $script;

		/* Add custom script End*/
	    return $output;
	}
}
add_shortcode('hcode_team_slider','hcode_team_slider_shortcode');

if ( ! function_exists( 'hcode_team_slide_content_shortcode' ) ) {
	function hcode_team_slide_content_shortcode( $atts, $content = null ) {

        global $hcode_team_slider_parent_type;

		extract( shortcode_atts( array(
				'id' => '',
	        	'class' => '',
	        	'hcode_team_member_image' => '',
	        	'hcode_team_member_title' => '',
	        	'hcode_team_member_designation' => '',
	        	'hcode_team_member_headline' => '',
	        	'hcode_team_member_separator' => '',
	        	'hcode_team_member_fb' => '',
	        	'hcode_team_member_fb_url' => '',
	        	'hcode_team_member_tw' => '',
	        	'hcode_team_member_tw_url' => '',
	        	'hcode_team_member_googleplus' => '',
	        	'hcode_team_member_googleplus_url' => '',
	        	'hcode_team_member_db' => '',
	        	'hcode_team_member_db_url' => '',
	        	'hcode_team_member_yt' => '',
	        	'hcode_team_member_yt_url' => '',
	        	'hcode_team_member_li' => '',
	        	'hcode_team_member_li_url' => '',
	        	'hcode_team_member_ig' => '',
	        	'hcode_team_member_ig_url' => '',
	        	'hcode_team_member_pi' => '',
	        	'hcode_team_member_pi_url' => '',
	        	'hcode_team_member_gh' => '',
	        	'hcode_team_member_gh_url' => '',
	        	'hcode_team_member_ws' => '',
	        	'hcode_team_member_ws_url' => '',
	        	'hcode_team_member_custom_link' => '',
	        	'hcode_column_animation_style' => '',
	        	'hcode_column_animation_duration' => '',
	        	'hcode_title_color' => '',
	        	'hcode_designation_color' => '',
	        	'hcode_team_designation_bg_color' => '',
	            'hcode_team_icon_color' => '',
	    ), $atts ) );

	    $id = ( $id ) ? ' id="'.$id.'"' : '';
		$class = ( $class ) ? ' '.$class : '';

		/* Image Alt, Title, Caption */
        $img_alt = hcode_option_image_alt($hcode_team_member_image);
        $img_title = hcode_option_image_title($hcode_team_member_image);
        $image_alt = ( isset($img_alt['alt']) && !empty($img_alt['alt']) ) ? 'alt="'.$img_alt['alt'].'"' : 'alt=""' ; 
        $image_title = ( isset($img_title['title']) && !empty($img_title['title']) ) ? 'title="'.$img_title['title'].'"' : '';
        
		$hcode_team_member_image = ( $hcode_team_member_image ) ? $hcode_team_member_image : '';
		$thumb = wp_get_attachment_image_src($hcode_team_member_image, 'full');
		$hcode_team_member_title = ( $hcode_team_member_title ) ? $hcode_team_member_title : '';
		$hcode_team_member_designation = ( $hcode_team_member_designation ) ? $hcode_team_member_designation : '';
		$hcode_team_member_separator = ( $hcode_team_member_separator ) ? $hcode_team_member_separator : '';
		$hcode_team_member_headline = ( $hcode_team_member_headline ) ? $hcode_team_member_headline : '';
		$hcode_team_member_fb = ( $hcode_team_member_fb ) ? $hcode_team_member_fb : '';
		$hcode_team_member_fb_url = ( $hcode_team_member_fb_url ) ? $hcode_team_member_fb_url : '#';
		$hcode_team_member_tw = ( $hcode_team_member_tw ) ? $hcode_team_member_tw : '';
		$hcode_team_member_tw_url = ( $hcode_team_member_tw_url ) ? $hcode_team_member_tw_url : '#';
		$hcode_team_member_googleplus = ( $hcode_team_member_googleplus ) ? $hcode_team_member_googleplus : '';
		$hcode_team_member_googleplus_url = ( $hcode_team_member_googleplus_url ) ? $hcode_team_member_googleplus_url : '#';
		$hcode_team_member_db = ( $hcode_team_member_db ) ? $hcode_team_member_db : '';
		$hcode_team_member_db_url = ( $hcode_team_member_db_url ) ? $hcode_team_member_db_url : '#';
		$hcode_team_member_yt = ( $hcode_team_member_yt ) ? $hcode_team_member_yt : '';
		$hcode_team_member_yt_url = ( $hcode_team_member_yt_url ) ? $hcode_team_member_yt_url : '#';
		$hcode_team_member_li = ( $hcode_team_member_li ) ? $hcode_team_member_li : '';
		$hcode_team_member_li_url = ( $hcode_team_member_li_url ) ? $hcode_team_member_li_url : '#';
		$hcode_team_member_ig = ( $hcode_team_member_ig ) ? $hcode_team_member_ig : '';
		$hcode_team_member_ig_url = ( $hcode_team_member_ig_url ) ? $hcode_team_member_ig_url : '#';
		$hcode_team_member_pi = ( $hcode_team_member_pi ) ? $hcode_team_member_pi : '';
		$hcode_team_member_pi_url = ( $hcode_team_member_pi_url ) ? $hcode_team_member_pi_url : '#';
		$hcode_team_member_gh = ( $hcode_team_member_gh ) ? $hcode_team_member_gh : '';
		$hcode_team_member_gh_url = ( $hcode_team_member_gh_url ) ? $hcode_team_member_gh_url : '#';
		$hcode_team_member_ws = ( $hcode_team_member_ws ) ? $hcode_team_member_ws : '';
		$hcode_team_member_ws_url = ( $hcode_team_member_ws_url ) ? $hcode_team_member_ws_url : '#';
		$hcode_team_member_custom_link = ( $hcode_team_member_custom_link ) ? $hcode_team_member_custom_link : '';
		$hcode_designation_color = ( $hcode_designation_color ) ? 'style="color: '.$hcode_designation_color.' !important;"' : '';
		$hcode_title_color = ( $hcode_title_color ) ? 'style="color: '.$hcode_title_color.' !important;"' : '';
		$hcode_team_designation_bg_color = ( $hcode_team_designation_bg_color ) ? 'style="background: '.$hcode_team_designation_bg_color.' !important;"' : '';
	    $hcode_team_icon_color = ( $hcode_team_icon_color ) ? 'style="color: '.$hcode_team_icon_color.' !important;"' : '';

		$target = 'target="_BLANK"';

		$hcode_column_animation_style = ( $hcode_column_animation_style ) ? ' wow '.$hcode_column_animation_style : '';
	    $hcode_column_animation_duration = ( $hcode_column_animation_duration ) ? ' data-wow-duration= '.$hcode_column_animation_duration.'ms' : '';

		$output = '';

        switch ($hcode_team_slider_parent_type) {

            case 'team-member-slider-1': // Owl Carousel Slider Style

                	$output .= '<div class="item'.$class.'"'.$id.' >
			                        <div class="col-lg-6 col-md-6 case-study-details bg-gray"> 
			                            <div class="col-lg-7 col-md-12 pull-right about-text position-relative xs-text-center">';
										if( $hcode_team_member_title ):
			                                $output .= '<p class="title-small text-uppercase letter-spacing-3 black-text font-weight-600" '.$hcode_title_color.'>'.$hcode_team_member_title.'</p>';
					                	endif;
										if( $hcode_team_member_designation ):
			                                $output .= '<p class="title-small text-uppercase letter-spacing-3 black-text font-weight-600" '.$hcode_designation_color.'>'.$hcode_team_member_designation.'</p>';
					                	endif;
						            	if( $content ):
						            		$output .= '<p class="width-100 xs-width-100">';
						                	$output .= do_shortcode( hcode_remove_wpautop( $content ) );
						                	$output .= '</p>';
						            	endif;

						            	$social_data = array();
						            	if( $hcode_team_member_fb ) {
						            	 	$social_data['fa-facebook'] = $hcode_team_member_fb_url;
						            	}
						            	if( $hcode_team_member_tw ) {
						            	 	$social_data['fa-twitter'] = $hcode_team_member_tw_url;
						            	}
						            	if( $hcode_team_member_googleplus ) {
						            	 	$social_data['fa-google-plus'] = $hcode_team_member_googleplus_url;
						            	}
						            	if( $hcode_team_member_db ) {
						            	 	$social_data['fa-dribbble'] = $hcode_team_member_db_url;
						            	}
						            	if( $hcode_team_member_yt ) {
						            	 	$social_data['fa-youtube'] = $hcode_team_member_yt_url;
						            	}
						            	if( $hcode_team_member_li ) {
						            	 	$social_data['fa-linkedin'] = $hcode_team_member_li_url;
						            	}
						            	if( $hcode_team_member_ig ) {
						            	 	$social_data['fa-instagram'] = $hcode_team_member_ig_url;
						            	}
						            	if( $hcode_team_member_pi ) {
						            	 	$social_data['fa-pinterest-p'] = $hcode_team_member_pi_url;
						            	}
						            	if( $hcode_team_member_gh ) {
						            	 	$social_data['fa-github'] = $hcode_team_member_gh_url;
						            	}
						            	if( $hcode_team_member_ws ) {
						            	 	$social_data['fa-external-link'] = $hcode_team_member_ws_url;
						            	}

						            	if( !empty( $social_data ) || !empty( $hcode_team_member_custom_link ) ) {
						            		$output .= '<div class="our-team-agency-social">';
						            			$count = count( $social_data );
						            			$i = 0;
						            			foreach ($social_data as $key => $value) {
						            				$i++;
						            				$output .= '<div>';
						            				$output .= '<a '.$target.' href="'.esc_url( $value ).'"><i class="fa '.$key.'" '.$hcode_team_icon_color.'></i></a>';
						            				if( $i != $count || !empty( $hcode_team_member_custom_link ) ) {
						            					$output .= '<span>/</span>';
						            				}
						            				$output .= '</div>';
						            			}
							                	if( !empty( $hcode_team_member_custom_link ) ) :
							                		$output .= nl2br( rawurldecode( base64_decode( strip_tags( $hcode_team_member_custom_link ) ) ) );
							                	endif;
						                    $output .= '</div>';
						            	}
			                $output .= '</div>
			                        </div>';
									if( $thumb[0] ):
						            	$output .= '<div class="col-lg-6 col-md-6 case-study-img cover-background" style="background-image:url('.$thumb[0].');"></div>';
						        	endif;
                    $output .= '</div>';
            break;
            case 'default': // Default Slider Style
                	
					$output .= '<div class="text-center team-member'.$class.$hcode_column_animation_style.'"'.$id.' '.$hcode_column_animation_duration.'>';
						if( $thumb[0] ):
			            	$output .= '<img '.$image_alt.$image_title.' src="'.$thumb[0].'" width="'.$thumb[1].'" height="'.$thumb[2].'">';
			        	endif;
						$output .= '<figure class="position-relative bg-white" '.$hcode_team_designation_bg_color.'>';
						if( $hcode_team_member_title ):
		                	$output .= '<span class="team-name text-uppercase black-text letter-spacing-2 display-block font-weight-600" '.$hcode_title_color.'>'.$hcode_team_member_title.'</span>';
		                endif;
		                if( $hcode_team_member_designation ):
		                	$output .= '<span class="team-post text-uppercase letter-spacing-2 display-block" '.$hcode_designation_color.'>'.$hcode_team_member_designation.'</span>';
		            	endif;
			                            
			                if( $hcode_team_member_fb || $hcode_team_member_tw || $hcode_team_member_googleplus
		                		|| $hcode_team_member_db || $hcode_team_member_yt || $hcode_team_member_li 
		                		|| $hcode_team_member_ig || $hcode_team_member_pi || $hcode_team_member_gh 
		                		|| $hcode_team_member_ws || !empty( $hcode_team_member_custom_link ) ):
			                    $output .= '<div class="person-social margin-five no-margin-bottom">';
			                		if( $hcode_team_member_fb ):
				                    	$output .= '<a '.$target.' href="'.esc_url( $hcode_team_member_fb_url ).'" class="black-text-link"><i class="fa fa-facebook" '.$hcode_team_icon_color.'></i></a>';
				                	endif;
				                	if( $hcode_team_member_tw ):
				                    	$output .= '<a '.$target.' href="'.esc_url( $hcode_team_member_tw_url ).'" class="black-text-link"><i class="fa fa-twitter" '.$hcode_team_icon_color.'></i></a>';
				                	endif;
				                	if( $hcode_team_member_googleplus ):
				                    	$output .= '<a '.$target.' href="'.esc_url( $hcode_team_member_googleplus_url ).'" class="black-text-link"><i class="fa fa-google-plus" '.$hcode_team_icon_color.'></i></a>';
				                	endif;
			                		if( $hcode_team_member_db ):
				                    	$output .= '<a '.$target.' href="'.esc_url( $hcode_team_member_db_url ).'" class="black-text-link"><i class="fa fa-dribbble" '.$hcode_team_icon_color.'></i></a>';
				                	endif;
			                		if( $hcode_team_member_yt ):
				                    	$output .= '<a '.$target.' href="'.esc_url( $hcode_team_member_yt_url ).'" class="black-text-link"><i class="fa fa-youtube" '.$hcode_team_icon_color.'></i></a>';
				                	endif;
			                		if( $hcode_team_member_li ):
				                    	$output .= '<a '.$target.' href="'.esc_url( $hcode_team_member_li_url ).'" class="black-text-link"><i class="fa fa-linkedin" '.$hcode_team_icon_color.'></i></a>';
				                	endif;
			                		if( $hcode_team_member_ig ):
				                    	$output .= '<a '.$target.' href="'.esc_url( $hcode_team_member_ig_url ).'" class="black-text-link"><i class="fa fa-instagram" '.$hcode_team_icon_color.'></i></a>';
				                	endif;
			                		if( $hcode_team_member_pi ):
				                    	$output .= '<a '.$target.' href="'.esc_url( $hcode_team_member_pi_url ).'" class="black-text-link"><i class="fa fa-pinterest-p" '.$hcode_team_icon_color.'></i></a>';
				                	endif;
			                		if( $hcode_team_member_gh ):
				                    	$output .= '<a '.$target.' href="'.esc_url( $hcode_team_member_gh_url ).'" class="black-text-link"><i class="fa fa-github" '.$hcode_team_icon_color.'></i></a>';
				                	endif;
			                		if( $hcode_team_member_ws ):
				                    	$output .= '<a '.$target.' href="'.esc_url( $hcode_team_member_ws_url ).'" class="black-text-link" '.$hcode_team_icon_color.'><i class="fa fa-external-link"></i></a>';
				                	endif;
				                	if( !empty( $hcode_team_member_custom_link ) ) :
				                		$output .= nl2br( rawurldecode( base64_decode( strip_tags( $hcode_team_member_custom_link ) ) ) );
				                	endif;
			                    $output .= '</div>';
			                endif;
			            $output .= '</figure>';
			            $output .= '<div class="team-details bg-blck-overlay">';
			            	if( $hcode_team_member_headline ):
			            		$output .= '<h5 class="team-headline white-text text-uppercase font-weight-600">'.$hcode_team_member_headline.'</h5>';
			            	endif;
			            	if( $content ):
			                	$output .= do_shortcode( hcode_remove_wpautop( $content ) );
			            	endif;
			                if( $hcode_team_member_separator ):
			                	$output .= '<div class="separator-line-thick bg-white"></div>';
			               	endif;
			            $output .= '</div>';
			        $output .= '</div>';
            break;
		}

		return $output;
	}
}
add_shortcode('hcode_team_slide_content','hcode_team_slide_content_shortcode');
?>