<?php
/**
 * Shortcode For Portfolio Filter
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Portfolio Filter */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'hcode_portfolio_filter_shortcode' ) ) {
    function hcode_portfolio_filter_shortcode( $atts, $content = null ) {
        extract( shortcode_atts( array(
            'id' => '',
            'class' => '',
            'hcode_portfolio_filter_style' => '',
            'hcode_categories_list' => '',
            'hcode_show_all_categories_filter' => '1',
            'hcode_default_category_selected' => '',
            'hcode_portfolio_categories_orderby' => 'id',
            'hcode_portfolio_categories_order' => 'ASC',
            'hcode_filter_color' => '',
            'hcode_filter_custom_color' => '',
            'hcode_animation_style' => '',
        ), $atts ) );

        $output = $filter_class = $filter_class_style = $filterStyle = '';
        $id = ( $id ) ? ' id="'.$id.'"' : '';
        $class = ( $class ) ? ' class="'.$class.'"' : '';
        $hcode_portfolio_filter_style = ( $hcode_portfolio_filter_style ) ? $hcode_portfolio_filter_style : '';
        $hcode_show_all_categories_filter = ( $hcode_show_all_categories_filter ) ? $hcode_show_all_categories_filter : '';
        $hcode_default_category_selected = ( $hcode_default_category_selected ) ? $hcode_default_category_selected : '';
        $hcode_portfolio_categories_orderby = ( $hcode_portfolio_categories_orderby ) ? $hcode_portfolio_categories_orderby : '';
        $hcode_portfolio_categories_order = ( $hcode_portfolio_categories_order ) ? $hcode_portfolio_categories_order : '';
        $hcode_filter_color = ( $hcode_filter_color ) ? $hcode_filter_color : '';
        $hcode_filter_custom_color = ( $hcode_filter_custom_color ) ? $hcode_filter_custom_color : '';
        $hcode_animation_style = ( $hcode_animation_style ) ? ' wow '.$hcode_animation_style : '';

        switch( $hcode_portfolio_filter_style ) {
            case 'filter-style-2':
                $filterStyle = ' nav-tabs-style2';
            break;
            
            default:
                $filterStyle = ' nav-tabs-style1';
            break;
        }

        switch( $hcode_filter_color ) {
            case 'nav-tabs-black':
            case 'nav-tabs-gray':
                $filter_class = ( $hcode_filter_color ) ? ' '.$hcode_filter_color : '';
            break;

            case 'custom':
                $filter_class_style .= 'style="color:'.$hcode_filter_custom_color.'"';
            break;
        }

        $categories_to_display_ids = explode(",",$hcode_categories_list);
        if ( is_array( $categories_to_display_ids ) && $categories_to_display_ids[0] == '0' ) {
            unset( $categories_to_display_ids[0] );
            $categories_to_display_ids = array_values( $categories_to_display_ids );
        }
        // If no categories are chosen or "All categories", we need to load all available categories
        if ( ! is_array( $categories_to_display_ids ) || count( $categories_to_display_ids ) == 0 ) {
            $terms = get_terms( 'portfolio-category' );
            
            if ( ! is_array( $categories_to_display_ids ) ) {
                $categories_to_display_ids = array();
            }
            foreach ( $terms as $term ) {
                $categories_to_display_ids[] = $term->slug;
            }
        }
        
        if( $id || $class ) :
            $output .='<div'.$id.$class.'">';
        endif;

        $output .='<ul class="portfolio-filter nav nav-tabs'.$filterStyle.$filter_class.$hcode_animation_style.'">';
            if($hcode_show_all_categories_filter == 1):
                $active_class = empty( $hcode_default_category_selected ) ? ' active ' : '';
                $output .= '<li class="nav '.$active_class.'"><a href="#" '.$filter_class_style.' data-filter="*">'.__( 'All', 'hcode-addons' ).'</a></li>';
            endif;
            $taxonomy = 'portfolio-category';
            $args = array(
                'orderby' => $hcode_portfolio_categories_orderby,
                'order' => $hcode_portfolio_categories_order,
                'hide_empty' => 0, 
                'slug' => $categories_to_display_ids,
            );
            
            $tax_terms = get_terms($taxonomy, $args);
            foreach ($tax_terms as $tax_term) {
                $active_class = ( $hcode_default_category_selected == $tax_term->slug ) ? ' active ' : '';
                $output .='<li class="nav '.$active_class.'">
                            <a href="#" '.$filter_class_style.' data-filter=".portfolio-filter-'.$tax_term->term_id.'">'.$tax_term->name.'</a>
                        </li>';
            }
        $output .='</ul>';
        
        if( $id || $class ) :
            $output .='</div>';
        endif;

        return $output;
    }
}
add_shortcode( 'hcode_portfolio_filter', 'hcode_portfolio_filter_shortcode' );