<?php
/**
 * Shortcode For Parallax
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Parallax */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'hcode_parallax_shortcode' ) ) {
    function hcode_parallax_shortcode( $atts, $content = null ) {
        extract( shortcode_atts( array(
            'id' => '',
            'class' => '',
            'hcode_parallax_style' => '',
            'hcode_show_button' => '1',
            'hcode_button_link' => '',
            'hcode_seperater' => '',
            'hcode_animation_style' => '',
            'hcode_categories_list' => '',
            'hcode_post_per_page' => '10',
            'hcode_show_excerpt' => '',
            'hcode_excerpt_length' => '15',
            'padding_setting' => '',
            'desktop_padding' => '',
            'custom_desktop_padding' => '',
            'ipad_padding' => '',
            'mobile_padding' => '',
            'margin_setting' => '',
            'desktop_margin' => '',
            'custom_desktop_margin' => '',
            'ipad_margin' => '',
            'mobile_margin' => '',
            'orderby' => '',
            'order' => '',
        ), $atts ) );
        $output = $padding = $padding_style = $margin = $margin_style = $style_attr = $style = '';
        $id = ( $id ) ? ' id="'.$id.'"' : '';
        $class = ( $class ) ? ' '.$class : '';
        $orderby = ( $orderby ) ? $orderby : '';
        $order = ( $order ) ? $order : '';
        // For Button
        $first_button_parse_args = vc_parse_multi_attribute($hcode_button_link);
        $first_button_link     = ( isset($first_button_parse_args['url']) ) ? $first_button_parse_args['url'] : '#';
        $first_button_title    = ( isset($first_button_parse_args['title']) ) ? $first_button_parse_args['title'] : '';
        $hcode_animation_style = ( $hcode_animation_style ) ? ' wow '.$hcode_animation_style : '';

        // Column Padding settings
        $padding_setting = ( $padding_setting ) ? $padding_setting : '';
        $desktop_padding = ( $desktop_padding ) ? ' '.$desktop_padding : '';
        $ipad_padding = ( $ipad_padding ) ? ' '.$ipad_padding : '';
        $mobile_padding = ( $mobile_padding ) ? ' '.$mobile_padding : '';
        $custom_desktop_padding = ( $custom_desktop_padding ) ? $custom_desktop_padding : '';
        if($desktop_padding == ' custom-desktop-padding' && $custom_desktop_padding){
            $padding_style .= " padding: ".$custom_desktop_padding.";";
        }else{
            $padding .= $desktop_padding;
        }
        $padding .= $ipad_padding.$mobile_padding;

        // Column Margin settings
        $margin_setting = ( $margin_setting ) ? $margin_setting : '';
        $desktop_margin = ( $desktop_margin ) ? ' '.$desktop_margin : '';
        $ipad_margin = ( $ipad_margin ) ? ' '.$ipad_margin : '';
        $mobile_margin = ( $mobile_margin ) ? ' '.$mobile_margin : '';
        $custom_desktop_margin = ( $custom_desktop_margin ) ? $custom_desktop_margin : '';
        if($desktop_margin == ' custom-desktop-margin' && $custom_desktop_margin){
            $margin_style .= " margin: ".$custom_desktop_margin.";";
        }else{
            $margin .= $desktop_margin;
        }
        $margin .= $ipad_margin.$mobile_margin;

        // Padding and Margin Style Combine
        if($padding_style){
            $style_attr .= $padding_style;
        }
        if($margin_style){
            $style_attr .= $margin_style;
        }

        if($style_attr){
            $style .= ' style="'.$style_attr.'"';
        }
        $categories_to_display_ids = explode(",",$hcode_categories_list);
        if ( is_array( $categories_to_display_ids ) && $categories_to_display_ids[0] == '0' ) {
            unset( $categories_to_display_ids[0] );
            $categories_to_display_ids = array_values( $categories_to_display_ids );
        }
        // If no categories are chosen or "All categories", we need to load all available categories
        if ( ! is_array( $categories_to_display_ids ) || count( $categories_to_display_ids ) == 0 ) {
            $terms = get_terms( 'portfolio-category' );

            if ( ! is_array( $categories_to_display_ids ) ) {
                $categories_to_display_ids = array();
            }

            foreach ( $terms as $term ) {
                $categories_to_display_ids[] = $term->slug;
            }
        }
        if ( get_query_var('paged') ) { $paged = get_query_var('paged'); } else if ( get_query_var('page') ) {$paged = get_query_var('page'); } else {$paged = 1; }
        $args = array(
            'post_type' => 'portfolio',
            'posts_per_page' => $hcode_post_per_page,
            'tax_query' => array(
                array(
                    'taxonomy' => 'portfolio-category',
                    'field' => 'slug',
                    'terms' => $categories_to_display_ids
               ),
            ),
            'orderby' => $orderby,
            'order' => $order,
            'paged' => $paged,
        );
        $portfolio_posts = new WP_Query( $args );
        while ( $portfolio_posts->have_posts() ) : $portfolio_posts->the_post();
            $title = get_the_title();
            $portfolio_permalink = get_permalink();
            $thumb = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );
            $url = $thumb['0'];
            $show_excerpt = ( $hcode_show_excerpt == 1 ) ? hcode_get_the_excerpt_theme($hcode_excerpt_length) : hcode_get_the_excerpt_theme(55);
            if($url):
                $parallax = ' style="background-image: url('.$url.')"';
            endif;
            $portfolio_subtitle = hcode_post_meta('hcode_subtitle');
            $portfoliowithdesc_class = '';

            $portfolio_image = hcode_post_meta('hcode_image');;
            $portfolio_gallery = hcode_post_meta('hcode_gallery');
            $portfolio_link = hcode_post_meta('hcode_link_type');
            $portfolio_video = hcode_post_meta('hcode_video');
            $portfolio_subtitle = hcode_post_meta('hcode_subtitle');
            $hcode_portfolio_post_type = hcode_post_meta( 'hcode_portfolio_post_type' );

            /* Image Alt, Title, Caption */
            $img_alt = hcode_option_image_alt(get_post_thumbnail_id());
            $img_title = hcode_option_image_title(get_post_thumbnail_id());
            $img_lightbox_caption = hcode_option_image_caption(get_post_thumbnail_id());
            $img_lightbox_title = hcode_option_lightbox_image_title(get_post_thumbnail_id());
            $image_alt = ( isset($img_alt['alt']) && !empty($img_alt['alt']) ) ? 'alt="'.$img_alt['alt'].'"' : 'alt=""' ; 
            $image_title = ( isset($img_title['title']) && !empty($img_title['title']) ) ? ' title="'.$img_title['title'].'"' : '';
            $image_lightbox_caption = ( isset($img_lightbox_caption['caption']) && !empty($img_lightbox_caption['caption']) ) ? ' lightbox_caption="'.$img_lightbox_caption['caption'].'"' : '' ;
            $image_lightbox_title = ( isset($img_lightbox_title['title']) && !empty($img_lightbox_title['title']) ) ? ' title="'.$img_lightbox_title['title'].'"' : '' ;
            $popup_id = 'portfolio-'.get_the_ID();

            $post_format = $button = '';
            if(!empty($portfolio_gallery) || ( $hcode_portfolio_post_type != "" && $hcode_portfolio_post_type == "gallery" ) ){

                $portfolio_gallery = hcode_post_meta('hcode_gallery');
                $gallery = explode(",",$portfolio_gallery);
                $i=1;
                if(is_array($gallery)):
                    foreach ($gallery as $k => $value) {

                        /* Image Alt, Title, Caption */
                        $img_alt_gallery = hcode_option_image_alt($value);
                        $img_title_gallery = hcode_option_image_title($value);
                        $img_lightbox_caption_gallery = hcode_option_image_caption($value);
                        $img_lightbox_title_gallery = hcode_option_lightbox_image_title($value);
                        $image_alt_gallery = ( isset($img_alt_gallery['alt']) && !empty($img_alt_gallery['alt']) ) ? 'alt="'.$img_alt_gallery['alt'].'"' : 'alt=""' ; 
                        $image_title_gallery = ( isset($img_title_gallery['title']) && !empty($img_title_gallery['title']) ) ? ' title="'.$img_title_gallery['title'].'"' : '';
                        $image_lightbox_caption_gallery = ( isset($img_lightbox_caption_gallery['caption']) && !empty($img_lightbox_caption_gallery['caption']) ) ? ' lightbox_caption="'.$img_lightbox_caption_gallery['caption'].'"' : '' ;
                        $image_lightbox_title_gallery = ( isset($img_lightbox_title_gallery['title']) && !empty($img_lightbox_title_gallery['title']) ) ? ' title="'.$img_lightbox_title_gallery['title'].'"' : '' ; 

                        $thumb_gallery = wp_get_attachment_image_src( $value, 'full' );
                        if($i == 1){
                            $thumb = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );
                            $url = $thumb['0'];
                                if($url){
                                    if($hcode_parallax_style == 'parallax'){
                                        if($hcode_show_button && $first_button_title){
                                            $button .='<div class="look-project parallax-parent-gallery-popup wow fadeInUp"><a '.$image_lightbox_title.$image_lightbox_caption.' href="javascript:void(0);" class="text-uppercase">'.$first_button_title.'</a></div>';
                                        }
                                        $post_format .='<a '.$image_lightbox_title.$image_lightbox_caption.' href="'.$url.'" class="lightboxgalleryitem" data-group="'.$popup_id.'">';
                                        
                                        $post_format .= '<div class="opacity-light bg-slider"></div>';
                                        $post_format .= '</a>';
                                        if( $thumb_gallery[0] ) {
                                            $post_format .= '<a href="'.$thumb_gallery[0].'" '.$image_lightbox_title_gallery.$image_lightbox_caption_gallery.' class="lightboxgalleryitem" data-group="'.$popup_id.'"></a>';
                                        }
                                    }elseif($hcode_parallax_style == 'portfolio-with-desc'){
                                        if($hcode_show_button && $first_button_title){
                                            $button .='<a href="javascript:void(0);" class="btn-small-white-background btn margin-ten no-margin-bottom parallax-parent-gallery-popup">'.$first_button_title.'</a>';
                                        }
                                        $post_format .='<a '.$image_lightbox_title.$image_lightbox_caption.' href="'.$url.'" class="lightboxgalleryitem" data-group="'.$popup_id.'"><h3 class="white-text">'.$title.'</h3></a>';
                                        
                                        if( $thumb_gallery[0] ) {
                                            $post_format .= '<a href="'.$thumb_gallery[0].'" '.$image_lightbox_title_gallery.$image_lightbox_caption_gallery.' class="lightboxgalleryitem" data-group="'.$popup_id.'"></a>';
                                        }
                                    }
                                }else{
                                    if( $thumb_gallery[0] ) {
                                        $post_format .= '<a href="'.$thumb_gallery[0].'" '.$image_lightbox_title_gallery.$image_lightbox_caption_gallery.' class="lightboxgalleryitem" data-group="'.$popup_id.'">';
                                            $post_format .= wp_get_attachment_image( get_post_thumbnail_id($value), "full", array( $image_alt_gallery,$image_title_gallery ) );
                                        $post_format .= '</a>';
                                    }
                                }
                        }else {
                            if( $thumb_gallery[0] ) {
                                $post_format .= '<a href="'.$thumb_gallery[0].'" '.$image_lightbox_title_gallery.$image_lightbox_caption_gallery.' class="lightboxgalleryitem" data-group="'.$popup_id.'"></a>';
                            }
                        }
                        $i++;
                    }
                endif;

            }elseif(!empty($portfolio_video) || ( $hcode_portfolio_post_type != "" && $hcode_portfolio_post_type == "video" )){

                $video_url = hcode_post_meta('hcode_video');
                if($hcode_show_button && $first_button_title){
                    if($hcode_parallax_style == 'parallax'){
                        $button .='<div class="look-project wow fadeInUp"><a href="'.$video_url.'" class="text-uppercase popup-vimeo">'.$first_button_title.'</a></div>';
                        $post_format .= '<a href="'.$video_url.'" class="text-uppercase popup-vimeo"><div class="opacity-light bg-slider"></div></a>';
                    }elseif($hcode_parallax_style == 'portfolio-with-desc'){
                        $button .='<a href="'.$video_url.'" class="btn-small-white-background btn margin-ten no-margin-bottom popup-vimeo">'.$first_button_title.'</a>';
                        if($title):
                            $post_format .='<a href="'.$video_url.'" class="popup-vimeo"><h3 class="white-text">'.$title.'</h3></a>';
                        endif;
                    }
                }else{
                    if($hcode_parallax_style == 'parallax'){
                        $post_format .= '<a href="'.$video_url.'" class="text-uppercase popup-vimeo"><div class="opacity-light bg-slider"></div></a>';
                    }elseif($hcode_parallax_style == 'portfolio-with-desc'){
                        if($title):
                            $post_format .='<a href="'.$video_url.'" class="popup-vimeo"><h3 class="white-text">'.$title.'</h3></a>';
                        endif;
                    }
                }

            }elseif(!empty($portfolio_link) || ( $hcode_portfolio_post_type != "" && $hcode_portfolio_post_type == "link" )){

                $link_url = hcode_post_meta('hcode_link');
                $link_type = hcode_post_meta('hcode_link_type');
                $hcode_link_target = hcode_post_meta('hcode_link_target');
                $ajax_popup_class = $link = $icon = $link_target = '';
                switch ($link_type) {
                    case 'external':
                        $ajax_popup_class .= '';
                        $link .= $link_url;
                        $link_target .= ' target="'.$hcode_link_target.'"';
                        break;

                    case 'ajax-popup':
                        $ajax_popup_class .= ' simple-ajax-popup-align-top';
                        $link .= $link_url;
                        break;
                }
                if($hcode_show_button && $first_button_title){
                    if($hcode_parallax_style == 'parallax'){
                        $button .='<div class="look-project wow fadeInUp"><a href="'.$link.'" class="text-uppercase'.$ajax_popup_class.'"'.$link_target.'>'.$first_button_title.'</a></div>';
                        $post_format .='<a href="'.$link.'" class="text-uppercase'.$ajax_popup_class.'"'.$link_target.'><div class="opacity-light bg-slider"></div></a>';
                    }elseif($hcode_parallax_style == 'portfolio-with-desc'){
                        $button .='<a href="'.$link.'" class="btn-small-white-background btn margin-ten no-margin-bottom'.$ajax_popup_class.'"'.$link_target.'>'.$first_button_title.'</a>';
                        if($title):
                            $post_format .='<a href="'.$link.'" class="text-uppercase'.$ajax_popup_class.'"'.$link_target.'><h3 class="white-text">'.$title.'</h3></a>';
                        endif;
                    }
                }else{
                    if($hcode_parallax_style == 'parallax'){
                        $post_format .='<a href="'.$link.'" class="text-uppercase'.$ajax_popup_class.'"'.$link_target.'><div class="opacity-light bg-slider"></div></a>';
                    }elseif($hcode_parallax_style == 'portfolio-with-desc'){
                        if($title):
                            $post_format .='<a href="'.$link.'" class="text-uppercase'.$ajax_popup_class.'"'.$link_target.'><h3 class="white-text">'.$title.'</h3></a>';
                        endif;
                    }
                }
                
            } else {

                if($hcode_show_button && $first_button_title){
                    if($hcode_parallax_style == 'parallax'){
                        $button .='<div class="look-project wow fadeInUp"><a href="'.$portfolio_permalink.'" class="text-uppercase">'.$first_button_title.'</a></div>';
                        $post_format .='<a href="'.$portfolio_permalink.'" class="text-uppercase"><div class="opacity-light bg-slider"></div></a>';
                    }elseif($hcode_parallax_style == 'portfolio-with-desc'){
                        $button .='<a href="'.$portfolio_permalink.'" class="btn-small-white-background btn margin-ten no-margin-bottom">'.$first_button_title.'</a>';
                        if($title):
                            $post_format .='<a href="'.$portfolio_permalink.'"><h3 class="white-text">'.$title.'</h3></a>';
                        endif;
                    }
                }else{
                    if($hcode_parallax_style == 'parallax'){
                        $post_format .='<a href="'.$portfolio_permalink.'" class="text-uppercase"><div class="opacity-light bg-slider"></div></a>';
                    }elseif($hcode_parallax_style == 'portfolio-with-desc'){
                        if($title):
                            $post_format .='<a href="'.$portfolio_permalink.'"><h3 class="white-text">'.$title.'</h3></a>';
                        endif;
                    }
                }
            }

            switch ($hcode_parallax_style) {
                case 'parallax':
                        $output .='<div '.$id.' class="parallax-portfolio parallax-portfolio-gallery-parent" '.$class.$parallax.'>';
                            $output .= $post_format;
                            $output .='<figure>';
                                $output .='<figcaption class="bg-black">';
                                    if($title):
                                        $output .='<h3>'.$title.'</h3>';
                                    endif;
                                    $output .='<p>'.$portfolio_subtitle.'</p>';
                                $output .='</figcaption>';
                                $output .= $button;
                            $output .='</figure>';
                        $output .='</div>';
                break;

                case 'portfolio-with-desc':
                    $portfoliowithdesc_class = ' no-padding-top';
                    $output .='<div '.$id.' class="portfolio-short-description parallax-portfolio-gallery-parent col-md-12 col-sm-12 col-xs-12 '.$class.$padding.$margin.'" '.$style.'>';
                        $output .='<div class="portfolio-short-description-bg pull-left" '.$parallax.'>';
                            $output .='<figure class="pull-right '.$hcode_animation_style.'">';
                                $output .='<figcaption>';
                                if($hcode_seperater == '1'){
                                    $output .='<div class="separator-line bg-yellow no-margin-lr margin-ten no-margin-top"></div>';
                                }
                                    
                                    $output .= $post_format;                                    
                                    $output .= '<p class="light-gray-text margin-seven">'.$show_excerpt.'</p>';
                                    $output .= $button;
                                $output .='</figcaption>';
                            $output .='</figure>';
                        $output .='</div>';
                    $output .='</div>';
                break;
            }
        endwhile;
        wp_reset_postdata();
            
        // Pagination
        if($portfolio_posts->max_num_pages > 1):
            if( $portfolio_posts->query_vars['paged'] > 1 ) {
                $current = $portfolio_posts->query_vars['paged'];
            } else {
                $current = 1;
            }
            $output .='<section class="clear-both'.$portfoliowithdesc_class.'">';
                $output .='<div class="container">';
                    $output .='<div class="row">';
                        $output .='<div class="col-md-12 col-sm-12 col-xs-12 wow fadeInUp">';
                            $output .='<div class="pagination margin-top-20px">';
                                $output .= paginate_links( array(
                                    'base'         => esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
                                    'format'       => '',
                                    'add_args'     => '',
                                    'current'      => $current,
                                    'total'        => $portfolio_posts->max_num_pages,
                                    'prev_text'    => '<img alt="Previous" src="'.HCODE_THEME_IMAGES_URI.'/arrow-pre-small.png" width="20" height="13">',
                                    'next_text'    => '<img alt="Next" src="'.HCODE_THEME_IMAGES_URI.'/arrow-next-small.png" width="20" height="13">',
                                    'type'         => 'plain',
                                    'end_size'     => 2,
                                    'mid_size'     => 2
                                ) );
                            $output .='</div>';
                        $output .='</div>';
                    $output .='</div>';
                $output .='</div>';
            $output .='</section>';
        endif;
    return $output;
    }
}
add_shortcode( 'hcode_parallax', 'hcode_parallax_shortcode' );