<?php
/**
 * Map For Tab Content
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Tab Content */
/*-----------------------------------------------------------------------------------*/

vc_map( array(
    'name' => __('Tab Content Block', 'hcode-addons'),
    'description' => __( 'Create a tab content block', 'hcode-addons' ),    
    'icon' => 'fa fa-list-alt h-code-shortcode-icon',
    'base' => 'hcode_tab_content',
    'category' => 'H-Code',
    'params' => array(
      array(
        'type' => 'dropdown',
        'heading' => __('Tab Content Style', 'hcode-addons'),
        'param_name' => 'hcode_tab_content_premade_style',
        'value' => array(__('Select Tab Content Style', 'hcode-addons') => '',
                         __('Tab Content1', 'hcode-addons') => 'tab-content1',
                         __('Tab Content2', 'hcode-addons') => 'tab-content2',
                         __('Tab Content3', 'hcode-addons') => 'tab-content3',
                         __('Tab Content4', 'hcode-addons') => 'tab-content4',
                         __('Tab Content5 ( Spa Treatments )', 'hcode-addons') => 'tab-content5',
                        ),
      ),
      array(
        'type' => 'hcode_preview_image',
        'heading' => __('Select pre-made style', 'hcode-addons'),
        'param_name' => 'hcode_tab_content_preview_image',
        'admin_label' => true,
        'value' => array(__('Tab content image', 'hcode-addons') => '',
                         __('Tab content image1', 'hcode-addons') => 'tab-content1',
                         __('Tab content image2', 'hcode-addons') => 'tab-content2',
                         __('Tab content image3', 'hcode-addons') => 'tab-content3',
                         __('Tab content image4', 'hcode-addons') => 'tab-content4',
                         __('Tab content image5', 'hcode-addons') => 'tab-content5',
                        ),
      ),
      /* Tab content left part */
      array(
        'type' => 'attach_image',
        'heading' => __('Left Background Image', 'hcode-addons'),
        'param_name' => 'hcode_tab_content_left_bgimage',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1','tab-content5') ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'hcode_tab_content_left_bgimage_type',
        'heading' => __('Background Image Type', 'hcode-addons' ),
        'value' => array(__('Select Background Image Type', 'hcode-addons') => '',
                         __('Fix Background', 'hcode-addons') => 'fix-background',
                         __('Cover Background', 'hcode-addons') => 'cover-background',
                        ),
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1','tab-content5') ),
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => __('Overlay Div', 'hcode-addons'),
        'param_name' => 'hcode_tab_content_left_bgimage_show_overlay',
        'value' => array(__('OFF', 'hcode-addons') => '0', 
                         __('ON', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1') ),
        'description' => __( 'Select ON to show overlay on Image', 'hcode-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Number Text', 'hcode-addons'),
        'param_name' => 'hcode_tab_content_left_number',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Title', 'hcode-addons'),
        'param_name' => 'hcode_tab_content_left_title',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'not_empty' => true ),
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => __('Show Separator', 'hcode-addons'),
        'param_name' => 'hcode_tab_content_left_title_show_separator',
        'value' => array(__('OFF', 'hcode-addons') => '0', 
                         __('ON', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content2') ),
      ),
      array(
        'type' => 'textarea',
        'heading' => __('Left Content', 'hcode-addons'),
        'param_name' => 'hcode_tab_content_left_content',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content2') ),
      ),
      /* Tab content right part */
      array(
        'type' => 'hcode_custom_switch_option',
        'heading' => __('Custom Tab Icon', 'hcode-addons'),
        'param_name' => 'custom_tab_icon',
        'value' => array(__('NO', 'hcode-addons') => '0',
                         __('YES', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1') ),
      ),
      array(
        'type' => 'attach_image',
        'heading' => __('Custom Tab Icon Image', 'hcode-addons'),
        'param_name' => 'custom_tab_icon_image',
        'dependency' => array( 'element' => 'custom_tab_icon', 'value' => '1' ),
        'description' => __( 'Recommended size: Extra Large - 60px X 60px, Large - 50px X 50px, Medium - 40px X 40px, Small - 25px X 25px, Extra Small - 18px X 18px', 'hcode-addons' ),
      ),
      array(
        'type' => 'hcode_icon',
        'heading' => __('Icon', 'hcode-addons' ),
        'param_name' => 'hcode_tab_content_right_icon',
        'dependency' => array( 'element' => 'custom_tab_icon', 'value' => '0' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => __( 'Right Title', 'hcode-addons' ),
        'param_name' => 'hcode_tab_content_right_title',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1', 'tab-content2', 'tab-content3') ),
      ),
      array(
        'type' => 'textarea_html',
        'heading' => __( 'Content', 'hcode-addons' ),
        'param_name' => 'content',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1','tab-content2','tab-content3','tab-content4','tab-content5') ),
      ),
      array(
        'type'        => 'vc_link',
        'heading'     => __('Button Config', 'hcode-addons' ),
        'param_name'  => 'hcode_tab_content_right_button_config',
        'admin_label' => true,
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1','tab-content5') ),
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => __('Show Separator Line', 'hcode-addons'),
        'param_name' => 'hcode_tab_content_left_title_show_separator_line',
        'value' => array(__('OFF', 'hcode-addons') => '0', 
                         __('ON', 'hcode-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content2', 'tab-content3') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => __( 'Bottom Title', 'hcode-addons' ),
        'param_name' => 'hcode_tab_content_bottom_title',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1', 'tab-content2', 'tab-content3') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => __( 'Counter Number1', 'hcode-addons' ),
        'param_name' => 'hcode_tab_content_counter_number1',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content2', 'tab-content4') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => __( 'Counter Text1', 'hcode-addons' ),
        'param_name' => 'hcode_tab_content_counter_text1',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content2', 'tab-content4') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => __( 'Counter Number2', 'hcode-addons' ),
        'param_name' => 'hcode_tab_content_counter_number2',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content2', 'tab-content4') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => __( 'Counter Text2', 'hcode-addons' ),
        'param_name' => 'hcode_tab_content_counter_text2',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content2', 'tab-content4') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => __( 'Counter Number3', 'hcode-addons' ),
        'param_name' => 'hcode_tab_content_counter_number3',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content2', 'tab-content4') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => __( 'Counter Text3', 'hcode-addons' ),
        'param_name' => 'hcode_tab_content_counter_text3',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content2', 'tab-content4') ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Number Color', 'hcode-addons' ),
        'param_name' => 'hcode_number_color',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Title Color', 'hcode-addons' ),
        'param_name' => 'hcode_title_color',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Icon Color', 'hcode-addons' ),
        'param_name' => 'hcode_icon_color',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Content Color', 'hcode-addons' ),
        'param_name' => 'hcode_content_color',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Button Color', 'hcode-addons' ),
        'param_name' => 'hcode_button_color',
        'dependency' => array( 'element' => 'hcode_tab_content_premade_style', 'value' => array('tab-content1') ),
        'group' => 'Style',
      ),
    ),
) );