<?php
/**
 * Map For Slider
 *
 * @package H-Code
 */
?>
<?php 
/*-----------------------------------------------------------------------------------*/
/* Slider */
/*-----------------------------------------------------------------------------------*/

vc_map( 
  array(
      'name' => __( 'Image Slider' , 'hcode-addons' ), //Name of your shortcode for human reading inside element list
      'base' => 'hcode_slider', //Shortcode tag. For [my_shortcode] shortcode base is my_shortcode
      'description' => __( 'Place an image slider', 'hcode-addons' ), //Short description of your element, it will be visible in 'Add element' window
      'class' => '', //CSS class which will be added to the shortcode's content element in the page edit screen in Visual Composer backend edit mode
      'as_parent' => array('only' => 'hcode_slide_content'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
      'icon' => 'fa fa-picture-o h-code-shortcode-icon', //URL or CSS class with icon image.
      'js_view' => 'VcColumnView',
      'category' => 'H-Code',
      'params' => array( //List of shortcode attributes. Array which holds your shortcode params, these params will be editable in shortcode settings page
          array(
              'type' => 'dropdown',
              'heading' => __('Image Slider Style', 'hcode-addons'),
              'param_name' => 'slider_premade_style',
              'admin_label' => true,
              'value' => array(__('Select a Slider Style', 'hcode-addons') => '',
                               __('Slider Style 1 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider1', 
                               __('Slider Style 2 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider2', 
                               __('Slider Style 3 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider3', 
                               __('Slider Style 4 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider4', 
                               __('Slider Style 5 - Owl Carousel Half Screen', 'hcode-addons') => 'hcode-owl-slider5', 
                               __('Slider Style 6 - Owl Carousel Half Screen', 'hcode-addons') => 'hcode-owl-slider6',
                               __('Slider Style 7 - Owl Carousel Full Screen Background Slider', 'hcode-addons') => 'hcode-owl-slider7',
                               __('Slider Style 8 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider8',
                               __('Slider Style 9 - Owl Carousel Half Screen', 'hcode-addons') => 'hcode-owl-slider9',
                               __('Slider Style 10 - Owl Carousel Full Screen Background Slider', 'hcode-addons') => 'hcode-owl-slider10',
                               __('Slider Style 11 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider11',
                               __('Slider Style 12 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider12',
                               __('Slider Style 13 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider13',
                               __('Slider Style 14 - Owl Carousel Full Screen Background Slider', 'hcode-addons') => 'hcode-owl-slider14',
                               __('Slider Style 15 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider15',
                               __('Slider Style 16 - Owl Carousel Half Screen', 'hcode-addons') => 'hcode-owl-slider16',
                               __('Slider Style 17 - Owl Carousel Fix Background', 'hcode-addons') => 'hcode-owl-slider17',
                               __('Slider Style 18 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider18',
                               __('Slider Style 19 - Owl Carousel Full Screen image tag', 'hcode-addons') => 'hcode-owl-slider19',
                               __('Slider Style 20 - Owl Carousel Content slider', 'hcode-addons') => 'hcode-owl-slider20',
                               __('Slider Style 21 - Owl Carousel project page', 'hcode-addons') => 'hcode-owl-slider21',
                               __('Slider Style 22 - Owl Carousel project page Background Slider', 'hcode-addons') => 'hcode-owl-slider22',
                               __('Slider Style 23 - Owl Carousel Full Screen', 'hcode-addons') => 'hcode-owl-slider23',
                               __('Bootstrap Slider Style 1 - Bootstrap Full Screen', 'hcode-addons') => 'hcode-bootstrap-slider1',
                               __('Bootstrap Slider Style 2 - Bootstrap Full Screen', 'hcode-addons') => 'hcode-bootstrap-slider2',
                              ),
              'description' => __('Choose a pre-made Image Slider Style', 'hcode-addons'),
          ),
          array(
              'type' => 'hcode_preview_image',
              'heading' => __('Select pre-made style', 'hcode-addons'),
              'param_name' => 'slider_preview_image',
              'admin_label' => true,
              'value' => array(__('Slider image', 'hcode-addons') => '',
                               __('Slider image1', 'hcode-addons') => 'hcode-owl-slider1',
                               __('Slider image2', 'hcode-addons') => 'hcode-owl-slider2',
                               __('Slider image3', 'hcode-addons') => 'hcode-owl-slider3',
                               __('Slider image4', 'hcode-addons') => 'hcode-owl-slider4', 
                               __('Slider image5', 'hcode-addons') => 'hcode-owl-slider5', 
                               __('Slider image6', 'hcode-addons') => 'hcode-owl-slider6',
                               __('slider image7', 'hcode-addons') => 'hcode-owl-slider7',
                               __('slider image8', 'hcode-addons') => 'hcode-owl-slider8',
                               __('slider image9', 'hcode-addons') => 'hcode-owl-slider9',
                               __('slider image10', 'hcode-addons') => 'hcode-owl-slider10',
                               __('slider image11', 'hcode-addons') => 'hcode-owl-slider11',
                               __('slider image12', 'hcode-addons') => 'hcode-owl-slider12',
                               __('slider image13', 'hcode-addons') => 'hcode-owl-slider13',
                               __('slider image14', 'hcode-addons') => 'hcode-owl-slider14',
                               __('slider image15', 'hcode-addons') => 'hcode-owl-slider15',
                               __('slider image16', 'hcode-addons') => 'hcode-owl-slider16',
                               __('slider image17', 'hcode-addons') => 'hcode-owl-slider17',
                               __('slider image18', 'hcode-addons') => 'hcode-owl-slider18',
                               __('slider image19', 'hcode-addons') => 'hcode-owl-slider19',
                               __('slider image20', 'hcode-addons') => 'hcode-owl-slider20',
                               __('slider image21', 'hcode-addons') => 'hcode-owl-slider21',
                               __('slider image22', 'hcode-addons') => 'hcode-owl-slider22',
                               __('slider image23', 'hcode-addons') => 'hcode-owl-slider23',
                               __('Bootstrap Slider image1', 'hcode-addons') => 'hcode-bootstrap-slider1', 
                               __('Bootstrap Slider image2', 'hcode-addons') => 'hcode-bootstrap-slider2',
                              ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'holder' => 'div',
                'class' => '',
                'heading' => __('Show Pagination', 'hcode-addons'),
                'param_name' => 'show_pagination',
                'value' => array(__('OFF', 'hcode-addons') => '0', 
                                 __('ON', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select ON to show pagination in slider', 'hcode-addons' ),
                'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Pagination Style', 'hcode-addons'),
              'param_name' => 'show_pagination_style',
              'admin_label' => true,
              'value' => array(__('Select Pagination Style', 'hcode-addons') => '',
                               __('Dot Style', 'hcode-addons') => '0',
                               __('Line Style', 'hcode-addons') => '1',
                               __('Round Style', 'hcode-addons') => '2',
                              ),
              'dependency' => array( 'element' => 'show_pagination', 'value' => array('1') ),
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Pagination Color Style', 'hcode-addons'),
              'param_name' => 'show_pagination_color_style',
              'admin_label' => true,
              'value' => array(__('Select Pagination Color Style', 'hcode-addons') => '',
                               __('Dark Style', 'hcode-addons') => '0',
                               __('Light Style', 'hcode-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'show_pagination', 'value' => array('1') ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'holder' => 'div',
                'class' => '',
                'heading' => __('Show Navigation', 'hcode-addons'),
                'param_name' => 'show_navigation',
                'value' => array(__('OFF', 'hcode-addons') => '0', 
                                 __('ON', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select ON to show navigation in slider', 'hcode-addons' ),
                'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Navigation Style', 'hcode-addons'),
              'param_name' => 'show_navigation_style',
              'admin_label' => true,
              'value' => array(__('Select Navigation Style', 'hcode-addons') => '',
                               __('Next/Prev Black Arrow', 'hcode-addons') => '0',
                               __('Next/Prev White Arrow', 'hcode-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'show_navigation', 'value' => array('1') ),
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Cursor Color Style', 'hcode-addons'),
              'param_name' => 'show_cursor_color_style',
              'admin_label' => true,
              'value' => array(__('Select Cursor Color Style', 'hcode-addons') => '',
                               __('White Cursor', 'hcode-addons') => 'white-cursor',
                               __('Black Cursor', 'hcode-addons') => 'black-cursor',
                               __('Default Cursor', 'hcode-addons') => 'no-cursor',
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Slide Number Text', 'hcode-addons'),
              'param_name' => 'background_slide_number',
              'admin_label' => true,
              'value' => array(__('Please Select Number Text', 'hcode-addons')  => '',
                               __('01', 'hcode-addons')  => '1',
                               __('02', 'hcode-addons')  => '2',
                               __('03', 'hcode-addons')  => '3',
                               __('04', 'hcode-addons')  => '4',
                               __('05', 'hcode-addons')  => '5',
                               __('06', 'hcode-addons')  => '6',
                               __('07', 'hcode-addons')  => '7',
                               __('08', 'hcode-addons')  => '8',
                               __('09', 'hcode-addons')  => '9',
                               __('10', 'hcode-addons') => '10',
                               __('Custom Number', 'hcode-addons') => 'custom-number',
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Number Text', 'hcode-addons'),
              'param_name' => 'background_slide_custom_number',
              'dependency' => array( 'element' => 'background_slide_number', 'value' => array('custom-number') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Title', 'hcode-addons'),
              'param_name' => 'background_slide_title',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider10','hcode-owl-slider14','hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textarea',
              'heading' => __('Subtitle', 'hcode-addons'),
              'param_name' => 'background_slide_subtitle',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider14','hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Subtitle 2', 'hcode-addons'),
              'param_name' => 'background_slide_subtitle_text',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider14','hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textarea',
              'heading' => __('Content', 'hcode-addons'),
              'param_name' => 'hcode_slider_content',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Title 1', 'hcode-addons'),
              'param_name' => 'background_slide_title1',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Subtitle 1', 'hcode-addons'),
              'param_name' => 'background_slide_subtitle1',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Title 2', 'hcode-addons'),
              'param_name' => 'background_slide_title2',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Subtitle 2', 'hcode-addons'),
              'param_name' => 'background_slide_subtitle2',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Title 3', 'hcode-addons'),
              'param_name' => 'background_slide_title3',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Specification Subtitle 3', 'hcode-addons'),
              'param_name' => 'background_slide_subtitle3',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider22') ),
              'group' => 'Background Slider Data',
          ),
          array(
              'type' => 'attach_image',
              'heading' => __('Overlay Image', 'hcode-addons'),
              'param_name' => 'modeling_image',
              'holder' => 'div',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider10') ),
              'group' => 'Background Slider Data',
          ),  
          
          array(
              'type' => 'dropdown',
              'heading' => __('Transition Style', 'hcode-addons'),
              'param_name' => 'transition_style',
              'admin_label' => true,
              'value' => array(__('Select Transition Style', 'hcode-addons') => '',
                               __('Slide Style', 'hcode-addons') => 'slide',
                               __('Fade Style', 'hcode-addons') => 'fade',
                               __('BackSlide Style', 'hcode-addons') => 'backSlide',
                               __('GoDown Style', 'hcode-addons') => 'goDown',
                               __('FadeUp Style', 'hcode-addons') => 'fadeUp'
                               
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23') ),
              'group' => 'Slider Configuration',
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'holder' => 'div',
                'class' => '',
                'heading' => __('Autoplay', 'hcode-addons'),
                'param_name' => 'autoplay',
                'value' => array(__('False', 'hcode-addons') => '0', 
                                 __('True', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select TRUE to autoplay slider', 'hcode-addons' ),
                'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
                'group' => 'Slider Configuration',
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'holder' => 'div',
                'class' => '',
                'heading' => __('Stop On Hover', 'hcode-addons'),
                'param_name' => 'stoponhover',
                'value' => array(__('False', 'hcode-addons') => '0', 
                                 __('True', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select TRUE to stop autoplay when hover on slider', 'hcode-addons' ),
                'dependency'  => array( 'element' => 'autoplay', 'value' => array('1') ),
                'group' => 'Slider Configuration',
          ),
          
          array(
              'type' => 'dropdown',
              'heading' => __('Slide Delay Time', 'hcode-addons'),
              'param_name' => 'slidespeed',
              'admin_label' => true,
              'value' => array(__('Select Slide Delay Time', 'hcode-addons') => '',
                               __('500', 'hcode-addons') => '500',
                               __('600', 'hcode-addons') => '600',
                               __('700', 'hcode-addons') => '700',
                               __('800', 'hcode-addons') => '800',
                               __('900', 'hcode-addons') => '900',
                               __('1000', 'hcode-addons') => '1000',
                               __('1100', 'hcode-addons') => '1100',
                               __('1200', 'hcode-addons') => '1200',
                               __('1300', 'hcode-addons') => '1300',
                               __('1400', 'hcode-addons') => '1400',
                               __('1500', 'hcode-addons') => '1500',
                               __('2000', 'hcode-addons') => '2000',
                               __('3000', 'hcode-addons') => '3000',
                               __('4000', 'hcode-addons') => '4000',
                               __('5000', 'hcode-addons') => '5000',
                               __('6000', 'hcode-addons') => '6000',
                               __('7000', 'hcode-addons') => '7000',
                               __('8000', 'hcode-addons') => '8000',
                               __('9000', 'hcode-addons') => '9000',
                               __('10000', 'hcode-addons') => '10000',
                              ),
              'std' => '3000',
              'description' => __('Select slide delay time (1ms = 100)', 'hcode-addons'),
              'dependency'  => array( 'element' => 'autoplay', 'value' => array('1') ),
              'group' => 'Slider Configuration',
          ),
          array(
              'type' => 'hcode_custom_switch_option',
              'heading' => __('Add Active Class', 'hcode-addons'),
              'param_name' => 'addclassactive',
              'admin_label' => true,
              'value' => array(__('False', 'hcode-addons') => '0', 
                               __('True', 'hcode-addons') => '1'
                              ),
              'description' => __('Select TRUE to add active class', 'hcode-addons'),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23') ),
              'group' => 'Slider Configuration',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Title Color', 'hcode-addons' ),
            'param_name' => 'background_slide_title_color',
            'description' => __( 'Choose Title Color', 'hcode-addons' ),
            'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider10','hcode-owl-slider14','hcode-owl-slider22') ),
            'group' => 'Color',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Subtitle Color', 'hcode-addons' ),
            'param_name' => 'background_slide_subtitle_color',
            'description' => __( 'Choose Subtitle Color', 'hcode-addons' ),
            'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider7','hcode-owl-slider14','hcode-owl-slider22') ),
            'group' => 'Color',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Background Color', 'hcode-addons' ),
            'param_name' => 'background_slide_bg_color',
            'description' => __( 'Choose Background Color', 'hcode-addons' ),
            'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider10', 'hcode-owl-slider22') ),
            'group' => 'Color',
          ),
          array(
             'type'        => 'textfield',
             'heading'     => __('Slider ID', 'hcode-addons' ),
             'description' => 'Optional - Define element id (The id attribute specifies a unique id for an HTML element)',
             'param_name'  => 'hcode_slider_id',
             'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
             'group'       => 'Slider ID & Class'
          ),
          array(
             'type'        => 'textfield',
             'heading'     => __('Slider Extra Class', 'hcode-addons' ),
             'description' => 'Optional - add additional CSS class to this element, you can define multiple CSS class with use of space like "Class1 Class2"',
             'param_name'  => 'hcode_slider_class',
             'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('hcode-owl-slider1','hcode-owl-slider2','hcode-owl-slider3','hcode-owl-slider4','hcode-owl-slider5','hcode-owl-slider6','hcode-owl-slider7','hcode-owl-slider8','hcode-owl-slider9','hcode-owl-slider10','hcode-owl-slider11','hcode-owl-slider12','hcode-owl-slider13','hcode-owl-slider14','hcode-owl-slider15','hcode-owl-slider16','hcode-owl-slider17','hcode-owl-slider18','hcode-owl-slider19','hcode-owl-slider20','hcode-owl-slider21','hcode-owl-slider22','hcode-owl-slider23','hcode-bootstrap-slider1','hcode-bootstrap-slider2') ),
             'group'       => 'Slider ID & Class'
          ),
      ),
  )
);
vc_map( 
  array(
      'name' => __('Add Slide', 'hcode-addons'),
      'base' => 'hcode_slide_content',
      'description' => __( 'A slide for the image slider', 'hcode-addons' ),
      'as_child' => array('only' => 'hcode_slider'), // Use only|except attributes to limit parent (separate multiple values with comma)
      'icon' => 'fa fa-picture-o h-code-shortcode-icon', //URL or CSS class with icon image.
      'params' => array(
          array(
              'type' => 'attach_image',
              'heading' => __('Slide Image', 'hcode-addons'),
              'param_name' => 'image',
              'holder' => 'div'
          ),
          array(
              'type' => 'textfield',
              'heading' => __('Title', 'hcode-addons'),
              'param_name' => 'title',
              'description' => __('Notes: It will only apply if your selected image slider style contains the title', 'hcode-addons'),
          ),
          array(
              'type' => 'textarea_html',
              'heading' => __('Content', 'hcode-addons'),
              'param_name' => 'content',
              'description' => __('Notes: It will only apply if your selected image slider style contains the content', 'hcode-addons'),
          ),
          array(
              'type' => 'dropdown',
              'heading' => __('Choose Button', 'hcode-addons'),
              'param_name' => 'no_button',
              'admin_label' => true,
              'value' => array(__('No Button', 'hcode-addons') => 'nobutton',
                               __('One Button', 'hcode-addons') => 'singlebutton',
                               __('Two Buttons', 'hcode-addons') => 'twobutton',
                              ),
              'description' => __('Hide/show buttons in slide (Notes: It will only apply if your selected image slider style contains the button)', 'hcode-addons'),
          ),
          array(
            'type'        => 'vc_link',
            'heading'     => __('Button 1 Configuration', 'hcode-addons' ),
            'param_name'  => 'first_button_config',
            'admin_label' => true,
            'dependency'  => array( 'element' => 'no_button', 'value' => array('singlebutton','twobutton') ),
          ),

          array(
            'type'        => 'vc_link',
            'heading'     => __('Button 2 Configuration', 'hcode-addons' ),
            'param_name'  => 'second_button_config',
            'admin_label' => true,
            'dependency'  => array( 'element' => 'no_button', 'value' => array('twobutton') ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Title Color', 'hcode-addons' ),
            'param_name' => 'hcode_title_color',
            'description' => __( 'Choose Title Color', 'hcode-addons' ),
            'group' => 'Color',
          ),
          $hcode_vc_extra_id,
          $hcode_vc_extra_class,

        ),
    ) 
);
/* Main Slider class*/
if(class_exists('WPBakeryShortCodesContainer')){ 
  class WPBakeryShortCode_hcode_slider extends WPBakeryShortCodesContainer { }
}
if(class_exists('WPBakeryShortCode')){
  class WPBakeryShortCode_hcode_slide_content extends WPBakeryShortCode { }
}