<?php
/**
 * Map For Parallax
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Parallax */
/*-----------------------------------------------------------------------------------*/

vc_map( array(
  'name' => __('Parallax', 'hcode-addons'),
  'icon' => 'fa fa-exchange h-code-shortcode-icon',
  'base' => 'hcode_parallax',
  'category' => 'H-Code',
  'description' => __( 'Create a parallax section', 'hcode-addons' ),
  'params' => array(
      array(
        'type' => 'dropdown',
        'holder' => 'div',
        'class' => '',
        'heading' => __('Style', 'hcode-addons'),
        'param_name' => 'hcode_parallax_style',
        'value' => array(__('Select Style', 'hcode-addons') => '',
                         __('Parallax', 'hcode-addons') => 'parallax',
                         __('Parallax with Description', 'hcode-addons') => 'portfolio-with-desc',
        ),
      ),
      array(
          'type' => 'hcode_preview_image',
          'heading' => __('Select pre-made style', 'hcode-addons'),
          'param_name' => 'slider_parallax_preview_image',
          'admin_label' => true,
          'value' => array(__('Slider Style', 'hcode-addons') => '',
                           __('Parallax', 'hcode-addons') => 'parallax',
                           __('Parallax with Description', 'hcode-addons') => 'portfolio-with-desc',
                          ),
      ),
      array(
        'type' => 'hcode_multiple_portfolio_categories',
        'heading' => __('Select Categories', 'hcode-addons'),
        'param_name' => 'hcode_categories_list',
         'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
      ),
      array(
          'type' => 'textfield',
          'heading' => __('No. of Post Per Page', 'hcode-addons'),
          'param_name' => 'hcode_post_per_page',
          'value'     => '10',
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Excerpt', 'hcode-addons'),
          'param_name' => 'hcode_show_excerpt',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show excerpt, no to show full content', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('portfolio-with-desc')),
      ),
      array(
          'type'        => 'textfield',
          'heading'     => __('Excerpt Length', 'hcode-addons' ),
          'description' => __( 'Enter numaric value like 20', 'hcode-addons' ),
          'param_name'  => 'hcode_excerpt_length',
          'value'     => '15',
          'dependency'  => array( 'element' => 'hcode_show_excerpt', 'value' => array('1') ),
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Button', 'hcode-addons'),
          'param_name' => 'hcode_show_button',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
      ),
      array(
          'type'        => 'vc_link',
          'heading'     => __('Button Link', 'hcode-addons' ),
          'param_name'  => 'hcode_button_link',
          'admin_label' => true,
          'dependency'  => array( 'element' => 'hcode_show_button', 'value' => array('1') ),
      ),
      array(
          'type'        => 'checkbox',
          'heading'     => __('Enable Separator', 'hcode-addons' ),
          'param_name'  => 'hcode_seperater',
          'value'       => array( 'Enable Separator' => '1'),
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('portfolio-with-desc') )
      ),
      array(
        'type' => 'dropdown',
        'heading' => __( 'Display Items Order by', 'hcode-addons' ),
        'param_name' => 'orderby',
        'value' => array(__('Select Order by', 'hcode-addons') => '',
                         __( 'Date', 'hcode-addons' ) => 'date',
                         __( 'ID', 'hcode-addons' ) => 'ID',
                         __( 'Author', 'hcode-addons' ) => 'author',
                         __( 'Title', 'hcode-addons' ) => 'title',
                         __( 'Modified', 'hcode-addons' ) => 'modified',
                         __( 'Random', 'hcode-addons' ) => 'rand',
                         __( 'Comment count', 'hcode-addons' ) => 'comment_count',
                         __( 'Menu order', 'hcode-addons' ) => 'menu_order',
                        ),
        'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
        'group' => 'Order'
      ),
      array(
        'type' => 'dropdown',
        'heading' => __( 'Display Items Sort by', 'hcode-addons' ),
        'param_name' => 'order',
        'value' => array(__('Select Sort by', 'hcode-addons') => '',
                         __( 'Descending', 'hcode-addons' ) => 'DESC',
                         __( 'Ascending', 'hcode-addons' ) => 'ASC',
                        ),
        'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
        'group' => 'Order'
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'holder' => 'div',
          'class' => '',
          'heading' => __('Required Padding Setting?', 'hcode-addons'),
          'param_name' => 'padding_setting',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('portfolio-with-desc') ),
          'group' => 'Style',
      ),
      array(
          'type' => 'dropdown',
          'param_name' => 'desktop_padding',
          'heading' => __('Padding (For Desktop Device)', 'hcode-addons' ),
          'value' => $hcode_desktop_padding,
          'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
          'group' => 'Style',
      ),
      array(
          'type' => 'textfield',
          'heading' => __('Custom Padding (For All Devices)', 'hcode-addons' ),
          'param_name' => 'custom_desktop_padding',
          'dependency' => array( 'element' => 'desktop_padding', 'value' => array('custom-desktop-padding') ),
          'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
          'group' => 'Style',
      ),
      array(
          'type' => 'dropdown',
          'param_name' => 'ipad_padding',
          'heading' => __('Padding (For iPad Device)', 'hcode-addons' ),
          'value' => $hcode_ipad_padding,
          'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
          'group' => 'Style',
      ),
      array(
          'type' => 'dropdown',
          'param_name' => 'mobile_padding',
          'heading' => __('Padding (For Mobile Device)', 'hcode-addons' ),
          'value' => $hcode_mobile_padding,
          'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
          'group' => 'Style',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'holder' => 'div',
          'class' => '',
          'heading' => __('Required Margin Setting?', 'hcode-addons'),
          'param_name' => 'margin_setting',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('portfolio-with-desc') ),
          'group' => 'Style',
      ),
      array(
          'type' => 'dropdown',
          'param_name' => 'desktop_margin',
          'heading' => __('Margin (For Desktop Device)', 'hcode-addons' ),
          'value' => $hcode_desktop_margin,
          'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
          'group' => 'Style',
      ),
      array(
          'type' => 'textfield',
          'heading' => __('Custom Margin (For All Devices)', 'hcode-addons' ),
          'param_name' => 'custom_desktop_margin',
          'dependency' => array( 'element' => 'desktop_margin', 'value' => array('custom-desktop-margin') ),
          'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
          'group' => 'Style',
      ),
      array(
          'type' => 'dropdown',
          'param_name' => 'ipad_margin',
          'heading' => __('Margin (For iPad Device)', 'hcode-addons' ),
          'value' => $hcode_ipad_margin,
          'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
          'group' => 'Style',
      ),

      array(
          'type' => 'dropdown',
          'param_name' => 'mobile_margin',
          'heading' => __('Margin (For Mobile Device)', 'hcode-addons' ),
          'value' => $hcode_mobile_margin,
          'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
          'group' => 'Style',
      ),
      array(
          'type' => 'dropdown',
          'param_name' => 'hcode_animation_style',
          'heading' => __('Animation Type', 'hcode-addons' ),
          'value' => hcode_animation_style(),
          'group' => 'Animation',
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('portfolio-with-desc') )
      ),
      $hcode_vc_extra_id,
      $hcode_vc_extra_class,
  )
) );