<?php
/**
 * Map For Column
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Column */
/*-----------------------------------------------------------------------------------*/

vc_map( 
  array(
      'name' => __( 'Column' , 'hcode-addons' ),
      'base' => 'vc_column',
      'description' => __( 'Place content elements inside the column', 'hcode-addons' ),
      'icon' => 'fa fa-columns h-code-shortcode-icon',
      'is_container' => true,
      'content_element' => false,
      'category' => 'H-Code',
      'js_view' => 'VcColumnView',
      'params' => array(
          array(
            'type' => 'hcode_custom_switch_option',
            'holder' => 'div',
            'class' => '',
            'heading' => __('Alignment Setting', 'hcode-addons'),
            'param_name' => 'alignment_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'description' => __( 'Select Yes to set div in alignment of column', 'hcode-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'desktop_alignment',
            'heading' => __('Alignment (For Desktop Device)', 'hcode-addons' ),
            'value' => array(__('No Align', 'hcode-addons') => '',
                             __('Left Align', 'hcode-addons') => 'text-left',
                             __('Right Align', 'hcode-addons') => 'text-right',
                             __('Center Align', 'hcode-addons') => 'text-center',
                            ),
            'dependency' => array( 'element' => 'alignment_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'ipad_alignment',
            'heading' => __('Alignment (For iPad/Tablet Device)', 'hcode-addons' ),
            'value' => array(__('No Align', 'hcode-addons') => '',
                             __('Left Align', 'hcode-addons') => 'sm-text-left',
                             __('Right Align', 'hcode-addons') => 'sm-text-right',
                             __('Center Align', 'hcode-addons') => 'sm-text-center',
                            ),
            'dependency' => array( 'element' => 'alignment_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'mobile_alignment',
            'heading' => __('Alignment (For Mobile Device)', 'hcode-addons' ),
            'value' => array(__('No Align', 'hcode-addons') => '',
                             __('Left Align', 'hcode-addons') => 'xs-text-left',
                             __('Right Align', 'hcode-addons') => 'xs-text-right',
                             __('Center Align', 'hcode-addons') => 'xs-text-center',
                            ),
            'dependency' => array( 'element' => 'alignment_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'holder' => 'div',
            'class' => '',
            'heading' => __('Required Padding Setting?', 'hcode-addons'),
            'param_name' => 'padding_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'desktop_padding',
            'heading' => __('Padding (For Desktop Device)', 'hcode-addons' ),
            'value' => $hcode_desktop_padding,
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Padding (For All Devices)', 'hcode-addons' ),
            'param_name' => 'custom_desktop_padding',
            'dependency' => array( 'element' => 'desktop_padding', 'value' => array('custom-desktop-padding') ),
            'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),

          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'ipad_padding',
            'heading' => __('Padding (For iPad Device)', 'hcode-addons' ),
            'value' => $hcode_ipad_padding,
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'mobile_padding',
            'heading' => __('Padding (For Mobile Device)', 'hcode-addons' ),
            'value' => $hcode_mobile_padding,
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'holder' => 'div',
            'class' => '',
            'heading' => __('Required Margin Setting?', 'hcode-addons'),
            'param_name' => 'margin_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'desktop_margin',
            'heading' => __('Margin (For Desktop Device)', 'hcode-addons' ),
            'value' => $hcode_desktop_margin,
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Margin (For All Devices)', 'hcode-addons' ),
            'param_name' => 'custom_desktop_margin',
            'dependency' => array( 'element' => 'desktop_margin', 'value' => array('custom-desktop-margin') ),
            'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'ipad_margin',
            'heading' => __('Margin (For iPad Device)', 'hcode-addons' ),
            'value' => $hcode_ipad_margin,
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'mobile_margin',
            'heading' => __('Margin (For Mobile Device)', 'hcode-addons' ),
            'value' => $hcode_mobile_margin,
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'holder' => 'div',
            'class' => '',
            'heading' => __('Required Display Settings?', 'hcode-addons'),
            'param_name' => 'display_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'desktop_display',
            'heading' => __('Display Setting (For Desktop Device)', 'hcode-addons' ),
            'value' => array(__('Select Display Type', 'hcode-addons') => '',
                             __('Block', 'hcode-addons') => 'display-block',
                             __('Inline', 'hcode-addons') => 'display-inline',
                             __('Inline Block', 'hcode-addons') => 'display-inline-block',
                             __('None', 'hcode-addons') => 'display-none',
                            ),
            'dependency' => array( 'element' => 'display_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'ipad_display',
            'heading' => __('Display Setting (For iPad/Tablet Device)', 'hcode-addons' ),
            'value' => array(__('Select Display Type', 'hcode-addons') => '',
                             __('Block', 'hcode-addons') => 'sm-display-block',
                             __('Inline', 'hcode-addons') => 'sm-display-inline',
                             __('Inline Block', 'hcode-addons') => 'sm-display-inline-block',
                             __('None', 'hcode-addons') => 'sm-display-none',
                            ),
            'dependency' => array( 'element' => 'display_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'mobile_display',
            'heading' => __('Display Setting (For Mobile Device)', 'hcode-addons' ),
            'value' => array(__('Select Display Type', 'hcode-addons') => '',
                             __('Block', 'hcode-addons') => 'xs-display-block',
                             __('Inline', 'hcode-addons') => 'xs-display-inline',
                             __('Inline Block', 'hcode-addons') => 'xs-display-inline-block',
                             __('None', 'hcode-addons') => 'xs-display-none',
                            ),
            'dependency' => array( 'element' => 'display_setting', 'value' => array('1') ),
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'holder' => 'div',
            'class' => '',
            'heading' => __('Centralized Div', 'hcode-addons'),
            'param_name' => 'centralized_div',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'description' => __( 'Select Yes to show div in center of column', 'hcode-addons' ),
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'holder' => 'div',
            'class' => '',
            'heading' => __('Column with Clear both', 'hcode-addons'),
            'param_name' => 'clear_both',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'description' => __( 'Select Yes to set div in clear both of column', 'hcode-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'desktop_clear_both',
            'heading' => __('Clear both (For Desktop Device)', 'hcode-addons' ),
            'value' => array(__('No clear both', 'hcode-addons') => '',
                             __('Clear both', 'hcode-addons') => 'clear-both',
                             __('Clear none', 'hcode-addons') => 'clear-none',
                            ),
            'dependency' => array( 'element' => 'clear_both', 'value' => array('1') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'ipad_clear_both',
            'heading' => __('Clear both (For iPad/Tablet Device)', 'hcode-addons' ),
            'value' => array(__('No clear both', 'hcode-addons') => '',
                             __('Clear both', 'hcode-addons') => 'sm-clear-both',
                             __('Clear none', 'hcode-addons') => 'sm-clear-none',
                            ),
            'dependency' => array( 'element' => 'clear_both', 'value' => array('1') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'mobile_clear_both',
            'heading' => __('Clear both (For Mobile Device)', 'hcode-addons' ),
            'value' => array(__('No clear both', 'hcode-addons') => '',
                             __('Clear both', 'hcode-addons') => 'xs-clear-both',
                             __('Clear none', 'hcode-addons') => 'xs-clear-none',
                            ),
            'dependency' => array( 'element' => 'clear_both', 'value' => array('1') ),
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'holder' => 'div',
            'class' => '',
            'heading' => __('Column Pull Right', 'hcode-addons'),
            'param_name' => 'pull_right',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'description' => __( 'Select yes to set float right', 'hcode-addons' ),
          ),
          array(
            'type' => 'textfield',
            'param_name' => 'min_height',
            'heading' => __('Set Min Height', 'hcode-addons' ),
            'value' => '',
            'description' => __( 'Define min height like 500px', 'hcode-addons' ),
          ),
          array(
            'type' => 'textfield',
            'heading' => __( 'Z Index', 'hcode-addons'),
            'param_name' => 'hcode_z_index',
          ),
          array(
            'type' => 'dropdown',
            'heading' => __('SM Width', 'hcode-addons' ),
            'param_name' => 'width',
            'value' => $hcode_vc_column,
            'group' => 'Responsive Options',
            'description' => 'Select column width',
          ),
          array(
            'type' => 'column_offset',
            'heading' => __('Responsiveness', 'hcode-addons' ),
            'param_name' => 'offset',
            'group' => 'Responsive Options',
            'description' => 'Adjust column for different screen sizes. Control width, offset and visibility settings.',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Column BackGround Color', 'hcode-addons' ),
            'param_name' => 'hcode_column_bg_color',
            'group' => 'Style',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_column_animation_style',
            'heading' => __('Animation Style', 'hcode-addons' ),
            'value' => hcode_animation_style(),
            'group' => 'Animation',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Animation Duration', 'hcode-addons' ),
            'param_name' => 'hcode_column_animation_duration',
            'dependency' => array( 'element' => 'hcode_column_animation_style', 'not_empty' => true ),
            'description' => __( 'Add duration like 300ms', 'hcode-addons' ),
            'group' => 'Animation',
          ),
          array(
              'type' => 'hcode_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => __('Fullscreen Class', 'hcode-addons'),
              'param_name' => 'fullscreen',
              'value' => array(__('NO', 'hcode-addons') => '0', 
                               __('YES', 'hcode-addons') => '1'
                              ),
              'description' => __( 'Select Yes to add (fullscreen) class in section', 'hcode-addons' ),
          ),
          array(
            'type' => 'css_editor',
            'heading' => __( 'Css box', 'hcode-addons' ),
            'param_name' => 'css',
            'group' => __( 'Design options', 'hcode-addons' ),
          ),
          $hcode_vc_extra_id,
          $hcode_vc_extra_class,
      ),
  )
);